/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.CacheConfig;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ScopedCacheFactoryBuilder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageDisabledMember
implements SessionBuilder {
    private static final Logger LOGGER = Logger.getLogger(StorageDisabledMember.class.getName());
    private final OptionsByType m_optionsByType;

    public StorageDisabledMember() {
        this(new Option[0]);
    }

    public StorageDisabledMember(Option[] aOption) {
        this.m_optionsByType = OptionsByType.of((Option[])aOption);
    }

    @Override
    public ConfigurableCacheFactory build(LocalPlatform platform, CoherenceCluster cluster, OptionsByType optionsByType) {
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        optionsByType = OptionsByType.of((OptionsByType)optionsByType);
        optionsByType.add((Option)RoleName.of((String)"client"));
        optionsByType.add((Option)LocalStorage.disabled());
        optionsByType.addAll(this.m_optionsByType);
        optionsByType.addIfAbsent((Option)CacheConfig.of((String)"coherence-cache-config.xml"));
        CoherenceClusterMember.MetaClass metaClass = new CoherenceClusterMember.MetaClass();
        for (Profile profile : optionsByType.getInstancesOf(Profile.class)) {
            profile.onLaunching((Platform)platform, (MetaClass)metaClass, optionsByType);
        }
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        Properties properties = systemProperties.resolve((Platform)platform, optionsByType);
        Table systemPropertiesTable = new Table(new Row[0]);
        systemPropertiesTable.getOptions().add((Option)Table.orderByColumn((int)0));
        systemPropertiesTable.getOptions().add((Option)Cell.Separator.of((String)""));
        systemPropertiesTable.getOptions().add((Option)Cell.DisplayNull.asEmptyString());
        for (String sName : properties.stringPropertyNames()) {
            String sValue = properties.getProperty(sName);
            String sSuffix = System.getProperties().containsKey(sName) ? "*" : "";
            systemPropertiesTable.addRow(new String[]{sName + sSuffix, sValue});
            System.setProperty(sName, sValue);
        }
        diagnosticsTable.addRow(new String[]{"System Properties", systemPropertiesTable.toString()});
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Storage Disabled Member...\n------------------------------------------------------------------------\n" + diagnosticsTable + "\n------------------------------------------------------------------------\n");
        }
        String uriConfig = ((CacheConfig)optionsByType.get(CacheConfig.class, new Object[0])).getUri();
        ClassLoader loader = this.getClass().getClassLoader();
        ConfigurableCacheFactory session = new ScopedCacheFactoryBuilder().getConfigurableCacheFactory(uriConfig, loader);
        CacheFactory.ensureCluster();
        return session;
    }

    public boolean equals(Object other) {
        return other instanceof StorageDisabledMember;
    }

    public int hashCode() {
        return StorageDisabledMember.class.hashCode();
    }
}

