/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ThrowableCausedByMatcher<T extends Throwable>
extends TypeSafeMatcher<T> {
    private Matcher<? super Throwable> matcher;

    private ThrowableCausedByMatcher(Matcher<? super Throwable> matcher) {
        this.matcher = matcher;
    }

    public static <T extends Throwable> ThrowableCausedByMatcher<T> causedBy(Matcher<? super Throwable> matcher) {
        return new ThrowableCausedByMatcher<T>(matcher);
    }

    protected boolean matchesSafely(T t) {
        for (Object throwable = t; throwable != null; throwable = ((Throwable)throwable).getCause()) {
            if (!this.matcher.matches((Object)((Throwable)throwable).getCause())) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("throwable caused by ");
        this.matcher.describeTo(description);
    }
}

