/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.runtime.java.SimpleJavaApplication;
import com.oracle.bedrock.testsupport.junit.JUnitTestListener;
import com.oracle.bedrock.testsupport.junit.JUnitTestRun;
import com.oracle.bedrock.testsupport.junit.JUnitTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleJUnitTestRun
extends SimpleJavaApplication
implements JUnitTestRun {
    private final List<JUnitTestListener> runListeners = new ArrayList<JUnitTestListener>();

    public SimpleJUnitTestRun(Platform platform, JavaApplicationProcess process, OptionsByType optionsByType) {
        super(platform, process, optionsByType);
        for (JUnitTestListener listener : optionsByType.getInstancesOf(JUnitTestListener.class)) {
            this.runListeners.add(listener);
        }
        this.addListener(new EventListener(), new Option[]{JUnitTestRunner.STREAM_NAME});
    }

    public List<JUnitTestListener> getRunListeners() {
        return Collections.unmodifiableList(this.runListeners);
    }

    @Override
    public void startTests(OptionsByType optionsByType) {
        this.submit(new JUnitTestRunner.StartTests(optionsByType), new Option[0]);
    }

    protected void fireJUnitStarted(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.junitStarted(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireJUnitCompleted(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.junitCompleted(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestRunStarted(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testRunStarted(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestRunFinished(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testRunFinished(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestClassStarted(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testClassStarted(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestClassFinished(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testClassFinished(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestStarted(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testStarted(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestSucceeded(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testSucceeded(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestIgnored(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testIgnored(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestFailure(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testFailed(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestError(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testError(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireTestAssumptionFailure(JUnitTestListener.Event event) {
        for (JUnitTestListener listener : this.runListeners) {
            try {
                listener.testAssumptionFailure(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class EventListener
    implements RemoteEventListener {
        private EventListener() {
        }

        public void onEvent(RemoteEvent event) {
            if (SimpleJUnitTestRun.this.runListeners.isEmpty()) {
                return;
            }
            JUnitTestListener.Event jUnitEvent = (JUnitTestListener.Event)event;
            switch (jUnitEvent.getType()) {
                case JUnitStarted: {
                    SimpleJUnitTestRun.this.fireJUnitStarted(jUnitEvent);
                    break;
                }
                case JUnitCompleted: {
                    SimpleJUnitTestRun.this.fireJUnitCompleted(jUnitEvent);
                    break;
                }
                case testRunStarted: {
                    SimpleJUnitTestRun.this.fireTestRunStarted(jUnitEvent);
                    break;
                }
                case testRunFinished: {
                    SimpleJUnitTestRun.this.fireTestRunFinished(jUnitEvent);
                    break;
                }
                case testClassStarted: {
                    SimpleJUnitTestRun.this.fireTestClassStarted(jUnitEvent);
                    break;
                }
                case testClassFinished: {
                    SimpleJUnitTestRun.this.fireTestClassFinished(jUnitEvent);
                    break;
                }
                case testStarted: {
                    SimpleJUnitTestRun.this.fireTestStarted(jUnitEvent);
                    break;
                }
                case testSuccess: {
                    SimpleJUnitTestRun.this.fireTestSucceeded(jUnitEvent);
                    break;
                }
                case testIgnored: {
                    SimpleJUnitTestRun.this.fireTestIgnored(jUnitEvent);
                    break;
                }
                case testAssumptionFailure: {
                    SimpleJUnitTestRun.this.fireTestAssumptionFailure(jUnitEvent);
                    break;
                }
                case testFailure: {
                    SimpleJUnitTestRun.this.fireTestFailure(jUnitEvent);
                    break;
                }
                case testError: {
                    SimpleJUnitTestRun.this.fireTestError(jUnitEvent);
                }
            }
        }
    }
}

