/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import java.io.File;

public class PlatformSeparators
implements Option {
    private String fileSeparator;
    private String pathSeparator;
    private String lineSeparator;

    private PlatformSeparators(String fileSeparator, String pathSeparator, String lineSeparator) {
        this.fileSeparator = fileSeparator;
        this.pathSeparator = pathSeparator;
        this.lineSeparator = lineSeparator;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String asPlatformFileName(String fileName) {
        return fileName == null ? null : fileName.replace(File.separator, this.getFileSeparator());
    }

    public String asSanitizedFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(fileName.length());
        String valid = "1234567890abcdefghijklmnopqrstuvwxyz.~" + File.separatorChar + this.getFileSeparator();
        char last = '\u0000';
        fileName = fileName.toLowerCase();
        for (char c : fileName.toCharArray()) {
            if (valid.indexOf(c) < 0) {
                last = '-';
                continue;
            }
            if (last == '-' && builder.length() > 0) {
                builder.append(last);
            }
            last = c;
            builder.append(c);
        }
        return builder.toString().toLowerCase();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformSeparators)) {
            return false;
        }
        PlatformSeparators that = (PlatformSeparators)other;
        if (!this.fileSeparator.equals(that.fileSeparator)) {
            return false;
        }
        if (!this.lineSeparator.equals(that.lineSeparator)) {
            return false;
        }
        return this.pathSeparator.equals(that.pathSeparator);
    }

    public int hashCode() {
        int result = this.fileSeparator.hashCode();
        result = 31 * result + this.pathSeparator.hashCode();
        result = 31 * result + this.lineSeparator.hashCode();
        return result;
    }

    @OptionsByType.Default
    public static PlatformSeparators autoDetect() {
        return new PlatformSeparators(File.separator, File.pathSeparator, System.lineSeparator());
    }

    public static PlatformSeparators custom(String fileSeparator, String pathSeparator, String lineSeparator) {
        return new PlatformSeparators(fileSeparator, pathSeparator, lineSeparator);
    }

    public static PlatformSeparators forWindows() {
        return new PlatformSeparators("\\", ";", "\r\n");
    }

    public static PlatformSeparators forUnix() {
        return new PlatformSeparators("/", ":", "\n");
    }

    public static PlatformSeparators forCygwin() {
        return new PlatformSeparators("/", ":", "\n");
    }
}

