/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class IPv4Preferred
implements Profile,
Option {
    public static final String JAVA_NET_PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    private boolean preferred;

    private IPv4Preferred(boolean preferred) {
        this.preferred = preferred;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public static IPv4Preferred preferred(boolean preferred) {
        return new IPv4Preferred(preferred);
    }

    public static IPv4Preferred yes() {
        return IPv4Preferred.preferred(true);
    }

    public static IPv4Preferred no() {
        return IPv4Preferred.preferred(false);
    }

    @OptionsByType.Default
    public static IPv4Preferred autoDetect() {
        return IPv4Preferred.preferred(Boolean.getBoolean(JAVA_NET_PREFER_IPV4_STACK));
    }

    @Override
    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of(JAVA_NET_PREFER_IPV4_STACK, this.preferred, new Option[0]));
            optionsByType.add((Option)systemProperties);
        }
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    @Override
    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPv4Preferred)) {
            return false;
        }
        IPv4Preferred that = (IPv4Preferred)o;
        return this.preferred == that.preferred;
    }

    public int hashCode() {
        return this.preferred ? 1 : 0;
    }
}

