/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.container;

import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.java.container.AbstractContainerScope;
import com.oracle.bedrock.runtime.java.container.ContainerMBeanServerBuilder;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Properties;

@Internal
public class ContainerScope
extends AbstractContainerScope {
    private PipedOutputStream stdoutPipedOutputStream;
    private PipedInputStream stdoutPipedInputStream;
    private boolean redirectErrorStream;
    private PipedOutputStream stderrPipedOutputStream;
    private PipedInputStream stderrPipedInputStream;
    private PipedOutputStream stdinPipedOutputStream;
    private PipedInputStream stdinPipedInputStream;
    private ContainerMBeanServerBuilder mBeanServerBuilder;
    private Object remoteChannel;

    public ContainerScope(String name) {
        this(name, new Properties(), LocalPlatform.get().getAvailablePorts(), null, false, 16384);
    }

    public ContainerScope(String name, Properties properties) {
        this(name, properties, LocalPlatform.get().getAvailablePorts(), null, false, 16384);
    }

    public ContainerScope(String name, Properties properties, AvailablePortIterator availablePorts, ContainerMBeanServerBuilder mBeanServerBuilder, boolean redirectErrorStream, int pipeBufferSizeBytes) {
        super(name, properties, availablePorts, mBeanServerBuilder);
        this.redirectErrorStream = redirectErrorStream;
        try {
            this.stdoutPipedOutputStream = new PipedOutputStream();
            this.stdoutPipedInputStream = new PipedInputStream(this.stdoutPipedOutputStream, pipeBufferSizeBytes);
            this.stdout = new PrintStream(this.stdoutPipedOutputStream);
            if (redirectErrorStream) {
                this.stderrPipedOutputStream = null;
                this.stderrPipedInputStream = null;
                this.stderr = this.stdout;
            } else {
                this.stderrPipedOutputStream = new PipedOutputStream();
                this.stderrPipedInputStream = new PipedInputStream(this.stderrPipedOutputStream, pipeBufferSizeBytes);
                this.stderr = new PrintStream(this.stderrPipedOutputStream);
            }
            this.stdinPipedOutputStream = new PipedOutputStream();
            this.stdinPipedInputStream = new PipedInputStream(this.stdinPipedOutputStream, pipeBufferSizeBytes);
            this.stdin = this.stdinPipedInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not establish i/o pipes for the ContainerScope [" + this.getName() + "]", e);
        }
        this.mBeanServerBuilder = mBeanServerBuilder == null ? new ContainerMBeanServerBuilder(this.availablePorts) : mBeanServerBuilder;
        this.remoteChannel = null;
    }

    public InputStream getStandardOutputInputStream() {
        return this.stdoutPipedInputStream;
    }

    public InputStream getStandardErrorInputStream() {
        if (this.redirectErrorStream) {
            throw new UnsupportedOperationException("The Standard Error Stream has been redirected to the Standard Output Stream");
        }
        return this.stderrPipedInputStream;
    }

    public OutputStream getStandardInputOutputStream() {
        return this.stdinPipedOutputStream;
    }

    public void setRemoteChannel(Object remoteChannel) {
        this.remoteChannel = remoteChannel;
    }

    public Object getRemoteChannel() {
        return this.remoteChannel;
    }

    @Override
    public boolean close() {
        if (super.close()) {
            try {
                this.stdoutPipedOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdoutPipedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.redirectErrorStream) {
                try {
                    this.stderrPipedOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.stderrPipedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.stderr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.stdinPipedOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdinPipedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdin.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

