/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.java.container.Container;
import com.oracle.bedrock.runtime.java.container.Scope;
import com.oracle.bedrock.runtime.java.io.NullReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

public class SystemApplicationConsole
implements ApplicationConsole {
    private PrintWriter m_outputWriter;
    private PrintWriter m_errorWriter;
    private Reader m_inputReader;

    public SystemApplicationConsole() {
        this.init(Container.getPlatformScope());
    }

    void init(Scope scope) {
        this.m_outputWriter = new PrintWriter(scope.getStandardOutput()){

            @Override
            public void close() {
            }
        };
        this.m_errorWriter = new PrintWriter(scope.getStandardError()){

            @Override
            public void close() {
            }
        };
        this.m_inputReader = new NullReader();
    }

    @Override
    public void close() {
        this.m_outputWriter.close();
        this.m_errorWriter.close();
        try {
            this.m_inputReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public PrintWriter getOutputWriter() {
        return this.m_outputWriter;
    }

    @Override
    public PrintWriter getErrorWriter() {
        return this.m_errorWriter;
    }

    @Override
    public Reader getInputReader() {
        return this.m_inputReader;
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        return true;
    }

    public static ApplicationConsoleBuilder builder() {
        return new ApplicationConsoleBuilder(){

            @Override
            public ApplicationConsole build(String applicationName) {
                return new SystemApplicationConsole();
            }
        };
    }
}

