/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.console.AbstractPipedApplicationConsole;
import com.oracle.bedrock.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;

public class EventsApplicationConsole
extends AbstractPipedApplicationConsole {
    private final ConcurrentLinkedQueue<Pair<Predicate<String>, Listener>> stdoutListeners = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Pair<Predicate<String>, Listener>> stderrListeners = new ConcurrentLinkedQueue();
    private final Thread stdoutThread = new Thread(new OutputCaptor(this.stdoutReader, this.stdoutListeners));
    private final Thread stderrThread = new Thread(new OutputCaptor(this.stderrReader, this.stderrListeners));

    public EventsApplicationConsole() {
        super(1024, false);
        this.stdoutThread.start();
        this.stderrThread.start();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.stdoutThread.join();
            this.stderrThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public EventsApplicationConsole withStdOutListener(Listener listener) {
        return this.withStdOutListener(line -> true, listener);
    }

    public EventsApplicationConsole withStdOutListener(Predicate<String> predicate, Listener listener) {
        if (predicate == null) {
            this.stdoutListeners.add((Pair<Predicate<String>, Listener>)new Pair(line -> true, (Object)listener));
        } else {
            this.stdoutListeners.add((Pair<Predicate<String>, Listener>)new Pair(predicate, (Object)listener));
        }
        return this;
    }

    public EventsApplicationConsole withStdErrListener(Listener listener) {
        return this.withStdErrListener(line -> true, listener);
    }

    public EventsApplicationConsole withStdErrListener(Predicate<String> predicate, Listener listener) {
        if (predicate == null) {
            this.stderrListeners.add((Pair<Predicate<String>, Listener>)new Pair(line -> true, (Object)listener));
        } else {
            this.stderrListeners.add((Pair<Predicate<String>, Listener>)new Pair(predicate, (Object)listener));
        }
        return this;
    }

    public PrintWriter getInputWriter() {
        return this.stdinWriter;
    }

    class OutputCaptor
    implements Runnable {
        BufferedReader reader;
        ConcurrentLinkedQueue<Pair<Predicate<String>, Listener>> listeners;

        OutputCaptor(BufferedReader reader, ConcurrentLinkedQueue<Pair<Predicate<String>, Listener>> listeners) {
            this.reader = reader;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    for (Pair<Predicate<String>, Listener> pair : this.listeners) {
                        try {
                            if (!((Predicate)pair.getX()).test(line)) continue;
                            ((Listener)pair.getY()).onOutput(line);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    line = this.reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void onOutput(String var1);
    }

    public static class CountDownListener
    extends CountDownLatch
    implements Listener {
        public CountDownListener(int count) {
            super(count);
        }

        @Override
        public void onOutput(String line) {
            this.countDown();
        }
    }
}

