/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent.runnable;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.options.ApplicationClosingBehavior;

public class RuntimeHalt
implements RemoteRunnable,
ApplicationClosingBehavior<JavaApplication> {
    private int exitCode;

    public RuntimeHalt() {
        this(0);
    }

    private RuntimeHalt(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public void run() {
        System.out.println("Terminating Application using Runtime.halt(" + this.exitCode + ")");
        Runtime.getRuntime().halt(this.exitCode);
    }

    @Override
    public void onBeforeClosing(JavaApplication application, Option ... options) {
        try {
            application.submit(this, new Option[0]);
            application.waitFor(options);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuntimeHalt)) {
            return false;
        }
        RuntimeHalt that = (RuntimeHalt)other;
        return this.exitCode == that.exitCode;
    }

    public int hashCode() {
        return this.exitCode;
    }

    public static RuntimeHalt withExitCode(int exitCode) {
        return new RuntimeHalt(exitCode);
    }
}

