/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.AbstractAssembly;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.AssemblyBuilder;
import com.oracle.bedrock.runtime.Infrastructure;
import java.util.LinkedList;

@Internal
public abstract class AbstractAssemblyBuilder<A extends Application, G extends AbstractAssembly<A>, B extends AbstractAssemblyBuilder<A, G, B>>
implements AssemblyBuilder<A, G, B> {
    protected LinkedList<Characteristics<A>> characteristics = new LinkedList();
    protected OptionsByType optionsByType = OptionsByType.empty();

    @Override
    public B with(Option ... options) {
        this.optionsByType = OptionsByType.of((Option[])options);
        return this.castThis();
    }

    @Override
    public B include(int count, Class<? extends A> applicationClass, Option ... options) {
        if (count > 0) {
            this.characteristics.add(new Characteristics<A>(count, applicationClass, options));
        }
        return this.castThis();
    }

    @Override
    public G build(Infrastructure infrastructure, Option ... options) {
        G assembly = this.createAssembly(OptionsByType.of((OptionsByType)this.optionsByType));
        for (Characteristics characteristics : this.characteristics) {
            int instanceCount = characteristics.getCount();
            Class applicationClass = characteristics.getApplicationClass();
            OptionsByType launchOptions = OptionsByType.of((Option[])characteristics.getOptions()).addAll(options);
            ((AbstractAssembly)assembly).expand(instanceCount, infrastructure, applicationClass, launchOptions.asArray());
        }
        return assembly;
    }

    public abstract G createAssembly(OptionsByType var1);

    private B castThis() {
        return (B)this;
    }

    protected static class Characteristics<A extends Application> {
        private final int count;
        private final Class<? extends A> applicationClass;
        private final Option[] options;

        public Characteristics(int count, Class<? extends A> applicationClass, Option ... options) {
            this.count = count;
            this.applicationClass = applicationClass;
            this.options = options;
        }

        public int getCount() {
            return this.count;
        }

        public Class<? extends A> getApplicationClass() {
            return this.applicationClass;
        }

        public Option[] getOptions() {
            return this.options;
        }
    }
}

