/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.user_profile;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.user_profile.UserProfileCacheUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

class UserProfileCache {
    @NonNull
    @VisibleForTesting
    protected final DiskCache diskCache;
    @NonNull
    private final Logger logger;
    @NonNull
    private final Map<String, Map<String, Object>> memoryCache;
    @NonNull
    private final LegacyDiskCache legacyDiskCache;

    UserProfileCache(@NonNull DiskCache diskCache, @NonNull Logger logger, @NonNull Map<String, Map<String, Object>> memoryCache, @NonNull LegacyDiskCache legacyDiskCache) {
        this.logger = logger;
        this.diskCache = diskCache;
        this.memoryCache = memoryCache;
        this.legacyDiskCache = legacyDiskCache;
    }

    void clear() {
        this.memoryCache.clear();
        this.diskCache.save(this.memoryCache);
        this.logger.info("User profile cache cleared.");
    }

    @Nullable
    Map<String, Object> lookup(String userId) {
        if (userId == null) {
            this.logger.error("Unable to lookup user profile because user ID was null.");
            return null;
        }
        if (userId.isEmpty()) {
            this.logger.error("Unable to lookup user profile because user ID was empty.");
            return null;
        }
        return this.memoryCache.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void migrateLegacyUserProfiles() {
        JSONObject legacyUserProfilesJson = this.legacyDiskCache.load();
        if (legacyUserProfilesJson == null) {
            this.logger.info("No legacy user profiles to migrate.");
            return;
        }
        try {
            Iterator userIdIterator = legacyUserProfilesJson.keys();
            while (userIdIterator.hasNext()) {
                String userId = (String)userIdIterator.next();
                JSONObject legacyUserProfileJson = legacyUserProfilesJson.getJSONObject(userId);
                ConcurrentHashMap experimentBucketMap = new ConcurrentHashMap();
                Iterator experimentIdIterator = legacyUserProfileJson.keys();
                while (experimentIdIterator.hasNext()) {
                    String experimentId = (String)experimentIdIterator.next();
                    String variationId = legacyUserProfileJson.getString(experimentId);
                    ConcurrentHashMap<String, String> decisionMap = new ConcurrentHashMap<String, String>();
                    decisionMap.put("variation_id", variationId);
                    experimentBucketMap.put(experimentId, decisionMap);
                }
                ConcurrentHashMap<String, Object> userProfileMap = new ConcurrentHashMap<String, Object>();
                userProfileMap.put("user_id", userId);
                userProfileMap.put("experiment_bucket_map", experimentBucketMap);
                this.save(userProfileMap);
            }
        }
        catch (JSONException e) {
            this.logger.warn("Unable to deserialize legacy user profiles. Will delete legacy user profile cache file.", (Throwable)e);
        }
        finally {
            this.legacyDiskCache.delete();
        }
    }

    void remove(String userId) {
        if (userId == null) {
            this.logger.error("Unable to remove user profile because user ID was null.");
        } else if (userId.isEmpty()) {
            this.logger.error("Unable to remove user profile because user ID was empty.");
        } else if (this.memoryCache.containsKey(userId)) {
            this.memoryCache.remove(userId);
            this.diskCache.save(this.memoryCache);
            this.logger.info("Removed user profile for {}.", (Object)userId);
        }
    }

    void remove(String userId, String experimentId) {
        if (userId == null) {
            this.logger.error("Unable to remove decision because user ID was null.");
        } else if (userId.isEmpty()) {
            this.logger.error("Unable to remove decision because user ID was empty.");
        } else if (experimentId == null) {
            this.logger.error("Unable to remove decision because experiment ID was null.");
        } else if (experimentId.isEmpty()) {
            this.logger.error("Unable to remove decision because experiment ID was empty.");
        } else {
            ConcurrentHashMap experimentBucketMap;
            Map<String, Object> userProfileMap = this.memoryCache.get(userId);
            if (userProfileMap != null && (experimentBucketMap = (ConcurrentHashMap)userProfileMap.get("experiment_bucket_map")).containsKey(experimentId)) {
                experimentBucketMap.remove(experimentId);
                this.diskCache.save(this.memoryCache);
                this.logger.info("Removed decision for experiment {} from user profile for {}.", (Object)experimentId, (Object)userId);
            }
        }
    }

    public void removeInvalidExperiments(Set<String> validExperimentIds) {
        for (String userId : this.memoryCache.keySet()) {
            Map<String, Object> maps = this.memoryCache.get(userId);
            ConcurrentHashMap experimentBucketMap = (ConcurrentHashMap)maps.get("experiment_bucket_map");
            if (experimentBucketMap == null || experimentBucketMap.keySet().size() <= 100) continue;
            for (String experimentId : experimentBucketMap.keySet()) {
                if (validExperimentIds.contains(experimentId)) continue;
                experimentBucketMap.remove(experimentId);
            }
        }
        this.diskCache.save(this.memoryCache);
    }

    void save(Map<String, Object> userProfileMap) {
        String userId = (String)userProfileMap.get("user_id");
        if (userId == null) {
            this.logger.error("Unable to save user profile because user ID was null.");
        } else if (userId.isEmpty()) {
            this.logger.error("Unable to save user profile because user ID was empty.");
        } else {
            this.memoryCache.put(userId, userProfileMap);
            this.diskCache.save(this.memoryCache);
            this.logger.info("Saved user profile for {}.", (Object)userId);
        }
    }

    void start() {
        this.migrateLegacyUserProfiles();
        try {
            JSONObject userProfilesJson = this.diskCache.load();
            Map<String, Map<String, Object>> userProfilesMap = UserProfileCacheUtils.convertJSONObjectToMap(userProfilesJson);
            this.memoryCache.clear();
            this.memoryCache.putAll(userProfilesMap);
            this.logger.info("Loaded user profile cache from disk.");
        }
        catch (Exception e) {
            this.clear();
            this.logger.error("Unable to parse user profile cache from disk.", (Throwable)e);
        }
    }

    static class LegacyDiskCache {
        private static final String FILE_NAME = "optly-user-profile-%s.json";
        @NonNull
        private final Cache cache;
        @NonNull
        private final Executor executor;
        @NonNull
        private final Logger logger;
        @NonNull
        private final String projectId;

        LegacyDiskCache(@NonNull Cache cache, @NonNull Executor executor, @NonNull Logger logger, @NonNull String projectId) {
            this.cache = cache;
            this.executor = executor;
            this.logger = logger;
            this.projectId = projectId;
        }

        @VisibleForTesting
        String getFileName() {
            return String.format(FILE_NAME, this.projectId);
        }

        @Nullable
        JSONObject load() {
            String cacheString = this.cache.load(this.getFileName());
            if (cacheString == null) {
                this.logger.info("Legacy user profile cache not found.");
                return null;
            }
            try {
                return new JSONObject(cacheString);
            }
            catch (JSONException e) {
                this.logger.warn("Unable to parse legacy user profiles. Will delete legacy user profile cache file.", (Throwable)e);
                this.delete();
                return null;
            }
        }

        @TargetApi(value=11)
        void delete() {
            AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){

                protected Boolean doInBackground(Void[] params) {
                    Boolean deleted = cache.delete(this.getFileName());
                    if (deleted.booleanValue()) {
                        logger.info("Deleted legacy user profile from disk.");
                    } else {
                        logger.warn("Unable to delete legacy user profile from disk.");
                    }
                    return deleted;
                }
            };
            task.executeOnExecutor(this.executor, (Object[])new Void[0]);
        }
    }

    static class DiskCache {
        private static final String FILE_NAME = "optly-user-profile-service-%s.json";
        @NonNull
        private final Cache cache;
        @NonNull
        private final Executor executor;
        @NonNull
        private final Logger logger;
        @NonNull
        private final String projectId;

        public DiskCache(@NonNull Cache cache, @NonNull Executor executor, @NonNull Logger logger, @NonNull String projectId) {
            this.cache = cache;
            this.executor = executor;
            this.logger = logger;
            this.projectId = projectId;
        }

        String getFileName() {
            return String.format(FILE_NAME, this.projectId);
        }

        @NonNull
        JSONObject load() throws JSONException {
            String cacheString = this.cache.load(this.getFileName());
            if (cacheString == null) {
                this.logger.warn("Unable to load user profile cache from disk.");
                return new JSONObject();
            }
            return new JSONObject(cacheString);
        }

        @TargetApi(value=11)
        void save(final Map<String, Map<String, Object>> userProfilesMap) {
            AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){

                protected Boolean doInBackground(Void[] params) {
                    JSONObject userProfilesJson;
                    try {
                        userProfilesJson = UserProfileCacheUtils.convertMapToJSONObject(userProfilesMap);
                    }
                    catch (Exception e) {
                        logger.error("Unable to serialize user profiles to save to disk.", (Throwable)e);
                        return false;
                    }
                    boolean saved = cache.save(this.getFileName(), userProfilesJson.toString());
                    if (saved) {
                        logger.info("Saved user profiles to disk.");
                    } else {
                        logger.warn("Unable to save user profiles to disk.");
                    }
                    return saved;
                }
            };
            task.executeOnExecutor(this.executor, (Object[])new Void[0]);
        }
    }
}

