/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect;

import org.jetbrains.annotations.NotNull;

public class DetectedLanguage
implements Comparable<DetectedLanguage> {
    @NotNull
    private String language;
    private double probability;

    public DetectedLanguage(@NotNull String language, double probability) {
        if (probability < 0.0) {
            throw new IllegalArgumentException("Probability must be >= 0 but was " + probability);
        }
        if (probability > 1.0) {
            throw new IllegalArgumentException("Probability must be <= 1 but was " + probability);
        }
        this.language = language;
        this.probability = probability;
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public double getProbability() {
        return this.probability;
    }

    public String toString() {
        return "DetectedLanguage[" + this.language + ":" + this.probability + "]";
    }

    @Override
    public int compareTo(DetectedLanguage o) {
        int compare = Double.compare(o.probability, this.probability);
        if (compare != 0) {
            return compare;
        }
        return this.language.compareTo(o.language);
    }
}

