/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class LangProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MINIMUM_FREQ = 2;
    private static final int LESS_FREQ_RATIO = 100000;
    private String name = null;
    private Map<String, Integer> freq = new HashMap<String, Integer>();
    private int[] nWords = new int[3];

    public LangProfile() {
    }

    public LangProfile(String name) {
        this.setName(name);
    }

    public void add(@NotNull String gram) {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        int len = gram.length();
        if (len < 1 || len > 3) {
            throw new IllegalArgumentException("ngram length must be 1-3 but was " + len + ": >>>" + gram + "<<<!");
        }
        int n = len - 1;
        this.nWords[n] = this.nWords[n] + 1;
        if (this.freq.containsKey(gram)) {
            this.freq.put(gram, this.freq.get(gram) + 1);
        } else {
            this.freq.put(gram, 1);
        }
    }

    public void omitLessFreq() {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        int threshold = this.nWords[0] / 100000;
        if (threshold < 2) {
            threshold = 2;
        }
        Set<String> keys = this.freq.keySet();
        int roman = 0;
        Iterator<String> i = keys.iterator();
        while (i.hasNext()) {
            String key = i.next();
            int count = this.freq.get(key);
            if (count <= threshold) {
                int n = key.length() - 1;
                this.nWords[n] = this.nWords[n] - count;
                i.remove();
                continue;
            }
            if (!key.matches("^[A-Za-z]$")) continue;
            roman += count;
        }
        if (roman < this.nWords[0] / 3) {
            Set<String> keys2 = this.freq.keySet();
            Iterator<String> i2 = keys2.iterator();
            while (i2.hasNext()) {
                String key = i2.next();
                if (!key.matches(".*[A-Za-z].*")) continue;
                int n = key.length() - 1;
                this.nWords[n] = this.nWords[n] - this.freq.get(key);
                i2.remove();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Integer> getFreq() {
        return this.freq;
    }

    public void setFreq(HashMap<String, Integer> freq) {
        this.freq = freq;
    }

    public int[] getNWords() {
        return this.nWords;
    }

    public void setNWords(int[] nWords) {
        this.nWords = nWords;
    }
}

