/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import android.support.annotation.Nullable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.otwebrtc.GlUtil;
import org.otwebrtc.Logging;
import org.otwebrtc.RendererCommon;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.YuvHelper;

public class VideoFrameDrawer {
    public static final String TAG = "VideoFrameDrawer";
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    @Nullable
    private VideoFrame lastI420Frame;
    private final Matrix renderMatrix = new Matrix();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void drawTexture(RendererCommon.GlDrawer glDrawer, VideoFrame.TextureBuffer textureBuffer, Matrix object, int n, int n2, int n3, int n4, int n5, int n6) {
        void var8_9;
        void var7_8;
        void var6_7;
        void var5_6;
        void var4_5;
        void var3_4;
        Matrix matrix = new Matrix(textureBuffer.getTransformMatrix());
        matrix.preConcat(object);
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
        int n7 = 1.$SwitchMap$org$otwebrtc$VideoFrame$TextureBuffer$Type[textureBuffer.getType().ordinal()];
        if (n7 != 1) {
            if (n7 != 2) throw new RuntimeException("Unknown texture type.");
            glDrawer.drawRgb(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
            return;
        } else {
            glDrawer.drawOes(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
        }
    }

    private static int distance(float f2, float f3, float f4, float f5) {
        return (int)Math.round(Math.hypot(f4 - f2, f5 - f3));
    }

    private void calculateTransformedRenderSize(int n, int n2, @Nullable Matrix matrix) {
        if (matrix == null) {
            VideoFrameDrawer videoFrameDrawer = this;
            videoFrameDrawer.renderWidth = n;
            videoFrameDrawer.renderHeight = n2;
            return;
        }
        matrix.mapPoints(((VideoFrameDrawer)this).dstPoints, srcPoints);
        for (int i2 = 0; i2 < 3; ++i2) {
            float[] fArray = ((VideoFrameDrawer)this).dstPoints;
            int n3 = i2 * 2;
            int n4 = n3 + 0;
            fArray[n4] = ((VideoFrameDrawer)this).dstPoints[n4] * (float)n;
            fArray[++n3] = ((VideoFrameDrawer)this).dstPoints[n3] * (float)n2;
        }
        VideoFrameDrawer videoFrameDrawer = this;
        Object object = this = (Object)videoFrameDrawer.dstPoints;
        Object object2 = object[1];
        Object object3 = object[2];
        Object object4 = object[3];
        videoFrameDrawer.renderWidth = VideoFrameDrawer.distance(videoFrameDrawer.dstPoints[0], (float)object2, (float)object3, (float)object4);
        float[] fArray = videoFrameDrawer.dstPoints;
        float f2 = fArray[1];
        object3 = fArray[4];
        object4 = fArray[5];
        videoFrameDrawer.renderHeight = VideoFrameDrawer.distance(videoFrameDrawer.dstPoints[0], f2, (float)object3, (float)object4);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer) {
        this.drawFrame(videoFrame, glDrawer, null);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix) {
        VideoFrame videoFrame2 = videoFrame;
        int n = videoFrame2.getRotatedWidth();
        int n2 = videoFrame2.getRotatedHeight();
        this.drawFrame(videoFrame, glDrawer, matrix, 0, 0, n, n2);
    }

    public void drawFrame(VideoFrame object, RendererCommon.GlDrawer glDrawer, @Nullable Matrix matrix, int n, int n2, int n3, int n4) {
        VideoFrameDrawer videoFrameDrawer = object2;
        VideoFrame videoFrame = object;
        int n5 = videoFrame.getRotatedWidth();
        videoFrameDrawer.calculateTransformedRenderSize(n5, videoFrame.getRotatedHeight(), matrix);
        if (videoFrameDrawer.renderWidth > 0 && ((VideoFrameDrawer)object2).renderHeight > 0) {
            Object object2;
            n5 = ((VideoFrame)object).getBuffer() instanceof VideoFrame.TextureBuffer;
            VideoFrameDrawer videoFrameDrawer2 = object2;
            videoFrameDrawer2.renderMatrix.reset();
            videoFrameDrawer2.renderMatrix.preTranslate(0.5f, 0.5f);
            if (n5 == 0) {
                ((VideoFrameDrawer)object2).renderMatrix.preScale(1.0f, -1.0f);
            }
            VideoFrameDrawer videoFrameDrawer3 = object2;
            videoFrameDrawer3.renderMatrix.preRotate((float)((VideoFrame)object).getRotation());
            videoFrameDrawer3.renderMatrix.preTranslate(-0.5f, -0.5f);
            if (matrix != null) {
                ((VideoFrameDrawer)object2).renderMatrix.preConcat(matrix);
            }
            if (n5 != 0) {
                VideoFrameDrawer videoFrameDrawer4 = object2;
                ((VideoFrameDrawer)object2).lastI420Frame = null;
                object2 = (VideoFrame.TextureBuffer)((VideoFrame)object).getBuffer();
                object = videoFrameDrawer4.renderMatrix;
                int n6 = videoFrameDrawer4.renderWidth;
                int n7 = videoFrameDrawer4.renderHeight;
                VideoFrameDrawer.drawTexture(glDrawer, (VideoFrame.TextureBuffer)object2, (Matrix)object, n6, n7, n, n2, n3, n4);
            } else {
                if (object != ((VideoFrameDrawer)object2).lastI420Frame) {
                    ((VideoFrameDrawer)object2).lastI420Frame = object;
                    VideoFrame.I420Buffer i420Buffer = ((VideoFrame)object).getBuffer().toI420();
                    ((VideoFrameDrawer)object2).yuvUploader.uploadFromBuffer(i420Buffer);
                    i420Buffer.release();
                }
                VideoFrameDrawer videoFrameDrawer5 = object2;
                object2 = videoFrameDrawer5.yuvUploader.getYuvTextures();
                object = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(videoFrameDrawer5.renderMatrix);
                int n8 = videoFrameDrawer5.renderWidth;
                int n9 = videoFrameDrawer5.renderHeight;
                glDrawer.drawYuv((int[])object2, (float[])object, n8, n9, n, n2, n3, n4);
            }
            return;
        }
        Logging.w(TAG, "Illegal frame size: " + ((VideoFrameDrawer)object2).renderWidth + "x" + ((VideoFrameDrawer)object2).renderHeight);
    }

    public VideoFrame.Buffer prepareBufferForViewportSize(VideoFrame.Buffer buffer, int n, int n2) {
        VideoFrame.Buffer buffer2 = buffer;
        buffer2.retain();
        return buffer2;
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
    }

    private static class YuvUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] yuvTextures;

        private YuvUploader() {
        }

        @Nullable
        public int[] uploadYuvData(int n, int n2, int[] nArray, ByteBuffer[] byteBufferArray) {
            ByteBuffer byteBuffer;
            int n3;
            int[] nArray2 = new int[3];
            int[] nArray3 = nArray2;
            nArray3[0] = n;
            nArray2[1] = n /= 2;
            nArray2[2] = n;
            int[] nArray4 = new int[3];
            int[] nArray5 = nArray4;
            nArray5[0] = n2;
            nArray4[1] = n2 /= 2;
            nArray4[2] = n2;
            n2 = 0;
            for (n3 = 0; n3 < 3; ++n3) {
                if (nArray[n3] <= nArray3[n3]) continue;
                n2 = Math.max(n2, nArray3[n3] * nArray5[n3]);
            }
            if (n2 > 0 && ((byteBuffer = this.copyBuffer) == null || byteBuffer.capacity() < n2)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n2);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n2 = 0; n2 < 3; ++n2) {
                    this.yuvTextures[n2] = GlUtil.generateTexture(3553);
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                int n4;
                ByteBuffer byteBuffer2;
                GLES20.glActiveTexture((int)(n2 + 33984));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n2]);
                if (nArray[n2] == nArray3[n2]) {
                    byteBuffer2 = byteBufferArray[n2];
                } else {
                    n3 = nArray[n2];
                    ByteBuffer byteBuffer3 = this.copyBuffer;
                    n4 = nArray3[n2];
                    int n5 = nArray3[n2];
                    int n6 = nArray5[n2];
                    YuvHelper.copyPlane(byteBufferArray[n2], n3, byteBuffer3, n4, n5, n6);
                    byteBuffer2 = this.copyBuffer;
                }
                int n7 = nArray3[n2];
                n4 = nArray5[n2];
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n7, (int)n4, (int)0, (int)6409, (int)5121, (Buffer)byteBuffer2);
            }
            return this.yuvTextures;
        }

        @Nullable
        public int[] uploadFromBuffer(VideoFrame.I420Buffer i420Buffer) {
            YuvUploader yuvUploader = object;
            VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
            int[] nArray = new int[3];
            Object object = nArray;
            object[0] = i420Buffer.getStrideY();
            object[1] = i420Buffer.getStrideU();
            nArray[2] = i420Buffer.getStrideV();
            ByteBuffer[] byteBufferArray = new ByteBuffer[3];
            ByteBuffer[] byteBufferArray2 = byteBufferArray;
            byteBufferArray2[0] = i420Buffer.getDataY();
            byteBufferArray2[1] = i420Buffer.getDataU();
            byteBufferArray[2] = i420Buffer.getDataV();
            int n = i420Buffer2.getWidth();
            return yuvUploader.uploadYuvData(n, i420Buffer2.getHeight(), (int[])object, byteBufferArray2);
        }

        @Nullable
        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            YuvUploader yuvUploader = this;
            yuvUploader.copyBuffer = null;
            int[] nArray = yuvUploader.yuvTextures;
            if (yuvUploader.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])nArray, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

