/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import org.otwebrtc.EglBase;
import org.otwebrtc.GlUtil;
import org.otwebrtc.Logging;
import org.otwebrtc.RendererCommon;
import org.otwebrtc.TextureBufferImpl;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.TimestampAligner;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoSink;
import org.otwebrtc.YuvConverter;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final TextureBufferImpl.RefCountMonitor textureRefCountMonitor = new TextureBufferImpl.RefCountMonitor(){

        @Override
        public void onRetain(TextureBufferImpl textureBufferImpl) {
            if (SurfaceTextureHelper.this.frameRefMonitor != null) {
                SurfaceTextureHelper.this.frameRefMonitor.onRetainBuffer(textureBufferImpl);
            }
        }

        @Override
        public void onRelease(TextureBufferImpl textureBufferImpl) {
            if (SurfaceTextureHelper.this.frameRefMonitor != null) {
                SurfaceTextureHelper.this.frameRefMonitor.onReleaseBuffer(textureBufferImpl);
            }
        }

        @Override
        public void onDestroy(TextureBufferImpl textureBufferImpl) {
            2 v0 = this;
            v0.SurfaceTextureHelper.this.returnTextureFrame();
            if (v0.SurfaceTextureHelper.this.frameRefMonitor != null) {
                SurfaceTextureHelper.this.frameRefMonitor.onDestroyBuffer(textureBufferImpl);
            }
        }
    };
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter;
    @Nullable
    private final TimestampAligner timestampAligner;
    private final FrameRefMonitor frameRefMonitor;
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture;
    private volatile boolean isTextureInUse;
    private boolean isQuitting;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            3 v0 = this;
            Logging.d(SurfaceTextureHelper.TAG, "Setting listener to " + SurfaceTextureHelper.this.pendingListener);
            SurfaceTextureHelper surfaceTextureHelper = v0.SurfaceTextureHelper.this;
            SurfaceTextureHelper.access$402(surfaceTextureHelper, surfaceTextureHelper.pendingListener);
            SurfaceTextureHelper.access$302(v0.SurfaceTextureHelper.this, null);
            if (v0.SurfaceTextureHelper.this.hasPendingTexture) {
                3 v2 = this;
                v2.SurfaceTextureHelper.this.updateTexImage();
                SurfaceTextureHelper.access$502(v2.SurfaceTextureHelper.this, false);
            }
        }
    };

    public static SurfaceTextureHelper create(final String string, final EglBase.Context context, final boolean bl, final YuvConverter yuvConverter, final FrameRefMonitor frameRefMonitor) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string).start();
        final Handler handler2 = handler;
        return ThreadUtils.invokeAtFrontUninterruptibly(new Handler(handlerThread2.getLooper()), new Callable<SurfaceTextureHelper>(){

            @Override
            @Nullable
            public SurfaceTextureHelper call() {
                EglBase.Context context2;
                1 v7;
                1 v6;
                1 v5;
                1 v4;
                SurfaceTextureHelper surfaceTextureHelper;
                SurfaceTextureHelper surfaceTextureHelper2;
                try {
                    SurfaceTextureHelper surfaceTextureHelper3;
                    surfaceTextureHelper2 = surfaceTextureHelper3;
                    surfaceTextureHelper = surfaceTextureHelper3;
                    1 v3 = this;
                    v4 = v3;
                    v5 = v3;
                    v6 = v3;
                    v7 = v3;
                    context2 = v3.context;
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(SurfaceTextureHelper.TAG, string + " create failure", runtimeException);
                    return null;
                }
                Handler handler = v5.handler2;
                boolean bl2 = v6.bl;
                YuvConverter yuvConverter2 = v7.yuvConverter;
                FrameRefMonitor frameRefMonitor2 = v4.frameRefMonitor;
                surfaceTextureHelper2(context2, handler, bl2, yuvConverter2, frameRefMonitor2);
                return surfaceTextureHelper;
            }
        });
    }

    public static SurfaceTextureHelper create(String object, EglBase.Context context) {
        YuvConverter yuvConverter;
        String string = object;
        object = yuvConverter;
        yuvConverter = new YuvConverter();
        return SurfaceTextureHelper.create(string, context, false, (YuvConverter)object, null);
    }

    public static SurfaceTextureHelper create(String object, EglBase.Context context, boolean bl) {
        YuvConverter yuvConverter;
        String string = object;
        object = yuvConverter;
        yuvConverter = new YuvConverter();
        return SurfaceTextureHelper.create(string, context, bl, (YuvConverter)object, null);
    }

    public static SurfaceTextureHelper create(String string, EglBase.Context context, boolean bl, YuvConverter yuvConverter) {
        return SurfaceTextureHelper.create(string, context, bl, yuvConverter, null);
    }

    private SurfaceTextureHelper(EglBase.Context context, Handler handler, boolean bl, YuvConverter yuvConverter, FrameRefMonitor frameRefMonitor) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            SurfaceTexture surfaceTexture2;
            TimestampAligner timestampAligner;
            this.handler = handler;
            if (bl) {
                TimestampAligner timestampAligner2;
                timestampAligner = timestampAligner2;
                timestampAligner2 = new TimestampAligner();
            } else {
                timestampAligner = null;
            }
            this.timestampAligner = timestampAligner;
            this.yuvConverter = yuvConverter;
            this.frameRefMonitor = frameRefMonitor;
            this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
            try {
                this.eglBase.createDummyPbufferSurface();
                this.eglBase.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                this.eglBase.release();
                handler.getLooper().quit();
                throw runtimeException;
            }
            this.oesTextureId = GlUtil.generateTexture(36197);
            EglBase.Context context2 = context = surfaceTexture2;
            super(this.oesTextureId);
            this.surfaceTexture = context2;
            SurfaceTextureHelper.setOnFrameAvailableListener(surfaceTexture2, surfaceTexture -> {
                this.hasPendingTexture = true;
                this.tryDeliverTextureFrame();
            }, handler);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener);
        }
    }

    private void returnTextureFrame() {
        this.handler.post(() -> {
            this.isTextureInUse = false;
            if (this.isQuitting) {
                this.release();
            } else {
                this.tryDeliverTextureFrame();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
            return;
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isQuitting && this.hasPendingTexture && !this.isTextureInUse && this.listener != null) {
                if (this.textureWidth != 0 && this.textureHeight != 0) {
                    VideoFrame videoFrame;
                    TextureBufferImpl textureBufferImpl;
                    SurfaceTextureHelper surfaceTextureHelper = this;
                    surfaceTextureHelper.isTextureInUse = true;
                    surfaceTextureHelper.hasPendingTexture = false;
                    surfaceTextureHelper.updateTexImage();
                    float[] fArray = new float[16];
                    surfaceTextureHelper.surfaceTexture.getTransformMatrix(fArray);
                    long l = surfaceTextureHelper.surfaceTexture.getTimestamp();
                    Object object = surfaceTextureHelper.timestampAligner;
                    if (object != null) {
                        l = ((TimestampAligner)object).translateTimestamp(l);
                    }
                    object = textureBufferImpl;
                    SurfaceTextureHelper surfaceTextureHelper2 = this;
                    SurfaceTextureHelper surfaceTextureHelper3 = this;
                    int n = surfaceTextureHelper3.textureWidth;
                    int n2 = surfaceTextureHelper3.textureHeight;
                    VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.OES;
                    int n3 = surfaceTextureHelper3.oesTextureId;
                    Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
                    Handler handler = surfaceTextureHelper2.handler;
                    YuvConverter yuvConverter = surfaceTextureHelper2.yuvConverter;
                    TextureBufferImpl.RefCountMonitor refCountMonitor = surfaceTextureHelper2.textureRefCountMonitor;
                    textureBufferImpl = new TextureBufferImpl(n, n2, type, n3, matrix, handler, yuvConverter, refCountMonitor);
                    Object object2 = this.frameRefMonitor;
                    if (object2 != null) {
                        object2.onNewBuffer((VideoFrame.TextureBuffer)object);
                    }
                    object2 = videoFrame;
                    ((VideoFrame)object2)((VideoFrame.Buffer)object, this.frameRotation, l);
                    this.listener.onFrame((VideoFrame)object2);
                    videoFrame.release();
                    return;
                }
                Logging.w(TAG, "Texture size has not been set.");
                return;
            }
            return;
        }
        throw new IllegalStateException("Wrong thread.");
    }

    private void release() {
        if (((SurfaceTextureHelper)((Object)timestampAligner)).handler.getLooper().getThread() == Thread.currentThread()) {
            if (!((SurfaceTextureHelper)((Object)timestampAligner)).isTextureInUse && ((SurfaceTextureHelper)((Object)timestampAligner)).isQuitting) {
                SurfaceTextureHelper surfaceTextureHelper = timestampAligner;
                surfaceTextureHelper.yuvConverter.release();
                int[] nArray = new int[1];
                int[] nArray2 = nArray;
                nArray[0] = ((SurfaceTextureHelper)((Object)timestampAligner)).oesTextureId;
                GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
                surfaceTextureHelper.surfaceTexture.release();
                surfaceTextureHelper.eglBase.release();
                surfaceTextureHelper.handler.getLooper().quit();
                TimestampAligner timestampAligner = surfaceTextureHelper.timestampAligner;
                if (timestampAligner != null) {
                    timestampAligner.dispose();
                }
                return;
            }
            throw new IllegalStateException("Unexpected release.");
        }
        throw new IllegalStateException("Wrong thread.");
    }

    static /* synthetic */ VideoSink access$402(SurfaceTextureHelper surfaceTextureHelper, VideoSink videoSink) {
        surfaceTextureHelper.listener = videoSink;
        return videoSink;
    }

    static /* synthetic */ VideoSink access$302(SurfaceTextureHelper surfaceTextureHelper, VideoSink videoSink) {
        surfaceTextureHelper.pendingListener = videoSink;
        return videoSink;
    }

    static /* synthetic */ boolean access$502(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.hasPendingTexture = bl;
        return bl;
    }

    public void startListening(VideoSink videoSink) {
        if (this.listener == null && this.pendingListener == null) {
            this.pendingListener = videoSink;
            this.handler.post(this.setListenerRunnable);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
    }

    public void stopListening() {
        SurfaceTextureHelper surfaceTextureHelper = this;
        Logging.d(TAG, "stopListening()");
        surfaceTextureHelper.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(surfaceTextureHelper.handler, () -> {
            SurfaceTextureHelper surfaceTextureHelper = this;
            surfaceTextureHelper.listener = null;
            surfaceTextureHelper.pendingListener = null;
        });
    }

    public void setTextureSize(int n, int n2) {
        if (n > 0) {
            if (n2 > 0) {
                SurfaceTextureHelper surfaceTextureHelper = this;
                surfaceTextureHelper.surfaceTexture.setDefaultBufferSize(n, n2);
                surfaceTextureHelper.handler.post(() -> {
                    this.textureWidth = n;
                    this.textureHeight = n2;
                    this.tryDeliverTextureFrame();
                });
                return;
            }
            throw new IllegalArgumentException("Texture height must be positive, but was " + n2);
        }
        throw new IllegalArgumentException("Texture width must be positive, but was " + n);
    }

    public void setFrameRotation(int n) {
        this.handler.post(() -> {
            this.frameRotation = n;
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.isQuitting = true;
            if (!this.isTextureInUse) {
                this.release();
            }
        });
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    public static interface FrameRefMonitor {
        public void onNewBuffer(VideoFrame.TextureBuffer var1);

        public void onRetainBuffer(VideoFrame.TextureBuffer var1);

        public void onReleaseBuffer(VideoFrame.TextureBuffer var1);

        public void onDestroyBuffer(VideoFrame.TextureBuffer var1);
    }
}

