/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.support.annotation.Nullable;
import android.view.Surface;
import org.otwebrtc.CapturerObserver;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoCapturer;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoSink;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
VideoSink {
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private final Intent mediaProjectionPermissionResultData;
    private final MediaProjection.Callback mediaProjectionCallback;
    private int width;
    private int height;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private CapturerObserver capturerObserver;
    private long numCapturedFrames;
    @Nullable
    private MediaProjection mediaProjection;
    private boolean isDisposed;
    @Nullable
    private MediaProjectionManager mediaProjectionManager;

    public ScreenCapturerAndroid(Intent intent, MediaProjection.Callback callback) {
        this.mediaProjectionPermissionResultData = intent;
        this.mediaProjectionCallback = callback;
    }

    private void checkNotDisposed() {
        if (!this.isDisposed) {
            return;
        }
        throw new RuntimeException("capturer is disposed.");
    }

    private void createVirtualDisplay() {
        Surface surface;
        ScreenCapturerAndroid screenCapturerAndroid = this;
        ScreenCapturerAndroid screenCapturerAndroid2 = this;
        int n = screenCapturerAndroid2.width;
        screenCapturerAndroid.surfaceTextureHelper.setTextureSize(n, screenCapturerAndroid2.height);
        ScreenCapturerAndroid screenCapturerAndroid3 = this;
        n = screenCapturerAndroid3.width;
        int n2 = screenCapturerAndroid3.height;
        Surface surface2 = surface;
        surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
        screenCapturerAndroid.virtualDisplay = screenCapturerAndroid.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", n, n2, 400, 3, surface2, null, null);
    }

    static /* synthetic */ VirtualDisplay access$202(ScreenCapturerAndroid screenCapturerAndroid, VirtualDisplay virtualDisplay) {
        screenCapturerAndroid.virtualDisplay = virtualDisplay;
        return virtualDisplay;
    }

    static /* synthetic */ MediaProjection access$302(ScreenCapturerAndroid screenCapturerAndroid, MediaProjection mediaProjection) {
        screenCapturerAndroid.mediaProjection = mediaProjection;
        return mediaProjection;
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver != null) {
            this.capturerObserver = capturerObserver;
            if (surfaceTextureHelper != null) {
                this.surfaceTextureHelper = surfaceTextureHelper;
                this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
                return;
            }
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        throw new RuntimeException("capturerObserver not set.");
    }

    @Override
    public synchronized void startCapture(int n, int n2, int n3) {
        MediaProjection mediaProjection;
        ScreenCapturerAndroid screenCapturerAndroid = this;
        this.checkNotDisposed();
        this.width = n;
        screenCapturerAndroid.height = n2;
        this.mediaProjection = mediaProjection = screenCapturerAndroid.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        screenCapturerAndroid.createVirtualDisplay();
        screenCapturerAndroid.capturerObserver.onCapturerStarted(true);
        screenCapturerAndroid.surfaceTextureHelper.startListening(this);
    }

    @Override
    public synchronized void stopCapture() {
        ScreenCapturerAndroid screenCapturerAndroid = this;
        screenCapturerAndroid.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(screenCapturerAndroid.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                1 v0 = this;
                v0.ScreenCapturerAndroid.this.surfaceTextureHelper.stopListening();
                v0.ScreenCapturerAndroid.this.capturerObserver.onCapturerStopped();
                if (v0.ScreenCapturerAndroid.this.virtualDisplay != null) {
                    1 v1 = this;
                    v1.ScreenCapturerAndroid.this.virtualDisplay.release();
                    ScreenCapturerAndroid.access$202(v1.ScreenCapturerAndroid.this, null);
                }
                if (ScreenCapturerAndroid.this.mediaProjection != null) {
                    1 v2 = this;
                    v2.ScreenCapturerAndroid.this.mediaProjection.unregisterCallback(ScreenCapturerAndroid.this.mediaProjectionCallback);
                    v2.ScreenCapturerAndroid.this.mediaProjection.stop();
                    ScreenCapturerAndroid.access$302(v2.ScreenCapturerAndroid.this, null);
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
    }

    @Override
    public synchronized void changeCaptureFormat(int n, int n2, int n3) {
        this.checkNotDisposed();
        this.width = n;
        this.height = n2;
        if (this.virtualDisplay == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                2 v0 = this;
                v0.ScreenCapturerAndroid.this.virtualDisplay.release();
                v0.ScreenCapturerAndroid.this.createVirtualDisplay();
            }
        });
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        ScreenCapturerAndroid screenCapturerAndroid = this;
        ++screenCapturerAndroid.numCapturedFrames;
        screenCapturerAndroid.capturerObserver.onFrameCaptured(videoFrame);
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }
}

