/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.otwebrtc.EglBase;
import org.otwebrtc.GlUtil;
import org.otwebrtc.Logging;

public class GlShader {
    private static final String TAG = "GlShader";
    private int program;

    private static int compileShader(int n, String string) {
        if ((n = GLES20.glCreateShader((int)n)) != 0) {
            int n2 = n;
            GLES20.glShaderSource((int)n2, (String)string);
            GLES20.glCompileShader((int)n2);
            int[] nArray = new int[]{0};
            GLES20.glGetShaderiv((int)n, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 1) {
                GlUtil.checkNoGLES2Error("compileShader");
                return n;
            }
            Logging.e(TAG, "Compile error " + GLES20.glGetShaderInfoLog((int)n) + " in shader:\n" + string);
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n));
        }
        throw new RuntimeException("glCreateShader() failed. GLES20 error: " + GLES20.glGetError());
    }

    public GlShader(String string, String string2) {
        int n;
        int n2 = GlShader.compileShader(35633, string);
        int n3 = GlShader.compileShader(35632, string2);
        this.program = n = GLES20.glCreateProgram();
        if (n != 0) {
            GlShader glShader = this;
            GLES20.glAttachShader((int)n, (int)n2);
            GLES20.glAttachShader((int)glShader.program, (int)n3);
            GLES20.glLinkProgram((int)glShader.program);
            int[] nArray = new int[]{0};
            GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] == 1) {
                GLES20.glDeleteShader((int)n2);
                GLES20.glDeleteShader((int)n3);
                GlUtil.checkNoGLES2Error("Creating GlShader");
                return;
            }
            Logging.e(TAG, "Could not link program: " + GLES20.glGetProgramInfoLog((int)this.program));
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        throw new RuntimeException("glCreateProgram() failed. GLES20 error: " + GLES20.glGetError());
    }

    public int getAttribLocation(String string) {
        int n = this.program;
        if (n != -1) {
            if ((n = GLES20.glGetAttribLocation((int)n, (String)string)) >= 0) {
                return n;
            }
            throw new RuntimeException("Could not locate '" + string + "' in program");
        }
        throw new RuntimeException("The program has been released");
    }

    public void setVertexAttribArray(String string, int n, FloatBuffer floatBuffer) {
        this.setVertexAttribArray(string, n, 0, floatBuffer);
    }

    public void setVertexAttribArray(String string, int n, int n2, FloatBuffer floatBuffer) {
        if (this.program != -1) {
            int n3 = this.getAttribLocation(string);
            GLES20.glEnableVertexAttribArray((int)n3);
            GLES20.glVertexAttribPointer((int)n3, (int)n, (int)5126, (boolean)false, (int)n2, (Buffer)floatBuffer);
            GlUtil.checkNoGLES2Error("setVertexAttribArray");
            return;
        }
        throw new RuntimeException("The program has been released");
    }

    public int getUniformLocation(String string) {
        int n = this.program;
        if (n != -1) {
            if ((n = GLES20.glGetUniformLocation((int)n, (String)string)) >= 0) {
                return n;
            }
            throw new RuntimeException("Could not locate uniform '" + string + "' in program");
        }
        throw new RuntimeException("The program has been released");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void useProgram() {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            GLES20.glUseProgram((int)this.program);
        }
        GlUtil.checkNoGLES2Error("glUseProgram");
    }

    public void release() {
        Logging.d(TAG, "Deleting shader.");
        int n = this.program;
        if (n != -1) {
            GLES20.glDeleteProgram((int)n);
            this.program = -1;
        }
    }
}

