/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.RefCountDelegate;
import org.otwebrtc.RefCounted;

public class EncodedImage
implements RefCounted {
    private final RefCountDelegate refCountDelegate;
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    @Nullable
    public final Integer qp;

    @CalledByNative
    private EncodedImage(ByteBuffer byteBuffer, @Nullable Runnable runnable, int n, int n2, long l, FrameType frameType, int n3, boolean bl, @Nullable Integer n4) {
        EncodedImage encodedImage = this;
        EncodedImage encodedImage2 = this;
        this.buffer = byteBuffer;
        this.encodedWidth = n;
        encodedImage2.encodedHeight = n2;
        encodedImage2.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(l);
        this.captureTimeNs = l;
        this.frameType = frameType;
        this.rotation = n3;
        this.completeFrame = bl;
        encodedImage.qp = n4;
        encodedImage.refCountDelegate = new RefCountDelegate(runnable);
    }

    @CalledByNative
    private ByteBuffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    private int getEncodedWidth() {
        return this.encodedWidth;
    }

    @CalledByNative
    private int getEncodedHeight() {
        return this.encodedHeight;
    }

    @CalledByNative
    private long getCaptureTimeNs() {
        return this.captureTimeNs;
    }

    @CalledByNative
    private int getFrameType() {
        return this.frameType.getNative();
    }

    @CalledByNative
    private int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    private boolean getCompleteFrame() {
        return this.completeFrame;
    }

    @CalledByNative
    @Nullable
    private Integer getQp() {
        return this.qp;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    public static class Builder {
        private ByteBuffer buffer;
        @Nullable
        private Runnable releaseCallback;
        private int encodedWidth;
        private int encodedHeight;
        private long captureTimeNs;
        private FrameType frameType;
        private int rotation;
        private boolean completeFrame;
        @Nullable
        private Integer qp;

        private Builder() {
        }

        public Builder setBuffer(ByteBuffer byteBuffer, @Nullable Runnable runnable) {
            this.buffer = byteBuffer;
            this.releaseCallback = runnable;
            return this;
        }

        public Builder setEncodedWidth(int n) {
            this.encodedWidth = n;
            return this;
        }

        public Builder setEncodedHeight(int n) {
            this.encodedHeight = n;
            return this;
        }

        @Deprecated
        public Builder setCaptureTimeMs(long l) {
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos(l);
            return this;
        }

        public Builder setCaptureTimeNs(long l) {
            this.captureTimeNs = l;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setRotation(int n) {
            this.rotation = n;
            return this;
        }

        public Builder setCompleteFrame(boolean bl) {
            this.completeFrame = bl;
            return this;
        }

        public Builder setQp(@Nullable Integer n) {
            this.qp = n;
            return this;
        }

        public EncodedImage createEncodedImage() {
            Builder builder = byteBuffer;
            ByteBuffer byteBuffer = builder.buffer;
            Runnable runnable = builder.releaseCallback;
            int n = builder.encodedWidth;
            int n2 = builder.encodedHeight;
            long l = builder.captureTimeNs;
            FrameType frameType = builder.frameType;
            int n3 = builder.rotation;
            boolean bl = builder.completeFrame;
            Integer n4 = builder.qp;
            return new EncodedImage(byteBuffer, runnable, n, n2, l, frameType, n3, bl, n4);
        }
    }

    public static final class FrameType
    extends Enum<FrameType> {
        public static final /* enum */ FrameType EmptyFrame;
        public static final /* enum */ FrameType VideoFrameKey;
        public static final /* enum */ FrameType VideoFrameDelta;
        private static final /* synthetic */ FrameType[] $VALUES;
        private final int nativeIndex;

        public static FrameType[] values() {
            return (FrameType[])$VALUES.clone();
        }

        public static FrameType valueOf(String string) {
            return Enum.valueOf(FrameType.class, string);
        }

        private FrameType(int n2) {
            this.nativeIndex = n2;
        }

        @CalledByNative(value="FrameType")
        static FrameType fromNativeIndex(int n) {
            for (FrameType frameType : FrameType.values()) {
                if (frameType.getNative() != n) continue;
                return frameType;
            }
            throw new IllegalArgumentException("Unknown native frame type: " + n);
        }

        static {
            FrameType frameType;
            EmptyFrame = new FrameType(0);
            VideoFrameKey = new FrameType(3);
            FrameType frameType2 = frameType;
            VideoFrameDelta = new FrameType(4);
            $VALUES = new FrameType[]{EmptyFrame, VideoFrameKey, frameType2};
        }

        public int getNative() {
            return this.nativeIndex;
        }
    }
}

