/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.otwebrtc.EglBase;
import org.otwebrtc.EglBase10;
import org.otwebrtc.Logging;

class EglBase10Impl
implements EglBase10 {
    private static final String TAG = "EglBase10Impl";
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private final EGL10 egl;
    private EGLContext eglContext;
    @Nullable
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface;

    public EglBase10Impl(EGLContext eGLContext, int[] nArray) {
        EglBase10Impl eglBase10Impl = eglBase10Impl4;
        EGLContext eGLContext2 = eGLContext;
        EglBase10Impl eglBase10Impl2 = eglBase10Impl4;
        EglBase10Impl eglBase10Impl3 = eglBase10Impl4;
        eglBase10Impl3.eglSurface = EGL10.EGL_NO_SURFACE;
        eglBase10Impl3.egl = (EGL10)EGLContext.getEGL();
        EglBase10Impl eglBase10Impl4 = eglBase10Impl3.getEglDisplay();
        eglBase10Impl3.eglDisplay = eglBase10Impl4;
        eglBase10Impl3.eglConfig = eglBase10Impl3.getEglConfig((EGLDisplay)eglBase10Impl4, nArray);
        int n = EglBase.getOpenGlesVersionFromConfig(nArray);
        Logging.d(TAG, "Using OpenGL ES version " + n);
        eGLContext = eglBase10Impl2.eglDisplay;
        eglBase10Impl.eglContext = eglBase10Impl.createEglContext(eGLContext2, (EGLDisplay)eGLContext, eglBase10Impl2.eglConfig, n);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof SurfaceHolder) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface == EGL10.EGL_NO_SURFACE) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 12344;
            EglBase10Impl eglBase10Impl2 = this;
            EGLDisplay eGLDisplay = eglBase10Impl2.eglDisplay;
            this.eglSurface = this.egl.eglCreateWindowSurface(eGLDisplay, eglBase10Impl2.eglConfig, object, nArray2);
            if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL10.EGL_NO_DISPLAY && this.eglContext != EGL10.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay != EGL10.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (this.egl.eglInitialize(eGLDisplay, nArray)) {
                return eGLDisplay;
            }
            throw new RuntimeException("Unable to initialize EGL10: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Unable to get EGL10 display: 0x" + Integer.toHexString(this.egl.eglGetError()));
    }

    private EGLConfig getEglConfig(EGLDisplay eGLDisplay, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (eglBase10Impl.egl.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, 1, nArray2)) {
            if (nArray2[0] > 0) {
                EglBase10Impl eglBase10Impl = eGLConfigArray[0];
                if (eglBase10Impl != null) {
                    return eglBase10Impl;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(eglBase10Impl.egl.eglGetError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EGLContext createEglContext(@Nullable EGLContext eGLContext, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n) {
        if (eGLContext != null && eGLContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 12440;
        nArray[1] = n;
        nArray[2] = 12344;
        if (eGLContext == null) {
            eGLContext = EGL10.EGL_NO_CONTEXT;
        }
        Object object = EglBase.lock;
        synchronized (object) {
            eGLContext = this.egl.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray2);
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : object
            if (eGLContext == EGL10.EGL_NO_CONTEXT) throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return eGLContext;
        }
    }

    @Override
    public void createSurface(Surface surface) {
        FakeSurfaceHolder fakeSurfaceHolder;
        FakeSurfaceHolder fakeSurfaceHolder2 = fakeSurfaceHolder;
        class FakeSurfaceHolder
        implements SurfaceHolder {
            private final Surface surface;

            FakeSurfaceHolder(Surface surface) {
                this.surface = surface;
            }

            public void addCallback(SurfaceHolder.Callback callback) {
            }

            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            public boolean isCreating() {
                return false;
            }

            @Deprecated
            public void setType(int n) {
            }

            public void setFixedSize(int n, int n2) {
            }

            public void setSizeFromLayout() {
            }

            public void setFormat(int n) {
            }

            public void setKeepScreenOn(boolean bl) {
            }

            @Nullable
            public Canvas lockCanvas() {
                return null;
            }

            @Nullable
            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            public void unlockCanvasAndPost(Canvas canvas) {
            }

            @Nullable
            public Rect getSurfaceFrame() {
                return null;
            }

            public Surface getSurface() {
                return this.surface;
            }
        }
        fakeSurfaceHolder = new FakeSurfaceHolder(surface);
        this.createSurfaceInternal(fakeSurfaceHolder2);
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n, int n2) {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface == EGL10.EGL_NO_SURFACE) {
            int[] nArray = new int[5];
            int[] nArray2 = nArray;
            nArray[0] = 12375;
            nArray[1] = n;
            nArray[2] = 12374;
            nArray[3] = n2;
            nArray[4] = 12344;
            EglBase10Impl eglBase10Impl2 = this;
            EGLDisplay eGLDisplay = eglBase10Impl2.eglDisplay;
            this.eglSurface = this.egl.eglCreatePbufferSurface(eGLDisplay, eglBase10Impl2.eglConfig, nArray2);
            if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n + "x" + n2 + ": 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL10.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EglBase10Impl eglBase10Impl = eglBase10Impl2;
        EglBase10Impl eglBase10Impl2 = eglBase10Impl.eglDisplay;
        eglBase10Impl2.egl.eglQuerySurface((EGLDisplay)eglBase10Impl2, eglBase10Impl.eglSurface, 12375, nArray);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EglBase10Impl eglBase10Impl = eglBase10Impl2;
        EglBase10Impl eglBase10Impl2 = eglBase10Impl.eglDisplay;
        eglBase10Impl2.egl.eglQuerySurface((EGLDisplay)eglBase10Impl2, eglBase10Impl.eglSurface, 12374, nArray);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        EGLSurface eGLSurface = this.eglSurface;
        if (eGLSurface != EGL10.EGL_NO_SURFACE) {
            this.egl.eglDestroySurface(this.eglDisplay, eGLSurface);
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    @Override
    public void release() {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        eglBase10Impl.releaseSurface();
        eglBase10Impl.detachCurrent();
        EglBase10Impl eglBase10Impl2 = this;
        EGLDisplay eGLDisplay = eglBase10Impl2.eglDisplay;
        eglBase10Impl.egl.eglDestroyContext(eGLDisplay, eglBase10Impl2.eglContext);
        eglBase10Impl.egl.eglTerminate(this.eglDisplay);
        eglBase10Impl.eglContext = EGL10.EGL_NO_CONTEXT;
        eglBase10Impl.eglDisplay = EGL10.EGL_NO_DISPLAY;
        eglBase10Impl.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void makeCurrent() {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface == EGL10.EGL_NO_SURFACE) throw new RuntimeException("No EGLSurface - can't make current");
        Object object = EglBase.lock;
        synchronized (object) {
            EGL10 eGL10 = this.egl;
            EglBase10Impl eglBase10Impl2 = this;
            EglBase10Impl eglBase10Impl3 = eglBase10Impl2;
            EglBase10Impl eglBase10Impl4 = eglBase10Impl2;
            EglBase10Impl eglBase10Impl5 = eglBase10Impl2;
            EGLDisplay eGLDisplay = eglBase10Impl2.eglDisplay;
            EGLSurface eGLSurface = eglBase10Impl3.eglSurface;
            EGLSurface eGLSurface2 = eglBase10Impl4.eglSurface;
            EGLContext eGLContext = eglBase10Impl5.eglContext;
            if (!eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface2, eGLContext)) throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        EglBase10Impl eglBase10Impl = eglBase10Impl4;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface != EGL10.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL10 eGL10 = eglBase10Impl4.egl;
                EglBase10Impl eglBase10Impl2 = eglBase10Impl4;
                EglBase10Impl eglBase10Impl3 = eglBase10Impl2;
                EglBase10Impl eglBase10Impl4 = eglBase10Impl2.eglDisplay;
                eGL10.eglSwapBuffers((EGLDisplay)eglBase10Impl4, eglBase10Impl3.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    @Override
    public void swapBuffers(long l) {
        this.swapBuffers();
    }

    private static class Context
    implements EglBase10.Context {
        private final EGLContext eglContext;

        public Context(EGLContext eGLContext) {
            this.eglContext = eGLContext;
        }

        @Override
        public EGLContext getRawContext() {
            return this.eglContext;
        }

        @Override
        public long getNativeEglContext() {
            return 0L;
        }
    }
}

