/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.otwebrtc.EglBase;
import org.otwebrtc.HardwareVideoDecoderFactory;
import org.otwebrtc.PlatformSoftwareVideoDecoderFactory;
import org.otwebrtc.SoftwareVideoDecoderFactory;
import org.otwebrtc.VideoCodecInfo;
import org.otwebrtc.VideoDecoder;
import org.otwebrtc.VideoDecoderFactory;
import org.otwebrtc.VideoDecoderFallback;

public class DefaultVideoDecoderFactory
implements VideoDecoderFactory {
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory;
    @Nullable
    private final VideoDecoderFactory platformSoftwareVideoDecoderFactory;

    public DefaultVideoDecoderFactory(@Nullable EglBase.Context context) {
        PlatformSoftwareVideoDecoderFactory platformSoftwareVideoDecoderFactory;
        HardwareVideoDecoderFactory hardwareVideoDecoderFactory;
        SoftwareVideoDecoderFactory softwareVideoDecoderFactory;
        VideoDecoderFactory videoDecoderFactory = softwareVideoDecoderFactory;
        softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
        v1.softwareVideoDecoderFactory = videoDecoderFactory;
        videoDecoderFactory = hardwareVideoDecoderFactory;
        hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(context);
        v1.hardwareVideoDecoderFactory = videoDecoderFactory;
        videoDecoderFactory = platformSoftwareVideoDecoderFactory;
        platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory(context);
        v1.platformSoftwareVideoDecoderFactory = videoDecoderFactory;
    }

    DefaultVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        SoftwareVideoDecoderFactory softwareVideoDecoderFactory;
        VideoDecoderFactory videoDecoderFactory2 = softwareVideoDecoderFactory;
        softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
        v1.softwareVideoDecoderFactory = videoDecoderFactory2;
        v1.hardwareVideoDecoderFactory = videoDecoderFactory;
        v1.platformSoftwareVideoDecoderFactory = null;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo) {
        VideoDecoder videoDecoder = ((DefaultVideoDecoderFactory)this).softwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        VideoDecoder videoDecoder2 = ((DefaultVideoDecoderFactory)this).hardwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        if (videoDecoder == null && (this = ((DefaultVideoDecoderFactory)this).platformSoftwareVideoDecoderFactory) != null) {
            videoDecoder = this.createDecoder(videoCodecInfo);
        }
        if (videoDecoder2 != null && videoDecoder != null) {
            return new VideoDecoderFallback(videoDecoder, videoDecoder2);
        }
        if (videoDecoder2 != null) {
            videoDecoder = videoDecoder2;
        }
        return videoDecoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet;
        LinkedHashSet<VideoCodecInfo> linkedHashSet2 = linkedHashSet;
        linkedHashSet2();
        linkedHashSet2.addAll(Arrays.asList(((DefaultVideoDecoderFactory)videoDecoderFactory).softwareVideoDecoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(((DefaultVideoDecoderFactory)videoDecoderFactory).hardwareVideoDecoderFactory.getSupportedCodecs()));
        VideoDecoderFactory videoDecoderFactory = ((DefaultVideoDecoderFactory)videoDecoderFactory).platformSoftwareVideoDecoderFactory;
        if (videoDecoderFactory != null) {
            linkedHashSet2.addAll(Arrays.asList(videoDecoderFactory.getSupportedCodecs()));
        }
        LinkedHashSet<VideoCodecInfo> linkedHashSet3 = linkedHashSet2;
        return linkedHashSet3.toArray(new VideoCodecInfo[linkedHashSet3.size()]);
    }
}

