/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.EglBase;
import org.otwebrtc.EncodedImage;
import org.otwebrtc.JavaI420Buffer;
import org.otwebrtc.Logging;
import org.otwebrtc.MediaCodecUtils;
import org.otwebrtc.MediaCodecWrapper;
import org.otwebrtc.MediaCodecWrapperFactory;
import org.otwebrtc.NV12Buffer;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoCodecMimeType;
import org.otwebrtc.VideoCodecStatus;
import org.otwebrtc.VideoDecoder;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoSink;
import org.otwebrtc.YuvHelper;

class AndroidVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "AndroidVideoDecoder";
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecMimeType codecType;
    private final BlockingDeque<FrameInfo> frameInfos;
    private int colorFormat;
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    private ThreadUtils.ThreadChecker decoderThreadChecker;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface;
    private final Object renderedTextureMetadataLock = new Object();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private MediaCodecWrapper codec;

    AndroidVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string, VideoCodecMimeType videoCodecMimeType, int n, @Nullable EglBase.Context context) {
        if (this.isSupportedColorFormat(n)) {
            AndroidVideoDecoder androidVideoDecoder = this;
            Logging.d(TAG, "ctor name: " + string + " type: " + (Object)((Object)videoCodecMimeType) + " color format: " + n + " context: " + context);
            this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
            this.codecName = string;
            this.codecType = videoCodecMimeType;
            this.colorFormat = n;
            androidVideoDecoder.sharedContext = context;
            androidVideoDecoder.frameInfos = new LinkedBlockingDeque<FrameInfo>();
            return;
        }
        throw new IllegalArgumentException("Unsupported color format: " + n);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VideoCodecStatus initDecodeInternal(int n, int n2) {
        block7: {
            AndroidVideoDecoder androidVideoDecoder = this;
            androidVideoDecoder.decoderThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "initDecodeInternal name: " + this.codecName + " type: " + (Object)((Object)this.codecType) + " width: " + n + " height: " + n2);
            if (androidVideoDecoder.outputThread != null) {
                Logging.e(TAG, "initDecodeInternal called while the codec is already running");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            AndroidVideoDecoder androidVideoDecoder2 = this;
            this.width = n;
            this.height = n2;
            this.stride = n;
            androidVideoDecoder2.sliceHeight = n2;
            androidVideoDecoder2.hasDecodedFirstFrame = false;
            androidVideoDecoder2.keyFrameRequired = true;
            androidVideoDecoder2.codec = androidVideoDecoder2.mediaCodecWrapperFactory.createByCodecName(this.codecName);
            try {
                MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)androidVideoDecoder2.codecType.mimeType(), (int)n, (int)n2);
                if (androidVideoDecoder2.sharedContext == null) {
                    String string = "color-format";
                    mediaFormat.setInteger(string, this.colorFormat);
                }
                AndroidVideoDecoder androidVideoDecoder3 = this;
                androidVideoDecoder3.codec.configure(mediaFormat, this.surface, null, 0);
                androidVideoDecoder3.codec.start();
                androidVideoDecoder3.running = true;
                this.outputThread = androidVideoDecoder3.createOutputThread();
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "initDecode failed", illegalStateException);
                this.release();
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            this.outputThread.start();
            Logging.d(TAG, "initDecodeInternal done");
            return VideoCodecStatus.OK;
            catch (IllegalArgumentException illegalArgumentException) {
                break block7;
            }
            catch (IOException iOException) {}
        }
        Logging.e(TAG, "Cannot create media decoder " + this.codecName);
        return VideoCodecStatus.FALLBACK_SOFTWARE;
    }

    private VideoCodecStatus releaseInternal() {
        block7: {
            block6: {
                if (!this.running) {
                    Logging.d(TAG, "release: Decoder is not running.");
                    return VideoCodecStatus.OK;
                }
                try {
                    this.running = false;
                    if (ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) break block6;
                }
                catch (Throwable throwable) {
                    AndroidVideoDecoder androidVideoDecoder = this;
                    androidVideoDecoder.codec = null;
                    androidVideoDecoder.outputThread = null;
                    throw throwable;
                }
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                AndroidVideoDecoder androidVideoDecoder = this;
                androidVideoDecoder.codec = null;
                androidVideoDecoder.outputThread = null;
                return VideoCodecStatus.TIMEOUT;
            }
            if (this.shutdownException == null) break block7;
            Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
            this.shutdownException = null;
            AndroidVideoDecoder androidVideoDecoder = this;
            androidVideoDecoder.codec = null;
            androidVideoDecoder.outputThread = null;
            return VideoCodecStatus.ERROR;
        }
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.codec = null;
        androidVideoDecoder.outputThread = null;
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int n, int n2) {
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.decoderThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = androidVideoDecoder.releaseInternal();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        return this.initDecodeInternal(n, n2);
    }

    private Thread createOutputThread() {
        return new Thread("AndroidVideoDecoder.outputThread"){

            @Override
            public void run() {
                AndroidVideoDecoder.access$002(AndroidVideoDecoder.this, new ThreadUtils.ThreadChecker());
                while (AndroidVideoDecoder.this.running) {
                    AndroidVideoDecoder.this.deliverDecodedFrame();
                }
                AndroidVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverTextureFrame(int n, MediaCodec.BufferInfo bufferInfo, int n2, Integer n3) {
        Object object;
        int n4;
        int n5;
        AndroidVideoDecoder androidVideoDecoder = this;
        Object object2 = androidVideoDecoder.dimensionLock;
        AndroidVideoDecoder androidVideoDecoder2 = this;
        synchronized (object2) {
            n5 = androidVideoDecoder2.width;
            n4 = androidVideoDecoder2.height;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var5_5
            object = androidVideoDecoder.renderedTextureMetadataLock;
        }
        synchronized (object) {
            if (androidVideoDecoder.renderedTextureMetadata != null) {
                this.codec.releaseOutputBuffer(n, false);
                return;
            }
            AndroidVideoDecoder androidVideoDecoder3 = this;
            androidVideoDecoder3.surfaceTextureHelper.setTextureSize(n5, n4);
            androidVideoDecoder3.surfaceTextureHelper.setFrameRotation(n2);
            androidVideoDecoder3.renderedTextureMetadata = new DecodedTextureMetadata(bufferInfo.presentationTimeUs, n3);
            androidVideoDecoder3.codec.releaseOutputBuffer(n, true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverByteFrame(int n, MediaCodec.BufferInfo bufferInfo, int n2, Integer n3) {
        VideoFrame videoFrame;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object = this.dimensionLock;
        AndroidVideoDecoder androidVideoDecoder = this;
        synchronized (object) {
            n8 = androidVideoDecoder.width;
            n7 = androidVideoDecoder.height;
            n6 = androidVideoDecoder.stride;
            n5 = androidVideoDecoder.sliceHeight;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : object
            n4 = bufferInfo.size;
        }
        if (n4 < n8 * n7 * 3 / 2) {
            Logging.e(TAG, "Insufficient output buffer size: " + bufferInfo.size);
            return;
        }
        if (n4 < n6 * n7 * 3 / 2 && n5 == n7 && n6 > n8) {
            n6 = n4 * 2 / (n7 * 3);
        }
        AndroidVideoDecoder androidVideoDecoder2 = this;
        ByteBuffer byteBuffer = androidVideoDecoder2.codec.getOutputBuffers()[n];
        byteBuffer.position(bufferInfo.offset);
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        Object object2 = byteBuffer.slice();
        object2 = androidVideoDecoder2.colorFormat == 19 ? this.copyI420Buffer((ByteBuffer)object2, n6, n5, n8, n7) : this.copyNV12ToI420Buffer((ByteBuffer)object2, n6, n5, n8, n7);
        this.codec.releaseOutputBuffer(n, false);
        long l = bufferInfo.presentationTimeUs * 1000L;
        VideoFrame videoFrame2 = videoFrame;
        videoFrame2((VideoFrame.Buffer)object2, n2, l);
        this.callback.onDecodedFrame(videoFrame2, n3, null);
        videoFrame.release();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        return new NV12Buffer(n3, n4, n, n2, byteBuffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        if (n % 2 == 0) {
            int n5 = (n3 + 1) / 2;
            int n6 = n2 % 2;
            int n7 = n6 == 0 ? (n4 + 1) / 2 : n4 / 2;
            AndroidVideoDecoder androidVideoDecoder = byteBuffer10;
            int n8 = n / 2;
            int n9 = n * n4 + 0;
            int n10 = n * n2 + 0;
            int n11 = n2;
            n2 = n8 * n7;
            int n12 = n10 + n2;
            int n13 = n10 + n8 * n11 / 2;
            n2 = n13 + n2;
            VideoFrame.I420Buffer i420Buffer = androidVideoDecoder.allocateI420Buffer(n3, n4);
            ByteBuffer byteBuffer2 = byteBuffer;
            VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.limit(n9);
            byteBuffer3.position(0);
            ByteBuffer byteBuffer4 = byteBuffer3.slice();
            ByteBuffer byteBuffer5 = i420Buffer2.getDataY();
            int n14 = i420Buffer2.getStrideY();
            ((AndroidVideoDecoder)((Object)byteBuffer10)).copyPlane(byteBuffer4, n, byteBuffer5, n14, n3, n4);
            byteBuffer.limit(n12);
            byteBuffer2.position(n10);
            ByteBuffer byteBuffer6 = byteBuffer2.slice();
            ByteBuffer byteBuffer7 = i420Buffer.getDataU();
            n4 = i420Buffer.getStrideU();
            androidVideoDecoder.copyPlane(byteBuffer6, n8, byteBuffer7, n4, n5, n7);
            if (n6 == 1) {
                byteBuffer.position(n10 + n8 * (n7 - 1));
                ByteBuffer byteBuffer8 = i420Buffer.getDataU();
                byteBuffer8.position(i420Buffer.getStrideU() * n7);
                byteBuffer8.put(byteBuffer);
            }
            AndroidVideoDecoder androidVideoDecoder2 = byteBuffer10;
            VideoFrame.I420Buffer i420Buffer3 = i420Buffer;
            ByteBuffer byteBuffer9 = byteBuffer;
            byteBuffer9.limit(n2);
            byteBuffer9.position(n13);
            ByteBuffer byteBuffer10 = byteBuffer9.slice();
            byteBuffer6 = i420Buffer3.getDataV();
            n2 = i420Buffer3.getStrideV();
            androidVideoDecoder2.copyPlane(byteBuffer10, n8, byteBuffer6, n2, n5, n7);
            if (n6 == 1) {
                byteBuffer.position(n13 + n8 * (n7 - 1));
                ByteBuffer byteBuffer11 = i420Buffer.getDataV();
                byteBuffer11.position(i420Buffer.getStrideV() * n7);
                byteBuffer11.put(byteBuffer);
            }
            return i420Buffer;
        }
        throw new AssertionError((Object)("Stride is not divisible by two: " + n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reformat(MediaFormat mediaFormat) {
        block14: {
            int n;
            int n2;
            this.outputThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
                MediaFormat mediaFormat2 = mediaFormat;
                n2 = mediaFormat2.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) + 1 - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
                n = mediaFormat2.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) + 1 - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
            } else {
                MediaFormat mediaFormat3 = mediaFormat;
                n2 = mediaFormat3.getInteger("width");
                n = mediaFormat3.getInteger("height");
            }
            AndroidVideoDecoder androidVideoDecoder = this;
            Object object = androidVideoDecoder.dimensionLock;
            synchronized (object) {
                if (androidVideoDecoder.hasDecodedFirstFrame && (this.width != n2 || this.height != n)) {
                    this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n2 + "*" + n));
                    return;
                }
                this.width = n2;
                this.height = n;
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var4_5
                if (this.surfaceTextureHelper != null) break block14;
            }
            if (mediaFormat.containsKey("color-format")) {
                AndroidVideoDecoder androidVideoDecoder2 = this;
                androidVideoDecoder2.colorFormat = mediaFormat.getInteger("color-format");
                Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                if (!androidVideoDecoder2.isSupportedColorFormat(androidVideoDecoder2.colorFormat)) {
                    this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                    return;
                }
            }
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = mediaFormat.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = mediaFormat.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            AndroidVideoDecoder androidVideoDecoder = this;
            {
                Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                androidVideoDecoder.stride = Math.max(androidVideoDecoder.width, this.stride);
                androidVideoDecoder.sliceHeight = Math.max(androidVideoDecoder.height, this.sliceHeight);
                return;
            }
        }
    }

    private void releaseCodecOnOutputThread() {
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            androidVideoDecoder.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder release failed", exception);
            this.shutdownException = exception;
        }
        Logging.d(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception exception) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = exception;
    }

    private boolean isSupportedColorFormat(int n) {
        Object object = MediaCodecUtils.DECODER_COLOR_FORMATS;
        int n2 = MediaCodecUtils.DECODER_COLOR_FORMATS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (object[i2] != n) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ ThreadUtils.ThreadChecker access$002(AndroidVideoDecoder androidVideoDecoder, ThreadUtils.ThreadChecker threadChecker) {
        androidVideoDecoder.outputThreadChecker = threadChecker;
        return threadChecker;
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
        this.callback = callback;
        if (this.sharedContext != null) {
            AndroidVideoDecoder androidVideoDecoder = this;
            androidVideoDecoder.surfaceTextureHelper = androidVideoDecoder.createSurfaceTextureHelper();
            androidVideoDecoder.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            androidVideoDecoder.surfaceTextureHelper.startListening(this);
        }
        VideoDecoder.Settings settings2 = settings;
        int n = settings2.width;
        return this.initDecodeInternal(n, settings2.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VideoCodecStatus decode(EncodedImage object, VideoDecoder.DecodeInfo object2) {
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.decoderThreadChecker.checkIsOnValidThread();
        if (androidVideoDecoder.codec != null && this.callback != null) {
            ByteBuffer byteBuffer;
            int n;
            int n2;
            int n3;
            block19: {
                block17: {
                    block18: {
                        object2 = ((EncodedImage)object).buffer;
                        if (object2 == null) {
                            Logging.e(TAG, "decode() - no input data");
                            return VideoCodecStatus.ERR_PARAMETER;
                        }
                        n3 = ((Buffer)object2).remaining();
                        if (n3 == 0) {
                            Logging.e(TAG, "decode() - input buffer empty");
                            return VideoCodecStatus.ERR_PARAMETER;
                        }
                        Object object3 = this.dimensionLock;
                        AndroidVideoDecoder androidVideoDecoder2 = this;
                        synchronized (object3) {
                            int n4 = androidVideoDecoder2.width;
                            int n5 = androidVideoDecoder2.height;
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 4] lbl18 : MonitorExitStatement: MONITOREXIT : object3
                            int n6 = ((EncodedImage)object).encodedWidth;
                            n2 = ((EncodedImage)object).encodedHeight;
                            if (n6 * n2 > 0 && (n6 != n4 || n2 != n5)) {
                                Object object4 = object;
                                n6 = ((EncodedImage)object4).encodedWidth;
                                VideoCodecStatus videoCodecStatus = this.reinitDecode(n6, ((EncodedImage)object4).encodedHeight);
                                if (videoCodecStatus != VideoCodecStatus.OK) {
                                    return videoCodecStatus;
                                }
                            }
                            if (!this.keyFrameRequired) break block17;
                            if (((EncodedImage)object).frameType == EncodedImage.FrameType.VideoFrameKey) break block18;
                        }
                        Logging.e(TAG, "decode() - key frame required first");
                        return VideoCodecStatus.NO_OUTPUT;
                    }
                    if (!((EncodedImage)object).completeFrame) {
                        Logging.e(TAG, "decode() - complete frame required first");
                        return VideoCodecStatus.NO_OUTPUT;
                    }
                }
                try {
                    n = this.codec.dequeueInputBuffer(500000L);
                    if (n >= 0) break block19;
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
                    return VideoCodecStatus.ERROR;
                }
                Logging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
                return VideoCodecStatus.ERROR;
            }
            try {
                byteBuffer = this.codec.getInputBuffers()[n];
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "getInputBuffers failed", illegalStateException);
                return VideoCodecStatus.ERROR;
            }
            if (byteBuffer.capacity() < n3) {
                Logging.e(TAG, "decode() - HW buffer too small");
                return VideoCodecStatus.ERROR;
            }
            AndroidVideoDecoder androidVideoDecoder3 = this;
            byteBuffer.put(((EncodedImage)object).buffer);
            long l = SystemClock.elapsedRealtime();
            n2 = ((EncodedImage)object).rotation;
            androidVideoDecoder3.frameInfos.offer(new FrameInfo(l, n2));
            try {
                androidVideoDecoder3.codec.queueInputBuffer(n, 0, n3, TimeUnit.NANOSECONDS.toMicros(((EncodedImage)object).captureTimeNs), 0);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
                this.frameInfos.pollLast();
                return VideoCodecStatus.ERROR;
            }
            if (androidVideoDecoder3.keyFrameRequired) {
                this.keyFrameRequired = false;
            }
            return VideoCodecStatus.OK;
        }
        object = TAG;
        object2 = new StringBuilder().append("decode uninitalized, codec: ");
        boolean bl = this.codec != null;
        Logging.d((String)object, ((StringBuilder)object2).append(bl).append(", callback: ").append(this.callback).toString());
        return VideoCodecStatus.UNINITIALIZED;
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return this.codecName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VideoCodecStatus release() {
        AndroidVideoDecoder androidVideoDecoder = this;
        Logging.d(TAG, "release");
        Object object = androidVideoDecoder.releaseInternal();
        if (androidVideoDecoder.surface != null) {
            AndroidVideoDecoder androidVideoDecoder2 = this;
            androidVideoDecoder2.releaseSurface();
            androidVideoDecoder2.surface = null;
            androidVideoDecoder2.surfaceTextureHelper.stopListening();
            androidVideoDecoder2.surfaceTextureHelper.dispose();
            androidVideoDecoder2.surfaceTextureHelper = null;
        }
        VideoCodecStatus videoCodecStatus = object;
        AndroidVideoDecoder androidVideoDecoder3 = this;
        object = androidVideoDecoder3.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : object /* !! */ 
            androidVideoDecoder3.callback = null;
        }
        androidVideoDecoder3.frameInfos.clear();
        return videoCodecStatus;
    }

    /*
     * Unable to fully structure code
     */
    protected void deliverDecodedFrame() {
        block12: {
            block11: {
                block10: {
                    v0 = this;
                    v0.outputThreadChecker.checkIsOnValidThread();
                    var1_2 = v1;
                    v1 = new MediaCodec.BufferInfo();
                    var2_3 = v0.codec.dequeueOutputBuffer(var1_2, 100000L);
                    if (var2_3 != -2) break block10;
                    v2 = this;
                    v2.reformat(v2.codec.getOutputFormat());
                    return;
                }
                if (var2_3 >= 0) ** GOTO lbl17
                Logging.v("AndroidVideoDecoder", "dequeueOutputBuffer returned " + var2_3);
                return;
lbl17:
                // 1 sources

                var3_4 = this.frameInfos.poll();
                var4_5 = null;
                var5_6 = 0;
                if (var3_4 == null) break block11;
                v3 = var3_4;
                v4 = (int)(SystemClock.elapsedRealtime() - var3_4.decodeStartTimeMs);
                var4_5 = v4;
                var5_6 = v3.rotation;
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper == null) ** GOTO lbl35
            try {
                this.deliverTextureFrame(var2_3, var1_2, var5_6, var4_5);
                break block12;
lbl35:
                // 1 sources

                this.deliverByteFrame(var2_3, var1_2, var5_6, var4_5);
            }
            catch (IllegalStateException var0_1) {
                Logging.e("AndroidVideoDecoder", "deliverDecodedFrame failed", var0_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame refCounted) {
        AndroidVideoDecoder androidVideoDecoder = n;
        Object object = androidVideoDecoder.renderedTextureMetadataLock;
        synchronized (object) {
            block7: {
                VideoFrame videoFrame;
                if (androidVideoDecoder.renderedTextureMetadata == null) break block7;
                AndroidVideoDecoder androidVideoDecoder2 = n;
                Object object2 = object;
                AndroidVideoDecoder androidVideoDecoder3 = n;
                AndroidVideoDecoder androidVideoDecoder4 = androidVideoDecoder3;
                AndroidVideoDecoder androidVideoDecoder5 = androidVideoDecoder3;
                long l = androidVideoDecoder3.renderedTextureMetadata.presentationTimestampUs * 1000L;
                Integer n = androidVideoDecoder5.renderedTextureMetadata.decodeTimeMs;
                androidVideoDecoder4.renderedTextureMetadata = null;
                // ** MonitorExit[v3] (shouldn't be in output)
                object = videoFrame;
                VideoFrame videoFrame2 = refCounted;
                refCounted = videoFrame2.getBuffer();
                videoFrame = new VideoFrame((VideoFrame.Buffer)refCounted, videoFrame2.getRotation(), l);
                androidVideoDecoder2.callback.onDecodedFrame((VideoFrame)object, n, null);
                return;
            }
            throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
        }
    }

    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
    }

    protected void releaseSurface() {
        this.surface.release();
    }

    protected VideoFrame.I420Buffer allocateI420Buffer(int n, int n2) {
        return JavaI420Buffer.allocate(n, n2);
    }

    protected void copyPlane(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3, int n4) {
        YuvHelper.copyPlane(byteBuffer, n, byteBuffer2, n2, n3, n4);
    }

    private static class DecodedTextureMetadata {
        final long presentationTimestampUs;
        final Integer decodeTimeMs;

        DecodedTextureMetadata(long l, Integer n) {
            this.presentationTimestampUs = l;
            this.decodeTimeMs = n;
        }
    }

    private static class FrameInfo {
        final long decodeStartTimeMs;
        final int rotation;

        FrameInfo(long l, int n) {
            this.decodeStartTimeMs = l;
            this.rotation = n;
        }
    }
}

