/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.OtLog;
import com.opentok.android.Publisher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=21)
@RequiresApi(value=21)
class Camera2VideoCapturer
extends BaseVideoCapturer
implements BaseVideoCapturer.CaptureSwitch {
    private static final int PREFERRED_FACING_CAMERA = 0;
    private static final int PIXEL_FORMAT = 35;
    private static final SparseIntArray rotationTable = new SparseIntArray(){
        {
            1 v0 = this;
            v0.append(0, 0);
            v0.append(1, 90);
            v0.append(2, 180);
            v0.append(3, 270);
        }
    };
    private static final SparseArray<Size> resolutionTable = new SparseArray<Size>(){
        {
            2 v0 = this;
            v0.append(Publisher.CameraCaptureResolution.LOW.ordinal(), new Size(352, 288));
            v0.append(Publisher.CameraCaptureResolution.MEDIUM.ordinal(), new Size(640, 480));
            v0.append(Publisher.CameraCaptureResolution.HIGH.ordinal(), new Size(1280, 720));
        }
    };
    private static final SparseIntArray frameRateTable = new SparseIntArray(){
        {
            3 v0 = this;
            v0.append(Publisher.CameraCaptureFrameRate.FPS_1.ordinal(), 1);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_7.ordinal(), 7);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_15.ordinal(), 15);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_30.ordinal(), 30);
        }
    };
    private CameraManager cameraManager;
    private CameraDevice camera;
    private HandlerThread cameraThread;
    private Handler cameraThreadHandler;
    private ImageReader cameraFrame;
    private CaptureRequest captureRequest;
    private CaptureRequest.Builder captureRequestBuilder;
    private CameraCaptureSession captureSession;
    private CameraInfoCache characteristics;
    private CameraState cameraState;
    private Display display;
    private DisplayOrientationCache displayOrientationCache;
    private ReentrantLock reentrantLock;
    private Condition condition;
    private int cameraIndex;
    private Size frameDimensions;
    private int desiredFps;
    private Range<Integer> camFps;
    private List<RuntimeException> runtimeExceptionList;
    private boolean isPaused;
    private final OtLog.LogToken log;
    private Runnable executeAfterClosed;
    private Runnable executeAfterCameraOpened;
    private CameraDevice.StateCallback cameraObserver;
    private ImageReader.OnImageAvailableListener frameObserver;
    private CameraCaptureSession.StateCallback captureSessionObserver;
    private CameraCaptureSession.CaptureCallback captureNotification;

    public Camera2VideoCapturer(Context object, Publisher.CameraCaptureResolution cameraCaptureResolution, Publisher.CameraCaptureFrameRate cameraCaptureFrameRate) {
        block5: {
            ReentrantLock reentrantLock;
            this.log = new OtLog.LogToken(this);
            this.cameraObserver = new CameraDevice.StateCallback(){

                public void onOpened(CameraDevice cameraDevice) {
                    4 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraDevice onOpened", new Object[0]);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.OPEN);
                    Camera2VideoCapturer.access$202(v0.Camera2VideoCapturer.this, cameraDevice);
                    if (v0.Camera2VideoCapturer.this.executeAfterCameraOpened != null) {
                        Camera2VideoCapturer.this.executeAfterCameraOpened.run();
                    }
                }

                public void onDisconnected(CameraDevice cameraDevice) {
                    OtLog.LogToken logToken;
                    4 v1;
                    try {
                        4 v0 = this;
                        v1 = v0;
                        logToken = v0.Camera2VideoCapturer.this.log;
                    }
                    catch (NullPointerException nullPointerException) {}
                    logToken.d("CameraDevice onDisconnected", new Object[0]);
                    v1.Camera2VideoCapturer.this.camera.close();
                }

                public void onError(CameraDevice cameraDevice, int n) {
                    OtLog.LogToken logToken;
                    4 v1;
                    try {
                        4 v0 = this;
                        v1 = v0;
                        logToken = v0.Camera2VideoCapturer.this.log;
                    }
                    catch (NullPointerException nullPointerException) {}
                    logToken.d("CameraDevice onError", new Object[0]);
                    v1.Camera2VideoCapturer.this.camera.close();
                    Camera2VideoCapturer.this.postAsyncException(new Camera2Exception("Camera Open Error: " + n));
                }

                public void onClosed(CameraDevice cameraDevice) {
                    4 v0 = this;
                    Camera2VideoCapturer.this.log.d("CameraDevice onClosed", new Object[0]);
                    super.onClosed(cameraDevice);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.CLOSED);
                    Camera2VideoCapturer.access$202(v0.Camera2VideoCapturer.this, null);
                    if (v0.Camera2VideoCapturer.this.executeAfterClosed != null) {
                        Camera2VideoCapturer.this.executeAfterClosed.run();
                    }
                }
            };
            this.frameObserver = new ImageReader.OnImageAvailableListener(){

                public void onImageAvailable(ImageReader imageReader) {
                    if (!((imageReader = imageReader.acquireNextImage()) == null || imageReader.getPlanes().length > 0 && imageReader.getPlanes()[0].getBuffer() == null || imageReader.getPlanes().length > 1 && imageReader.getPlanes()[1].getBuffer() == null || imageReader.getPlanes().length > 2 && imageReader.getPlanes()[2].getBuffer() == null)) {
                        if (CameraState.CAPTURE == Camera2VideoCapturer.this.cameraState) {
                            ImageReader imageReader2 = imageReader;
                            ByteBuffer byteBuffer = imageReader2.getPlanes()[0].getBuffer();
                            ByteBuffer byteBuffer2 = imageReader2.getPlanes()[1].getBuffer();
                            ByteBuffer byteBuffer3 = imageReader2.getPlanes()[2].getBuffer();
                            int n = imageReader2.getPlanes()[0].getPixelStride();
                            int n2 = imageReader2.getPlanes()[0].getRowStride();
                            int n3 = imageReader2.getPlanes()[1].getPixelStride();
                            int n4 = imageReader2.getPlanes()[1].getRowStride();
                            int n5 = imageReader2.getPlanes()[2].getPixelStride();
                            int n6 = imageReader2.getPlanes()[2].getRowStride();
                            int n7 = imageReader2.getWidth();
                            int n8 = imageReader2.getHeight();
                            5 v1 = this;
                            int n9 = v1.Camera2VideoCapturer.this.calculateCamRotation();
                            boolean bl = v1.Camera2VideoCapturer.this.isFrontCamera();
                            Camera2VideoCapturer.this.provideBufferFramePlanar(byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, n7, n8, n9, bl);
                        }
                        imageReader.close();
                        return;
                    }
                    Camera2VideoCapturer.this.log.d("onImageAvailable frame provided has no image data", new Object[0]);
                }
            };
            this.captureSessionObserver = new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    6 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CaptureSession onConfigured", new Object[0]);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.CAPTURE);
                    Camera2VideoCapturer.access$802(v0.Camera2VideoCapturer.this, cameraCaptureSession);
                    Camera2VideoCapturer.access$902(v0.Camera2VideoCapturer.this, Camera2VideoCapturer.this.captureRequestBuilder.build());
                    try {
                        v0.Camera2VideoCapturer.this.captureSession.setRepeatingRequest(Camera2VideoCapturer.this.captureRequest, Camera2VideoCapturer.this.captureNotification, null);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    6 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CaptureSession onFailed", new Object[0]);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.ERROR);
                    v0.Camera2VideoCapturer.this.postAsyncException(new Camera2Exception("Camera session configuration failed"));
                }

                public void onClosed(CameraCaptureSession cameraCaptureSession) {
                    6 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CaptureSession onClosed", new Object[0]);
                    if (v0.Camera2VideoCapturer.this.camera != null) {
                        Camera2VideoCapturer.this.camera.close();
                    }
                }
            };
            this.captureNotification = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureStarted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, long l, long l2) {
                    super.onCaptureStarted(cameraCaptureSession, captureRequest, l, l2);
                }
            };
            this.cameraManager = (CameraManager)object.getSystemService("camera");
            this.display = ((WindowManager)object.getSystemService("window")).getDefaultDisplay();
            this.camera = null;
            this.cameraState = CameraState.CLOSED;
            object = reentrantLock;
            this.reentrantLock = new ReentrantLock();
            this.condition = ((ReentrantLock)object).newCondition();
            this.frameDimensions = (Size)resolutionTable.get(cameraCaptureResolution.ordinal());
            this.desiredFps = frameRateTable.get(cameraCaptureFrameRate.ordinal());
            this.runtimeExceptionList = new ArrayList<RuntimeException>();
            this.isPaused = false;
            try {
                object = this.selectCamera(0);
                if (object != null) break block5;
            }
            catch (CameraAccessException cameraAccessException) {
                throw new Camera2Exception(cameraAccessException.getMessage());
            }
            if (this.cameraManager.getCameraIdList().length <= 0) break block5;
            object = this.cameraManager.getCameraIdList()[0];
        }
        this.cameraIndex = this.findCameraIndex((String)object);
    }

    private void doInit() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("init enter", new Object[0]);
        camera2VideoCapturer.characteristics = null;
        camera2VideoCapturer.startCamThread();
        camera2VideoCapturer.startDisplayOrientationCache();
        camera2VideoCapturer.initCamera();
        camera2VideoCapturer.log.d("init exit", new Object[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doStartCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("doStartCapture enter", new Object[0]);
        try {
            void var1_5;
            CameraCaptureSession.StateCallback stateCallback;
            CameraDevice cameraDevice;
            if (camera2VideoCapturer.isFrontCamera()) {
                Camera2VideoCapturer camera2VideoCapturer2 = this;
                CaptureRequest.Builder builder = camera2VideoCapturer2.camera.createCaptureRequest(1);
                this.captureRequestBuilder = builder;
                builder.addTarget(this.cameraFrame.getSurface());
                CaptureRequest.Key key = CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE;
                camera2VideoCapturer2.captureRequestBuilder.set(key, this.camFps);
                camera2VideoCapturer2.captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
                camera2VideoCapturer2.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                camera2VideoCapturer2.captureRequestBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)1);
                cameraDevice = camera2VideoCapturer2.camera;
                List<Surface> list = Arrays.asList(this.cameraFrame.getSurface());
                stateCallback = this.captureSessionObserver;
            } else {
                Camera2VideoCapturer camera2VideoCapturer3 = this;
                CaptureRequest.Builder builder = camera2VideoCapturer3.camera.createCaptureRequest(3);
                this.captureRequestBuilder = builder;
                builder.addTarget(this.cameraFrame.getSurface());
                CaptureRequest.Key key = CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE;
                camera2VideoCapturer3.captureRequestBuilder.set(key, this.camFps);
                camera2VideoCapturer3.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                cameraDevice = camera2VideoCapturer3.camera;
                Camera2VideoCapturer camera2VideoCapturer4 = this;
                Surface[] surfaceArray = new Surface[1];
                surfaceArray[0] = this.cameraFrame.getSurface();
                List<Surface> list = Arrays.asList(surfaceArray);
                stateCallback = camera2VideoCapturer4.captureSessionObserver;
            }
            cameraDevice.createCaptureSession((List)var1_5, stateCallback, null);
            this.log.d("doStartCapture exit", new Object[0]);
            return 0;
        }
        catch (CameraAccessException cameraAccessException) {
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
    }

    private boolean isFrontCamera() {
        CameraInfoCache cameraInfoCache = ((Camera2VideoCapturer)((Object)cameraInfoCache)).characteristics;
        return cameraInfoCache != null && cameraInfoCache.isFrontFacing();
    }

    private void startCamThread() {
        this.cameraThread = new HandlerThread("Camera2VideoCapturer-Camera-Thread");
        this.cameraThread.start();
        this.cameraThreadHandler = new Handler(this.cameraThread.getLooper());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopCamThread() {
        block7: {
            v0 = this;
            v1 = v0;
            v2 = v0;
            v3 = v0;
            v0.cameraThread.quitSafely();
            ** GOTO lbl16
            {
                catch (Throwable v4) {
                    break block7;
                }
                catch (NullPointerException v5) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        v6 = this;
                        v6.cameraThread = null;
                        v6.cameraThreadHandler = null;
                        return;
                    }
                }
lbl16:
                // 1 sources

                try {
                    v1.cameraThread.join();
                    v2.cameraThread = null;
                    v3.cameraThreadHandler = null;
                    return;
                }
                catch (InterruptedException v7) {}
                {
                    v7.printStackTrace();
                    ** continue;
                }
            }
        }
        v8 = this;
        v8.cameraThread = null;
        v8.cameraThreadHandler = null;
        throw v4;
    }

    private String selectCamera(int n) {
        for (String string : this.cameraManager.getCameraIdList()) {
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(string);
            if (n != (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING)) continue;
            this.log.d("selectCamera() Direction the camera faces relative to device screen: " + cameraCharacteristics.get(CameraCharacteristics.LENS_FACING), new Object[0]);
            return string;
        }
        return null;
    }

    private Range<Integer> selectCameraFpsRange(String string, final int n) {
        for (String string2 : this.cameraManager.getCameraIdList()) {
            if (!string2.equals(string)) continue;
            string = this.cameraManager.getCameraCharacteristics(string2);
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, (Object[])string.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES));
            return Collections.min(arrayList, new Comparator<Range<Integer>>(){

                private int calcError(Range<Integer> range) {
                    return (Integer)range.getLower() + Math.abs((Integer)range.getUpper() - n);
                }

                @Override
                public int compare(Range<Integer> range, Range<Integer> range2) {
                    return this.calcError(range) - this.calcError(range2);
                }
            });
        }
        return null;
    }

    private int findCameraIndex(String string) {
        String[] stringArray = stringArray.cameraManager.getCameraIdList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            return i2;
        }
        return -1;
    }

    private Size selectPreferredSize(String string, final int n, final int n2, int n3) {
        ArrayList arrayList;
        string = (StreamConfigurationMap)this.cameraManager.getCameraCharacteristics(string).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        ArrayList arrayList2 = arrayList;
        String string2 = string;
        arrayList2();
        string2.getOutputFormats();
        Collections.addAll(arrayList, string2.getOutputSizes(35));
        return Collections.min(arrayList, new Comparator<Size>(){

            @Override
            public int compare(Size size, Size size2) {
                Size size3 = size2;
                int n3 = Math.abs(size3.getWidth() - n);
                int n22 = Math.abs(size3.getHeight() - n2);
                return Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2) - (n3 + n22);
            }
        });
    }

    private int calculateCamRotation() {
        if (this.characteristics != null) {
            Camera2VideoCapturer camera2VideoCapturer = this;
            int n = camera2VideoCapturer.displayOrientationCache.getOrientation();
            int n2 = camera2VideoCapturer.characteristics.sensorOrientation();
            if (!camera2VideoCapturer.characteristics.isFrontFacing()) {
                return Math.abs((n - n2) % 360);
            }
            return (n + n2 + 360) % 360;
        }
        return 0;
    }

    @SuppressLint(value={"all"})
    private void initCamera() {
        String string;
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("initCamera()", new Object[0]);
        try {
            camera2VideoCapturer.cameraState = CameraState.SETUP;
            string = camera2VideoCapturer.cameraManager.getCameraIdList()[this.cameraIndex];
        }
        catch (CameraAccessException cameraAccessException) {
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
        camera2VideoCapturer.camFps = camera2VideoCapturer.selectCameraFpsRange(string, camera2VideoCapturer.desiredFps);
        String string2 = string;
        Camera2VideoCapturer camera2VideoCapturer2 = this;
        Camera2VideoCapturer camera2VideoCapturer3 = camera2VideoCapturer2;
        int n = camera2VideoCapturer2.frameDimensions.getWidth();
        Size size = camera2VideoCapturer.selectPreferredSize(string2, n, camera2VideoCapturer3.frameDimensions.getHeight(), 35);
        ImageReader imageReader = ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)35, (int)3);
        size = imageReader;
        Camera2VideoCapturer camera2VideoCapturer4 = this;
        Camera2VideoCapturer camera2VideoCapturer5 = camera2VideoCapturer4;
        camera2VideoCapturer4.cameraFrame = size;
        size = camera2VideoCapturer4.frameObserver;
        imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)size, camera2VideoCapturer5.cameraThreadHandler);
        camera2VideoCapturer.characteristics = new CameraInfoCache(this.cameraManager.getCameraCharacteristics(string));
        camera2VideoCapturer.cameraManager.openCamera(string, this.cameraObserver, null);
    }

    private void postAsyncException(RuntimeException runtimeException) {
        this.runtimeExceptionList.add(runtimeException);
    }

    private void startDisplayOrientationCache() {
        DisplayOrientationCache displayOrientationCache;
        Camera2VideoCapturer camera2VideoCapturer = camera2VideoCapturer3;
        DisplayOrientationCache displayOrientationCache2 = displayOrientationCache;
        Camera2VideoCapturer camera2VideoCapturer2 = camera2VideoCapturer3;
        Camera2VideoCapturer camera2VideoCapturer3 = camera2VideoCapturer2.display;
        displayOrientationCache = new DisplayOrientationCache((Display)camera2VideoCapturer3, camera2VideoCapturer2.cameraThreadHandler);
        camera2VideoCapturer.displayOrientationCache = displayOrientationCache2;
    }

    private void stopDisplayOrientationCache() {
        this.cameraThreadHandler.removeCallbacks((Runnable)this.displayOrientationCache);
    }

    static /* synthetic */ CameraState access$102(Camera2VideoCapturer camera2VideoCapturer, CameraState cameraState) {
        camera2VideoCapturer.cameraState = cameraState;
        return cameraState;
    }

    static /* synthetic */ CameraDevice access$202(Camera2VideoCapturer camera2VideoCapturer, CameraDevice cameraDevice) {
        camera2VideoCapturer.camera = cameraDevice;
        return cameraDevice;
    }

    static /* synthetic */ CameraCaptureSession access$802(Camera2VideoCapturer camera2VideoCapturer, CameraCaptureSession cameraCaptureSession) {
        camera2VideoCapturer.captureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    static /* synthetic */ CaptureRequest access$902(Camera2VideoCapturer camera2VideoCapturer, CaptureRequest captureRequest) {
        camera2VideoCapturer.captureRequest = captureRequest;
        return captureRequest;
    }

    @Override
    public synchronized void init() {
        if (this.cameraState == CameraState.CLOSING) {
            this.executeAfterClosed = () -> this.doInit();
        } else {
            this.doInit();
        }
        this.cameraState = CameraState.SETUP;
    }

    @Override
    public synchronized int startCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("startCapture enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        if (camera2VideoCapturer.camera != null && CameraState.OPEN == this.cameraState) {
            return this.doStartCapture();
        }
        if (CameraState.SETUP == this.cameraState) {
            Camera2VideoCapturer camera2VideoCapturer2 = this;
            camera2VideoCapturer2.log.d("camera not yet ready, queuing the start until camera is opened.", new Object[0]);
            camera2VideoCapturer2.executeAfterCameraOpened = () -> this.doStartCapture();
            camera2VideoCapturer2.log.d("startCapture exit", new Object[0]);
            return 0;
        }
        throw new Camera2Exception("Start Capture called before init successfully completed.");
    }

    @Override
    public synchronized int stopCapture() {
        CameraCaptureSession cameraCaptureSession;
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("stopCapture enter", new Object[0]);
        if (camera2VideoCapturer.camera != null && (cameraCaptureSession = this.captureSession) != null && CameraState.CLOSED != this.cameraState) {
            this.cameraState = CameraState.CLOSING;
            try {
                cameraCaptureSession.stopRepeating();
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            Camera2VideoCapturer camera2VideoCapturer2 = this;
            camera2VideoCapturer2.captureSession.close();
            camera2VideoCapturer2.cameraFrame.close();
            camera2VideoCapturer2.characteristics = null;
        }
        this.log.d("stopCapture exit", new Object[0]);
        return 0;
    }

    @Override
    public synchronized void destroy() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("destroy enter", new Object[0]);
        camera2VideoCapturer.stopDisplayOrientationCache();
        camera2VideoCapturer.stopCamThread();
        camera2VideoCapturer.log.d("destroy exit", new Object[0]);
    }

    @Override
    public boolean isCaptureStarted() {
        return this.cameraState == CameraState.CAPTURE;
    }

    @Override
    public synchronized BaseVideoCapturer.CaptureSettings getCaptureSettings() {
        BaseVideoCapturer.CaptureSettings captureSettings;
        BaseVideoCapturer.CaptureSettings captureSettings2 = captureSettings;
        captureSettings2();
        captureSettings.fps = this.desiredFps;
        ImageReader imageReader = this.cameraFrame;
        int n = imageReader != null ? imageReader.getWidth() : 0;
        captureSettings2.width = n;
        ImageReader imageReader2 = this.cameraFrame;
        int n2 = imageReader2 != null ? imageReader2.getHeight() : 0;
        BaseVideoCapturer.CaptureSettings captureSettings3 = captureSettings2;
        captureSettings3.height = n2;
        captureSettings3.format = 1;
        captureSettings3.expectedDelay = 0;
        captureSettings2.mirrorInLocalRender = this.frameMirrorX;
        return captureSettings2;
    }

    @Override
    public synchronized void onPause() {
        this.log.d("onPause", new Object[0]);
        if (10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[this.cameraState.ordinal()] == 1) {
            this.stopCapture();
            this.isPaused = true;
        }
    }

    @Override
    public void onResume() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("onResume", new Object[0]);
        if (camera2VideoCapturer.isPaused) {
            Camera2VideoCapturer camera2VideoCapturer2 = this;
            Runnable runnable = () -> {
                Camera2VideoCapturer camera2VideoCapturer = this;
                camera2VideoCapturer.initCamera();
                camera2VideoCapturer.startCapture();
            };
            CameraState cameraState = camera2VideoCapturer2.cameraState;
            if (cameraState == CameraState.CLOSING) {
                this.executeAfterClosed = runnable;
            } else if (cameraState == CameraState.CLOSED) {
                runnable.run();
            }
            this.isPaused = false;
        } else {
            this.log.d("Capturer was not paused when onResume was called", new Object[0]);
        }
    }

    @Override
    public synchronized void cycleCamera() {
        String[] stringArray;
        String[] stringArray2;
        try {
            String[] stringArray3 = stringArray4;
            stringArray2 = stringArray4;
            stringArray = stringArray3;
            String[] stringArray4 = stringArray3.cameraManager.getCameraIdList();
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
        int n = stringArray.cameraIndex;
        stringArray2.swapCamera((n + 1) % stringArray4.length);
    }

    @Override
    public int getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    public synchronized void swapCamera(int n) {
        CameraState cameraState = this.cameraState;
        if (10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[cameraState.ordinal()] == 1) {
            this.stopCapture();
        }
        this.cameraIndex = n;
        this.executeAfterClosed = () -> {
            if (10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[cameraState.ordinal()] == 1) {
                Camera2VideoCapturer camera2VideoCapturer = this;
                camera2VideoCapturer.initCamera();
                camera2VideoCapturer.startCapture();
            }
        };
    }

    public static class Camera2Exception
    extends RuntimeException {
        public Camera2Exception(String string) {
            super(string);
        }
    }

    private static class DisplayOrientationCache
    implements Runnable {
        private static final int POLL_DELAY_MS = 750;
        private int displayRotation;
        private Display display;
        private Handler handler;

        public DisplayOrientationCache(Display display, Handler handler) {
            this.display = display;
            this.handler = handler;
            this.displayRotation = rotationTable.get(this.display.getRotation());
            this.handler.postDelayed((Runnable)this, 750L);
        }

        public int getOrientation() {
            return this.displayRotation;
        }

        @Override
        public void run() {
            this.displayRotation = rotationTable.get(this.display.getRotation());
            this.handler.postDelayed((Runnable)this, 750L);
        }
    }

    private static class CameraInfoCache {
        private CameraCharacteristics info;
        private boolean frontFacing = false;
        private int sensorOrientation = 0;

        public CameraInfoCache(CameraCharacteristics cameraCharacteristics) {
            boolean bl = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
            this.frontFacing = bl;
            this.sensorOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        }

        public <T> T get(CameraCharacteristics.Key<T> key) {
            return (T)this.info.get(key);
        }

        public boolean isFrontFacing() {
            return this.frontFacing;
        }

        public int sensorOrientation() {
            return this.sensorOrientation;
        }
    }

    private static final class CameraState
    extends Enum<CameraState> {
        public static final /* enum */ CameraState CLOSED;
        public static final /* enum */ CameraState CLOSING;
        public static final /* enum */ CameraState SETUP;
        public static final /* enum */ CameraState OPEN;
        public static final /* enum */ CameraState CAPTURE;
        public static final /* enum */ CameraState ERROR;
        private static final /* synthetic */ CameraState[] $VALUES;

        public static CameraState[] values() {
            return (CameraState[])$VALUES.clone();
        }

        public static CameraState valueOf(String string) {
            return Enum.valueOf(CameraState.class, string);
        }

        static {
            CameraState cameraState;
            CLOSED = new CameraState();
            CLOSING = new CameraState();
            SETUP = new CameraState();
            OPEN = new CameraState();
            CAPTURE = new CameraState();
            CameraState cameraState2 = cameraState;
            ERROR = new CameraState();
            $VALUES = new CameraState[]{CLOSED, CLOSING, SETUP, OPEN, CAPTURE, cameraState2};
        }
    }
}

