/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.util;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.xwork.ActionContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlHelper {
    private static final Log LOG = LogFactory.getLog((Class)UrlHelper.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String AMP = "&amp;";

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params) {
        return UrlHelper.buildUrl(action, request, response, params, null, true, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult) {
        return UrlHelper.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, false);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort) {
        return UrlHelper.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, forceAddSchemeHostAndPort, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort, boolean escapeAmp) {
        String result;
        StringBuffer link = new StringBuffer();
        boolean changedScheme = false;
        int httpPort = 80;
        try {
            httpPort = Integer.parseInt((String)Configuration.get("webwork.url.http.port"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        int httpsPort = 443;
        try {
            httpsPort = Integer.parseInt((String)Configuration.get("webwork.url.https.port"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (forceAddSchemeHostAndPort) {
            String reqScheme = request.getScheme();
            changedScheme = true;
            link.append(scheme != null ? scheme : reqScheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme != null && (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443)) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        } else if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                String contextPath = request.getContextPath();
                if (!contextPath.equals("/")) {
                    link.append(contextPath);
                }
            } else if (changedScheme) {
                String uri = request.getRequestURI();
                link.append(uri.substring(0, uri.lastIndexOf(47)));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        String continueId = (String)ActionContext.getContext().get((Object)"__continue");
        if (continueId != null) {
            if (params == null) {
                params = Collections.singletonMap("__continue", continueId);
            } else {
                params.put("__continue", continueId);
            }
        }
        if (escapeAmp) {
            UrlHelper.buildParametersString(params, link);
        } else {
            UrlHelper.buildParametersString(params, link, "&");
        }
        try {
            result = encodeResult ? response.encodeURL(link.toString()) : link.toString();
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    public static void buildParametersString(Map params, StringBuffer link) {
        UrlHelper.buildParametersString(params, link, AMP);
    }

    public static void buildParametersString(Map params, StringBuffer link, String paramSeparator) {
        if (params != null && params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append("?");
            } else {
                link.append(paramSeparator);
            }
            Iterator iter = params.entrySet().iterator();
            String[] valueHolder = new String[1];
            while (iter.hasNext()) {
                String[] values;
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    values = (String[])value;
                } else {
                    valueHolder[0] = value.toString();
                    values = valueHolder;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) {
                        link.append(name);
                        link.append('=');
                        link.append(UrlHelper.encode(values[i]));
                    }
                    if (i >= values.length - 1) continue;
                    link.append(paramSeparator);
                }
                if (!iter.hasNext()) continue;
                link.append(paramSeparator);
            }
        }
    }

    public static String encode(String input) {
        String encoding = UrlHelper.getEncodingFromConfiguration();
        try {
            return URLEncoder.encode(input, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Could not encode URL parameter '" + input + "', returning value un-encoded"));
            return input;
        }
    }

    public static String decode(String input) {
        String encoding = UrlHelper.getEncodingFromConfiguration();
        try {
            return URLDecoder.decode(input, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Could not encode URL parameter '" + input + "', returning value un-encoded"));
            return input;
        }
    }

    private static String getEncodingFromConfiguration() {
        String encoding = Configuration.isSet("webwork.i18n.encoding") ? Configuration.getString("webwork.i18n.encoding") : "UTF-8";
        return encoding;
    }

    public static Map parseQueryString(String queryString) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        if (queryString != null) {
            String[] params = queryString.split("&");
            for (int a = 0; a < params.length; ++a) {
                if (params[a].trim().length() <= 0) continue;
                String[] tmpParams = params[a].split("=");
                String paramName = null;
                String paramValue = "";
                if (tmpParams.length > 0) {
                    paramName = tmpParams[0];
                }
                if (tmpParams.length > 1) {
                    paramValue = tmpParams[1];
                }
                if (paramName == null) continue;
                String translatedParamValue = UrlHelper.decode(paramValue);
                if (queryParams.containsKey(paramName)) {
                    Object currentParam = queryParams.get(paramName);
                    if (currentParam instanceof String) {
                        queryParams.put(paramName, new String[]{(String)currentParam, translatedParamValue});
                        continue;
                    }
                    String[] currentParamValues = (String[])currentParam;
                    ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(currentParamValues));
                    paramList.add(translatedParamValue);
                    String[] newParamValues = new String[paramList.size()];
                    queryParams.put(paramName, paramList.toArray(newParamValues));
                    continue;
                }
                queryParams.put(paramName, translatedParamValue);
            }
        }
        return queryParams;
    }
}

