/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitegraph.renderers;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.sitegraph.XWorkConfigRetriever;
import com.opensymphony.webwork.sitegraph.entities.Target;
import com.opensymphony.webwork.sitegraph.entities.View;
import com.opensymphony.webwork.sitegraph.model.ActionNode;
import com.opensymphony.webwork.sitegraph.model.Graph;
import com.opensymphony.webwork.sitegraph.model.IndentWriter;
import com.opensymphony.webwork.sitegraph.model.Link;
import com.opensymphony.webwork.sitegraph.model.SiteGraphNode;
import com.opensymphony.webwork.sitegraph.model.SubGraph;
import com.opensymphony.webwork.sitegraph.model.ViewNode;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DOTRenderer {
    private Writer writer;
    private List links = new ArrayList();
    static /* synthetic */ Class class$com$opensymphony$xwork$ActionChainResult;

    public DOTRenderer(Writer writer) {
        this.writer = writer;
    }

    public void render(String ns) {
        Graph graph = new Graph();
        TreeMap<ViewNode, View> viewMap = new TreeMap<ViewNode, View>(new Comparator(){

            public int compare(Object o1, Object o2) {
                ViewNode v1 = (ViewNode)o1;
                ViewNode v2 = (ViewNode)o2;
                return v1.getFullName().compareTo(v2.getFullName());
            }
        });
        Set namespaces = XWorkConfigRetriever.getNamespaces();
        Iterator iter = namespaces.iterator();
        while (iter.hasNext()) {
            String namespace = (String)iter.next();
            if (!namespace.startsWith(ns)) continue;
            SubGraph subGraph = graph.create(namespace);
            Set actionNames = XWorkConfigRetriever.getActionNames(namespace);
            Iterator iterator = actionNames.iterator();
            while (iterator.hasNext()) {
                String actionName = (String)iterator.next();
                ActionConfig actionConfig = XWorkConfigRetriever.getActionConfig(namespace, actionName);
                ActionNode action = new ActionNode(actionName);
                subGraph.addNode(action);
                Set resultNames = actionConfig.getResults().keySet();
                Iterator iterator2 = resultNames.iterator();
                while (iterator2.hasNext()) {
                    String location;
                    String resultName = (String)iterator2.next();
                    ResultConfig resultConfig = (ResultConfig)actionConfig.getResults().get(resultName);
                    String resultClassName = resultConfig.getClassName();
                    if (resultClassName.equals((class$com$opensymphony$xwork$ActionChainResult == null ? DOTRenderer.class$("com.opensymphony.xwork.ActionChainResult") : class$com$opensymphony$xwork$ActionChainResult).getName())) continue;
                    if (resultClassName.indexOf("Dispatcher") != -1 || resultClassName.indexOf("Velocity") != -1 || resultClassName.indexOf("Freemarker") != -1) {
                        if (resultConfig.getParams().get("location") == null) continue;
                        String location2 = this.getViewLocation((String)resultConfig.getParams().get("location"), namespace);
                        if (location2.endsWith((String)Configuration.get("webwork.action.extension"))) {
                            this.addTempLink(action, location2, 3, resultConfig.getName());
                            continue;
                        }
                        ViewNode view = new ViewNode(this.stripLocation(location2));
                        subGraph.addNode(view);
                        this.addTempLink(action, location2, 3, resultConfig.getName());
                        View viewFile = this.getView(namespace, actionName, resultName, location2);
                        if (viewFile == null) continue;
                        viewMap.put(view, viewFile);
                        continue;
                    }
                    if (resultClassName.indexOf("Jasper") != -1 || resultClassName.indexOf("XSLT") != -1 || resultClassName.indexOf("Redirect") == -1) continue;
                    String locationConfig = (String)resultConfig.getParams().get("location");
                    if (locationConfig == null) {
                        locationConfig = (String)resultConfig.getParams().get("actionName");
                    }
                    if ((location = this.getViewLocation(locationConfig, namespace)).endsWith((String)Configuration.get("webwork.action.extension"))) {
                        this.addTempLink(action, location, 4, resultConfig.getName());
                        continue;
                    }
                    ViewNode view = new ViewNode(this.stripLocation(location));
                    subGraph.addNode(view);
                    this.addTempLink(action, location, 4, resultConfig.getName());
                    View viewFile = this.getView(namespace, actionName, resultName, location);
                    if (viewFile == null) continue;
                    viewMap.put(view, viewFile);
                }
            }
        }
        Iterator iterator = viewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ViewNode view = (ViewNode)entry.getKey();
            View viewFile = (View)entry.getValue();
            Set targets = viewFile.getTargets();
            Iterator iterator1 = targets.iterator();
            while (iterator1.hasNext()) {
                Target target = (Target)iterator1.next();
                String viewTarget = target.getTarget();
                this.addTempLink(view, viewTarget, target.getType(), "");
            }
        }
        iterator = this.links.iterator();
        while (iterator.hasNext()) {
            SiteGraphNode to;
            TempLink temp = (TempLink)((Object)iterator.next());
            String location = temp.location;
            if (location.endsWith((String)Configuration.get("webwork.action.extension")) && (location = location.substring(0, location.indexOf((String)Configuration.get("webwork.action.extension")) - 1)).indexOf(33) != -1) {
                temp.label = temp.label + "\\n(" + location.substring(location.indexOf(33)) + ")";
                location = location.substring(0, location.indexOf(33));
            }
            if ((to = graph.findNode(location, temp.node)) == null) continue;
            graph.addLink(new Link(temp.node, to, temp.typeResult, temp.label));
        }
        try {
            graph.render(new IndentWriter(this.writer));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addTempLink(SiteGraphNode node, String location, int type, String label) {
        this.links.add(new TempLink(node, location, type, label));
    }

    private String stripLocation(String location) {
        return location.substring(location.lastIndexOf(47) + 1);
    }

    private View getView(String namespace, String actionName, String resultName, String location) {
        int type = 0;
        if (location.endsWith(".fm") || location.endsWith(".ftl")) {
            type = 2;
        } else if (location.endsWith(".vm")) {
            type = 1;
        }
        return XWorkConfigRetriever.getView(namespace, actionName, resultName, type);
    }

    private String getViewLocation(String location, String namespace) {
        String view = null;
        view = !location.startsWith("/") ? namespace + "/" + location : location;
        if (view.indexOf(63) != -1) {
            view = view.substring(0, view.indexOf(63));
        }
        return view;
    }

    class TempLink {
        SiteGraphNode node;
        String location;
        int typeResult;
        String label;

        public TempLink(SiteGraphNode node, String location, int typeResult, String label) {
            this.node = node;
            this.location = location;
            this.typeResult = typeResult;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TempLink)) {
                return false;
            }
            TempLink tempLink = (TempLink)o;
            if (this.typeResult != tempLink.typeResult) {
                return false;
            }
            if (this.label != null ? !this.label.equals(tempLink.label) : tempLink.label != null) {
                return false;
            }
            if (this.location != null ? !this.location.equals(tempLink.location) : tempLink.location != null) {
                return false;
            }
            return !(this.node != null ? !this.node.equals(tempLink.node) : tempLink.node != null);
        }

        public int hashCode() {
            int result = this.node != null ? this.node.hashCode() : 0;
            result = 29 * result + (this.location != null ? this.location.hashCode() : 0);
            result = 29 * result + this.typeResult;
            result = 29 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }
    }
}

