/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.resources.IDeployCapability;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployCapability
implements IDeployCapability {
    private static final List<String> COMPLETED_STATES = Arrays.asList("Complete", "Failed");
    private static final Logger LOG = LoggerFactory.getLogger(DeployCapability.class);
    private final IClient client;
    private final IDeploymentConfig config;

    public DeployCapability(IDeploymentConfig config, IClient client) {
        this.config = config;
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return DeployCapability.class.getSimpleName();
    }

    @Override
    public void deploy() {
        block3: {
            try {
                String deploymentName = this.getLatestDeploymentName();
                LOG.debug("Attempting to deploy latest deployment for config %s.  Loading deployment: %s", (Object)this.config.getName(), (Object)deploymentName);
                IReplicationController deployment = (IReplicationController)this.client.get("ReplicationController", deploymentName, this.config.getNamespaceName());
                String status = this.getStatusFor(deployment);
                if (!COMPLETED_STATES.contains(status)) {
                    LOG.debug("Skipping deployment because deployment status %s for %s is not in %s", new Object[]{status, deploymentName, COMPLETED_STATES});
                    return;
                }
            }
            catch (OpenShiftException e) {
                if (e.getStatus() != null && e.getStatus().getCode() == 404) break block3;
                throw e;
            }
        }
        int version = this.config.getLatestVersionNumber();
        this.config.setLatestVersionNumber(++version);
        this.client.update(this.config);
    }

    private String getLatestDeploymentName() {
        return String.format("%s-%d", this.config.getName(), this.config.getLatestVersionNumber());
    }

    private String getStatusFor(IReplicationController rc) {
        if (rc.isAnnotatedWith("openshift.io/deployment.phase")) {
            return rc.getAnnotation("openshift.io/deployment.phase");
        }
        return "";
    }
}

