/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.RequestingSupplier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationEndpoints {
    public static final String PATH_OAUTH_AUTHORIZATION_SERVER = ".well-known/oauth-authorization-server";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationEndpoints.class);
    private RequestingSupplier<ModelNode> endpointsSupplier;

    protected AuthorizationEndpoints(String baseUrl, OkHttpClient client) {
        this.endpointsSupplier = new RequestingSupplier<ModelNode>(baseUrl + "/" + PATH_OAUTH_AUTHORIZATION_SERVER, "authorization- & token-endpoint", client){

            @Override
            protected ModelNode extractValue(String response) {
                return ModelNode.fromJSONString((String)response);
            }

            @Override
            protected ModelNode getDefaultValue() {
                return null;
            }
        };
    }

    public URL getAuthorizationEndpoint() {
        return this.getEndpoint(node -> node.get("authorization_endpoint").asString(), "authorization-endpoint");
    }

    public URL getTokenEndpoint() {
        return this.getEndpoint(node -> node.get("token_endpoint").asString(), "token_endpoint");
    }

    private URL getEndpoint(Function<ModelNode, String> extractor, String description) {
        URL authorizationEndpoint = null;
        try {
            ModelNode node = this.endpointsSupplier.get();
            if (node != null) {
                try {
                    authorizationEndpoint = new URL(extractor.apply(node));
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Failed to determine {}.", (Object)description, (Object)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Could not determine {} endpoint: invalid JSON.", (Object)description);
        }
        return authorizationEndpoint;
    }
}

