/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.svgsupport.PDFTranscoder;
import com.openhtmltopdf.util.XRLog;
import java.util.Set;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.util.ParsedURL;

public class OpenHtmlUserAgent
extends UserAgentAdapter {
    private final PDFTranscoder.OpenHtmlFontResolver resolver;
    private final boolean allowScripts;
    private final boolean allowExternalResources;
    private final Set<String> allowedProtocols;

    public OpenHtmlUserAgent(PDFTranscoder.OpenHtmlFontResolver resolver, boolean allowScripts, boolean allowExternalResources, Set<String> allowedProtocols) {
        this.resolver = resolver;
        this.allowScripts = allowScripts;
        this.allowExternalResources = allowExternalResources;
        this.allowedProtocols = allowedProtocols;
    }

    public FontFamilyResolver getFontFamilyResolver() {
        return this.resolver;
    }

    public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
        if (!this.allowScripts) {
            XRLog.exception((String)("Tried to run script inside SVG. Refusing. Details: " + scriptType + ", " + scriptURL + ", " + docURL));
            throw new SecurityException("Tried to run script inside SVG!");
        }
    }

    public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
        if (!(this.allowExternalResources || this.allowedProtocols != null && this.allowedProtocols.contains(resourceURL.getProtocol()))) {
            XRLog.exception((String)("Tried to fetch external resource from SVG. Refusing. Details: " + resourceURL + ", " + docURL));
            throw new SecurityException("Tried to fetch external resource (" + resourceURL + ") from SVG. Refused!");
        }
    }
}

