/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;

public class PDFGraphics2DOutputDeviceAdapter
extends AbstractGraphics2D {
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private final RenderingContext ctx;
    private final OutputDevice od;
    private final Graphics2D g2d2;
    private final double x;
    private final double y;
    private final AffineTransform defaultTransform;
    private Color _c = Color.BLACK;
    private Stroke _stroke;
    private Paint _paint = Color.BLACK;
    private Composite _composite = AlphaComposite.getInstance(2);
    private Color _background = Color.WHITE;
    private final AffineTransform scaleToPdf;

    public PDFGraphics2DOutputDeviceAdapter(RenderingContext ctx, OutputDevice od, double x, double y) {
        super(false);
        this.od = od;
        this.ctx = ctx;
        this.x = x;
        this.y = y;
        AffineTransform locate = AffineTransform.getTranslateInstance(x, y);
        AffineTransform scale = AffineTransform.getScaleInstance(20.0, 20.0);
        this.scaleToPdf = new AffineTransform();
        locate.concatenate(scale);
        locate.concatenate(this.scaleToPdf);
        this.defaultTransform = locate;
        BufferedImage img = new BufferedImage(2, 1, 1);
        this.g2d2 = img.createGraphics();
        this.gc = new GraphicContext();
    }

    public Shape getClip() {
        return this.od.getRawClip();
    }

    public void setClip(Shape arg0) {
        this.od.setRawClip(arg0);
    }

    public void clip(Shape arg0) {
        this.od.rawClip(arg0);
    }

    public Composite getComposite() {
        return this._composite;
    }

    public void setBackground(Color arg0) {
        this._background = arg0;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setColor(Color arg0) {
        this._c = arg0;
    }

    public Color getColor() {
        return this._c;
    }

    public void setPaint(Paint in) {
        if (in instanceof LinearGradientPaint) {
            LinearGradientPaint lg = (LinearGradientPaint)in;
            in = lg.getColors()[0];
        }
        this._paint = in;
    }

    public Rectangle getClipBounds() {
        return this.getClip().getBounds();
    }

    public Paint getPaint() {
        return this._paint;
    }

    public void setComposite(Composite arg0) {
        this._composite = arg0;
    }

    public void setStroke(Stroke arg0) {
        this._stroke = arg0;
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public void drawString(String str, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void draw(Shape s) {
        Color c = this.getColor();
        this.od.setColor((FSColor)new FSRGBColor(c.getRed(), c.getGreen(), c.getBlue()));
        this.od.setAlpha(c.getAlpha());
        if (!this.getTransform().isIdentity()) {
            // empty if block
        }
        this.od.setStroke(this.getStroke());
        this.od.setPaint(this.getPaint());
        this.od.saveState();
        this.od.draw(this.defaultTransform.createTransformedShape(s));
        this.od.restoreState();
    }

    public void fill(Shape s) {
        Color c = this.getColor();
        this.od.setColor((FSColor)new FSRGBColor(c.getRed(), c.getGreen(), c.getBlue()));
        this.od.setAlpha(c.getAlpha());
        if (!this.getTransform().isIdentity()) {
            // empty if block
        }
        this.od.setPaint(this.getPaint());
        this.od.saveState();
        this.od.fill(this.defaultTransform.createTransformedShape(s));
        this.od.restoreState();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new GraphicsConfiguration(){

            @Override
            public AffineTransform getNormalizingTransform() {
                return null;
            }

            @Override
            public GraphicsDevice getDevice() {
                return null;
            }

            @Override
            public AffineTransform getDefaultTransform() {
                return null;
            }

            @Override
            public ColorModel getColorModel(int transparency) {
                return ColorModel.getRGBdefault();
            }

            @Override
            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            @Override
            public Rectangle getBounds() {
                return null;
            }
        };
    }

    public Graphics create() {
        return new PDFGraphics2DOutputDeviceAdapter(this.ctx, this.od, this.x, this.y);
    }

    public void setXORMode(Color c1) {
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g2d2.getFontMetrics(f);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    public void dispose() {
    }
}

