/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.mathmlsupport;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.mathmlsupport.MathMLImage;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.sourceforge.jeuclid.font.DefaultFontFactory;
import net.sourceforge.jeuclid.font.FontFactory;
import org.w3c.dom.Element;

public class MathMLDrawer
implements SVGDrawer {
    private final FontFactory _fontFactory;
    private SharedContext _sharedCtx;
    private final Set<String> _loadedFontFamilies = new HashSet<String>();
    private final Map<String, List<String>> _availabelFontFamilies = new HashMap<String, List<String>>();

    public MathMLDrawer() {
        this._fontFactory = new DefaultFontFactory();
        FontFactory.setThreadFontFactory((FontFactory)this._fontFactory);
    }

    public void importFontFaceRules(List<FontFaceRule> fontFaces, SharedContext shared) {
        for (FontFaceRule rule : fontFaces) {
            this._sharedCtx = shared;
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE || !rule.hasFontFamily()) continue;
            String family = style.valueByName(CSSName.FONT_FAMILY).asString();
            if (this._availabelFontFamilies.containsKey(family)) {
                this._availabelFontFamilies.get(family).add(src.asString());
                continue;
            }
            this._availabelFontFamilies.put(family, new ArrayList());
            this._availabelFontFamilies.get(family).add(src.asString());
        }
    }

    private void loadFamilyFonts(String family) {
        if (this._loadedFontFamilies.contains(family)) {
            return;
        }
        this._loadedFontFamilies.add(family);
        if (!this._availabelFontFamilies.containsKey(family)) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_COULD_NOT_FIND_FONT_SPECIFIED_FOR_MATHML_OBJECT_IN_FONT_FACE_RULES, (Object)family);
            return;
        }
        for (String src : this._availabelFontFamilies.get(family)) {
            byte[] font1 = this._sharedCtx.getUserAgentCallback().getBinaryResource(src);
            if (font1 == null) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_FONT, (Object)src);
                continue;
            }
            try {
                this._fontFactory.registerFont(0, (InputStream)new ByteArrayInputStream(font1));
            }
            catch (FontFormatException | IOException e) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_MATHML_COULD_NOT_REGISTER_FONT, (Throwable)e);
            }
        }
    }

    public SVGDrawer.SVGImage buildSVGImage(Element mathMlElement, Box box, CssContext c, double cssWidth, double cssHeight, double dotsPerPixel) {
        String[] fonts;
        for (String family : fonts = box.getStyle().asStringArray(CSSName.FONT_FAMILY)) {
            this.loadFamilyFonts(family);
        }
        double cssMaxWidth = CalculatedStyle.getCSSMaxWidth((CssContext)c, (Box)box);
        double cssMaxHeight = CalculatedStyle.getCSSMaxHeight((CssContext)c, (Box)box);
        List<String> fontList = Arrays.asList(fonts);
        MathMLImage img = new MathMLImage(mathMlElement, box, cssWidth, cssHeight, cssMaxWidth, cssMaxHeight, dotsPerPixel, fontList);
        return img;
    }

    public void close() throws IOException {
        FontFactory.clearThreadFontFactory();
    }
}

