/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.mathmlsupport;

import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Graphics2D;
import java.util.List;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MathMLImage
implements SVGDrawer.SVGImage {
    private final JEuclidView _view;
    private final DocumentElement _mathDoc;
    private final double _dotsPerPixel;
    private final MathLayoutContext _context = new MathLayoutContext();
    private final double _scaledWidthInOutputDeviceDots;
    private final double _scaledHeightInOutputDeviceDots;
    private double _sx = 1.0;
    private double _sy = 1.0;

    private boolean haveValue(double val) {
        return val >= 0.0;
    }

    private double minIgnoringNoValues(double spec, double max) {
        if (this.haveValue(spec) && this.haveValue(max)) {
            return Math.min(spec, max);
        }
        return this.haveValue(spec) ? spec : max;
    }

    public MathMLImage(Element mathMlElement, double cssWidth, double cssHeight, double cssMaxWidth, double cssMaxHeight, double dotsPerPixel, List<String> fonts) {
        this._dotsPerPixel = dotsPerPixel;
        this._mathDoc = DOMBuilder.getInstance().createJeuclidDom((Node)mathMlElement);
        this._context.setParameter(Parameter.FONTS_SERIF, fonts);
        this._context.setParameter(Parameter.FONTS_DOUBLESTRUCK, fonts);
        this._context.setParameter(Parameter.FONTS_FRAKTUR, fonts);
        this._context.setParameter(Parameter.FONTS_MONOSPACED, fonts);
        this._context.setParameter(Parameter.FONTS_SANSSERIF, fonts);
        this._context.setParameter(Parameter.FONTS_SCRIPT, fonts);
        this._context.setParameter(Parameter.MATHSIZE, Float.valueOf(16.0f));
        this._view = new JEuclidView((Node)this._mathDoc, (LayoutContext)this._context, null);
        if (this.getViewWidthInOutputDeviceDots() <= 0.0 || this.getViewHeightInOutputDeviceDots() <= 0.0) {
            this._scaledWidthInOutputDeviceDots = 0.0;
            this._scaledHeightInOutputDeviceDots = 0.0;
            return;
        }
        boolean haveBoth = this.haveValue(cssWidth) && this.haveValue(cssHeight);
        boolean haveNone = !this.haveValue(cssWidth) && !this.haveValue(cssHeight);
        boolean haveOne = !haveBoth && !haveNone;
        double w = -1.0;
        double h = -1.0;
        if (haveBoth) {
            w = this.minIgnoringNoValues(cssWidth, cssMaxWidth);
            h = this.minIgnoringNoValues(cssHeight, cssMaxHeight);
        } else if (haveNone) {
            double prelimW = this.minIgnoringNoValues(this.getViewWidthInOutputDeviceDots(), cssMaxWidth);
            double prelimH = this.minIgnoringNoValues(this.getViewHeightInOutputDeviceDots(), cssMaxHeight);
            double prelimScaleX = prelimW / this.getViewWidthInOutputDeviceDots();
            double prelimScaleY = prelimH / this.getViewHeightInOutputDeviceDots();
            double scale = Math.min(prelimScaleX, prelimScaleY);
            w = scale * this.getViewWidthInOutputDeviceDots();
            h = scale * this.getViewHeightInOutputDeviceDots();
        } else if (haveOne) {
            if (this.haveValue(cssWidth)) {
                double prelimW = this.minIgnoringNoValues(cssWidth, cssMaxWidth);
                double prelimScale = prelimW / this.getViewWidthInOutputDeviceDots();
                double prelimH = this.getViewHeightInOutputDeviceDots() * prelimScale;
                double scale = this.haveValue(cssMaxHeight) && prelimH > cssMaxHeight ? cssMaxHeight / this.getViewHeightInOutputDeviceDots() : prelimScale;
                w = scale * this.getViewWidthInOutputDeviceDots();
                h = scale * this.getViewHeightInOutputDeviceDots();
            } else if (this.haveValue(cssHeight)) {
                double prelimH = this.minIgnoringNoValues(cssHeight, cssMaxHeight);
                double prelimScale = prelimH / this.getViewHeightInOutputDeviceDots();
                double prelimW = this.getViewWidthInOutputDeviceDots() * prelimScale;
                double scale = this.haveValue(cssMaxWidth) && prelimW > cssMaxWidth ? cssMaxWidth / this.getViewWidthInOutputDeviceDots() : prelimScale;
                w = scale * this.getViewWidthInOutputDeviceDots();
                h = scale * this.getViewHeightInOutputDeviceDots();
            }
        }
        this._sx = w / this.getViewWidthInOutputDeviceDots();
        this._sy = h / this.getViewHeightInOutputDeviceDots();
        this._scaledWidthInOutputDeviceDots = w;
        this._scaledHeightInOutputDeviceDots = h;
    }

    private double getViewWidthInOutputDeviceDots() {
        return (double)this._view.getWidth() * this._dotsPerPixel;
    }

    private double getViewHeightInOutputDeviceDots() {
        return (double)(this._view.getAscentHeight() + this._view.getDescentHeight()) * this._dotsPerPixel;
    }

    public int getIntrinsicWidth() {
        return (int)this._scaledWidthInOutputDeviceDots;
    }

    public int getIntrinsicHeight() {
        return (int)this._scaledHeightInOutputDeviceDots;
    }

    public void drawSVG(OutputDevice outputDevice, RenderingContext ctx, double x, double y) {
        outputDevice.drawWithGraphics((float)x, (float)y, (float)this._scaledWidthInOutputDeviceDots, (float)this._scaledHeightInOutputDeviceDots, new OutputDeviceGraphicsDrawer(){

            public void render(Graphics2D g2d) {
                g2d.scale(MathMLImage.this._sx, MathMLImage.this._sy);
                MathMLImage.this._view.draw(g2d, 0.0f, MathMLImage.this._view.getAscentHeight());
            }
        });
    }

    public static class MathLayoutContext
    extends LayoutContextImpl {
        private static final long serialVersionUID = 1L;
    }
}

