/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d.api;

import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.java2d.Java2DRenderer;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.EmptyReplacedElement;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Java2DRendererBuilder
extends BaseRendererBuilder<Java2DRendererBuilder> {
    protected Graphics2D _layoutGraphics;
    protected FSPageProcessor _pageProcessor;
    private List<AddedFont> _fonts = new ArrayList<AddedFont>();

    public Java2DRendererBuilder useLayoutGraphics(Graphics2D g2d) {
        this._layoutGraphics = g2d;
        return this;
    }

    public Java2DRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily, Integer fontWeight, BaseRendererBuilder.FontStyle fontStyle) {
        this._fonts.add(new AddedFont(supplier, fontWeight, fontFamily, fontStyle));
        return this;
    }

    public Java2DRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily) {
        return this.useFont(supplier, fontFamily, 400, BaseRendererBuilder.FontStyle.NORMAL);
    }

    public Java2DRendererBuilder useInitialPageNumber(int pageNumberInitial) {
        this._initialPageNumber = pageNumberInitial;
        return this;
    }

    public Java2DRendererBuilder toSinglePage(FSPageProcessor pageProcessor) {
        this._pagingMode = 1;
        this._pageProcessor = pageProcessor;
        return this;
    }

    public Java2DRendererBuilder toPageProcessor(FSPageProcessor pageProcessor) {
        this._pagingMode = (short)2;
        this._pageProcessor = pageProcessor;
        return this;
    }

    public void runPaged() throws Exception {
        Java2DRenderer renderer = this.buildJava2DRenderer();
        renderer.layout();
        if (this._pagingMode == 2) {
            renderer.writePages();
        } else {
            renderer.writeSinglePage();
        }
    }

    public void runFirstPage() throws Exception {
        Java2DRenderer renderer = this.buildJava2DRenderer();
        renderer.layout();
        if (this._pagingMode == 2) {
            renderer.writePage(0);
        } else {
            renderer.writeSinglePage();
        }
    }

    public Java2DRenderer buildJava2DRenderer() {
        UnicodeImplementation unicode = new UnicodeImplementation(this._reorderer, this._splitter, this._lineBreaker, this._unicodeToLowerTransformer, this._unicodeToUpperTransformer, this._unicodeToTitleTransformer, this._textDirection, this._charBreaker);
        PageDimensions pageSize = new PageDimensions(this._pageWidth, this._pageHeight, this._isPageSizeInches);
        BaseDocument doc = new BaseDocument(this._baseUri, this._html, this._document, this._file, this._uri);
        if (this._layoutGraphics == null) {
            BufferedImage bf = new BufferedImage(1, 1, 6);
            this._layoutGraphics = bf.createGraphics();
        }
        return new Java2DRenderer(doc, unicode, this._httpStreamFactory, this._resolver, this._cache, this._svgImpl, this._mathmlImpl, pageSize, this._replacementText, this._testMode, this._pageProcessor, this._layoutGraphics, this._initialPageNumber, this._pagingMode, this._objectDrawerFactory, this._preferredTransformerFactoryImplementationClass, this._preferredDocumentBuilderFactoryImplementationClass, this._domMutators);
    }

    public static abstract class Graphics2DPaintingReplacedElement
    extends EmptyReplacedElement {
        public static double DOTS_PER_INCH = 72.0;

        protected Graphics2DPaintingReplacedElement(int width, int height) {
            super(width, height);
        }

        public abstract void paint(OutputDevice var1, RenderingContext var2, double var3, double var5, double var7, double var9);
    }

    private static class AddedFont {
        private final FSSupplier<InputStream> supplier;
        private final Integer weight;
        private final String family;
        private final BaseRendererBuilder.FontStyle style;

        private AddedFont(FSSupplier<InputStream> supplier, Integer weight, String family, BaseRendererBuilder.FontStyle style) {
            this.supplier = supplier;
            this.weight = weight;
            this.family = family;
            this.style = style;
        }
    }
}

