/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.java2d.Java2DObjectDrawerReplacedElement;
import com.openhtmltopdf.java2d.Java2DSVGReplacedElement;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.swing.SwingReplacedElementFactory;
import org.w3c.dom.Element;

public class Java2DReplacedElementFactory
extends SwingReplacedElementFactory {
    private final SVGDrawer _svgImpl;
    private final FSObjectDrawerFactory _objectDrawerFactory;
    private final SVGDrawer _mathMLImpl;

    public Java2DReplacedElementFactory(SVGDrawer svgImpl, FSObjectDrawerFactory objectDrawerFactory, SVGDrawer mathMLImpl) {
        this._svgImpl = svgImpl;
        this._objectDrawerFactory = objectDrawerFactory;
        this._mathMLImpl = mathMLImpl;
    }

    public ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        FSObjectDrawer drawer;
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("math") && this._mathMLImpl != null) {
            return new Java2DSVGReplacedElement(e, this._mathMLImpl, cssWidth, cssHeight, (Box)box, (CssContext)context);
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return new Java2DSVGReplacedElement(e, this._svgImpl, cssWidth, cssHeight, (Box)box, (CssContext)context);
        }
        if (nodeName.equals("object") && this._objectDrawerFactory != null && (drawer = this._objectDrawerFactory.createDrawer(e)) != null) {
            return new Java2DObjectDrawerReplacedElement(e, drawer, cssWidth, cssHeight, context.getSharedContext().getDotsPerPixel());
        }
        return super.createReplacedElement(context, box, uac, cssWidth, cssHeight);
    }
}

