/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.google.common.base.MoreObjects;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.date.TenorAdjustment;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableIborIndex
implements IborIndex,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final boolean active;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendarId fixingCalendar;
    @PropertyDefinition(validate="notNull")
    private final LocalTime fixingTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId fixingZone;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment effectiveDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TenorAdjustment maturityDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount defaultFixedLegDayCount;
    private final transient String floatingRateName;
    private static final long serialVersionUID = 1L;

    private ImmutableIborIndex(String name, Currency currency, boolean active, HolidayCalendarId fixingCalendar, LocalTime fixingTime, ZoneId fixingZone, DaysAdjustment fixingDateOffset, DaysAdjustment effectiveDateOffset, TenorAdjustment maturityDateOffset, DayCount dayCount, DayCount defaultFixedLegDayCount) {
        this.name = (String)ArgChecker.notNull((Object)name, (String)"name");
        this.currency = (Currency)ArgChecker.notNull((Object)currency, (String)"currency");
        this.active = active;
        this.fixingCalendar = (HolidayCalendarId)ArgChecker.notNull((Object)fixingCalendar, (String)"fixingCalendar");
        this.fixingTime = (LocalTime)ArgChecker.notNull((Object)fixingTime, (String)"fixingTime");
        this.fixingZone = (ZoneId)ArgChecker.notNull((Object)fixingZone, (String)"fixingZone");
        this.fixingDateOffset = (DaysAdjustment)ArgChecker.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
        this.effectiveDateOffset = (DaysAdjustment)ArgChecker.notNull((Object)effectiveDateOffset, (String)"effectiveDateOffset");
        this.maturityDateOffset = (TenorAdjustment)ArgChecker.notNull((Object)maturityDateOffset, (String)"maturityDateOffset");
        this.dayCount = (DayCount)ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        this.defaultFixedLegDayCount = (DayCount)MoreObjects.firstNonNull((Object)defaultFixedLegDayCount, (Object)dayCount);
        String suffix = "-" + maturityDateOffset.getTenor().toString();
        if (!name.endsWith(suffix)) {
            throw new IllegalArgumentException(Messages.format((String)"IborIndex name '{}' must end with tenor '{}'", (Object[])new Object[]{name, maturityDateOffset.getTenor().toString()}));
        }
        this.floatingRateName = name.substring(0, name.length() - suffix.length());
    }

    private static void applyDefaults(Builder builder) {
        builder.active = true;
    }

    private Object readResolve() {
        return new ImmutableIborIndex(this.name, this.currency, this.active, this.fixingCalendar, this.fixingTime, this.fixingZone, this.fixingDateOffset, this.effectiveDateOffset, this.maturityDateOffset, this.dayCount, this.defaultFixedLegDayCount);
    }

    @Override
    public Tenor getTenor() {
        return this.maturityDateOffset.getTenor();
    }

    @Override
    public FloatingRateName getFloatingRateName() {
        return FloatingRateName.of(this.floatingRateName);
    }

    @Override
    public ZonedDateTime calculateFixingDateTime(LocalDate fixingDate) {
        return fixingDate.atTime(this.fixingTime).atZone(this.fixingZone);
    }

    @Override
    public LocalDate calculateEffectiveFromFixing(LocalDate fixingDate, ReferenceData refData) {
        LocalDate fixingBusinessDay = this.fixingCalendar.resolve(refData).nextOrSame(fixingDate);
        return this.effectiveDateOffset.adjust(fixingBusinessDay, refData);
    }

    @Override
    public LocalDate calculateMaturityFromFixing(LocalDate fixingDate, ReferenceData refData) {
        LocalDate fixingBusinessDay = this.fixingCalendar.resolve(refData).nextOrSame(fixingDate);
        return this.maturityDateOffset.adjust(this.effectiveDateOffset.adjust(fixingBusinessDay, refData), refData);
    }

    @Override
    public LocalDate calculateFixingFromEffective(LocalDate effectiveDate, ReferenceData refData) {
        LocalDate effectiveBusinessDay = this.effectiveDateCalendar(refData).nextOrSame(effectiveDate);
        return this.fixingDateOffset.adjust(effectiveBusinessDay, refData);
    }

    @Override
    public LocalDate calculateMaturityFromEffective(LocalDate effectiveDate, ReferenceData refData) {
        LocalDate effectiveBusinessDay = this.effectiveDateCalendar(refData).nextOrSame(effectiveDate);
        return this.maturityDateOffset.adjust(effectiveBusinessDay, refData);
    }

    private HolidayCalendar effectiveDateCalendar(ReferenceData refData) {
        HolidayCalendarId cal = this.effectiveDateOffset.getResultCalendar();
        if (cal == HolidayCalendarIds.NO_HOLIDAYS) {
            cal = this.fixingCalendar;
        }
        return cal.resolve(refData);
    }

    @Override
    public Function<LocalDate, IborIndexObservation> resolve(ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        DateAdjuster effectiveAdjuster = this.effectiveDateOffset.resolve(refData);
        DateAdjuster maturityAdjuster = this.maturityDateOffset.resolve(refData);
        return fixingDate -> this.create((LocalDate)fixingDate, fixingCal, effectiveAdjuster, maturityAdjuster);
    }

    private IborIndexObservation create(LocalDate fixingDate, HolidayCalendar fixingCal, DateAdjuster effectiveAdjuster, DateAdjuster maturityAdjuster) {
        LocalDate fixingBusinessDay = fixingCal.nextOrSame(fixingDate);
        LocalDate effectiveDate = effectiveAdjuster.adjust(fixingBusinessDay);
        LocalDate maturityDate = maturityAdjuster.adjust(effectiveDate);
        double yearFraction = this.dayCount.yearFraction(effectiveDate, maturityDate);
        return new IborIndexObservation(this, fixingDate, effectiveDate, maturityDate, yearFraction);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableIborIndex) {
            return this.name.equals(((ImmutableIborIndex)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public HolidayCalendarId getFixingCalendar() {
        return this.fixingCalendar;
    }

    public LocalTime getFixingTime() {
        return this.fixingTime;
    }

    public ZoneId getFixingZone() {
        return this.fixingZone;
    }

    @Override
    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    @Override
    public DaysAdjustment getEffectiveDateOffset() {
        return this.effectiveDateOffset;
    }

    @Override
    public TenorAdjustment getMaturityDateOffset() {
        return this.maturityDateOffset;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public DayCount getDefaultFixedLegDayCount() {
        return this.defaultFixedLegDayCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableIborIndex> {
        private String name;
        private Currency currency;
        private boolean active;
        private HolidayCalendarId fixingCalendar;
        private LocalTime fixingTime;
        private ZoneId fixingZone;
        private DaysAdjustment fixingDateOffset;
        private DaysAdjustment effectiveDateOffset;
        private TenorAdjustment maturityDateOffset;
        private DayCount dayCount;
        private DayCount defaultFixedLegDayCount;

        private Builder() {
            ImmutableIborIndex.applyDefaults(this);
        }

        private Builder(ImmutableIborIndex beanToCopy) {
            this.name = beanToCopy.getName();
            this.currency = beanToCopy.getCurrency();
            this.active = beanToCopy.isActive();
            this.fixingCalendar = beanToCopy.getFixingCalendar();
            this.fixingTime = beanToCopy.getFixingTime();
            this.fixingZone = beanToCopy.getFixingZone();
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.effectiveDateOffset = beanToCopy.getEffectiveDateOffset();
            this.maturityDateOffset = beanToCopy.getMaturityDateOffset();
            this.dayCount = beanToCopy.getDayCount();
            this.defaultFixedLegDayCount = beanToCopy.getDefaultFixedLegDayCount();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case -1422950650: {
                    return this.active;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case 1255686170: {
                    return this.fixingTime;
                }
                case 1255870713: {
                    return this.fixingZone;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1571923688: {
                    return this.effectiveDateOffset;
                }
                case 1574797394: {
                    return this.maturityDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -2037801138: {
                    return this.defaultFixedLegDayCount;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -1422950650: {
                    this.active = (Boolean)newValue;
                    break;
                }
                case 394230283: {
                    this.fixingCalendar = (HolidayCalendarId)newValue;
                    break;
                }
                case 1255686170: {
                    this.fixingTime = (LocalTime)newValue;
                    break;
                }
                case 1255870713: {
                    this.fixingZone = (ZoneId)newValue;
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1571923688: {
                    this.effectiveDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1574797394: {
                    this.maturityDateOffset = (TenorAdjustment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -2037801138: {
                    this.defaultFixedLegDayCount = (DayCount)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableIborIndex build() {
            return new ImmutableIborIndex(this.name, this.currency, this.active, this.fixingCalendar, this.fixingTime, this.fixingZone, this.fixingDateOffset, this.effectiveDateOffset, this.maturityDateOffset, this.dayCount, this.defaultFixedLegDayCount);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder fixingCalendar(HolidayCalendarId fixingCalendar) {
            JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
            this.fixingCalendar = fixingCalendar;
            return this;
        }

        public Builder fixingTime(LocalTime fixingTime) {
            JodaBeanUtils.notNull((Object)fixingTime, (String)"fixingTime");
            this.fixingTime = fixingTime;
            return this;
        }

        public Builder fixingZone(ZoneId fixingZone) {
            JodaBeanUtils.notNull((Object)fixingZone, (String)"fixingZone");
            this.fixingZone = fixingZone;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder effectiveDateOffset(DaysAdjustment effectiveDateOffset) {
            JodaBeanUtils.notNull((Object)effectiveDateOffset, (String)"effectiveDateOffset");
            this.effectiveDateOffset = effectiveDateOffset;
            return this;
        }

        public Builder maturityDateOffset(TenorAdjustment maturityDateOffset) {
            JodaBeanUtils.notNull((Object)maturityDateOffset, (String)"maturityDateOffset");
            this.maturityDateOffset = maturityDateOffset;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder defaultFixedLegDayCount(DayCount defaultFixedLegDayCount) {
            JodaBeanUtils.notNull((Object)defaultFixedLegDayCount, (String)"defaultFixedLegDayCount");
            this.defaultFixedLegDayCount = defaultFixedLegDayCount;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(384);
            buf.append("ImmutableIborIndex.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("active").append('=').append(JodaBeanUtils.toString((Object)this.active)).append(',').append(' ');
            buf.append("fixingCalendar").append('=').append(JodaBeanUtils.toString((Object)this.fixingCalendar)).append(',').append(' ');
            buf.append("fixingTime").append('=').append(JodaBeanUtils.toString((Object)this.fixingTime)).append(',').append(' ');
            buf.append("fixingZone").append('=').append(JodaBeanUtils.toString((Object)this.fixingZone)).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("effectiveDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.effectiveDateOffset)).append(',').append(' ');
            buf.append("maturityDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.maturityDateOffset)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("defaultFixedLegDayCount").append('=').append(JodaBeanUtils.toString((Object)this.defaultFixedLegDayCount));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableIborIndex.class, String.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ImmutableIborIndex.class, Currency.class);
        private final MetaProperty<Boolean> active = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"active", ImmutableIborIndex.class, Boolean.TYPE);
        private final MetaProperty<HolidayCalendarId> fixingCalendar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingCalendar", ImmutableIborIndex.class, HolidayCalendarId.class);
        private final MetaProperty<LocalTime> fixingTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingTime", ImmutableIborIndex.class, LocalTime.class);
        private final MetaProperty<ZoneId> fixingZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingZone", ImmutableIborIndex.class, ZoneId.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", ImmutableIborIndex.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> effectiveDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"effectiveDateOffset", ImmutableIborIndex.class, DaysAdjustment.class);
        private final MetaProperty<TenorAdjustment> maturityDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"maturityDateOffset", ImmutableIborIndex.class, TenorAdjustment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ImmutableIborIndex.class, DayCount.class);
        private final MetaProperty<DayCount> defaultFixedLegDayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"defaultFixedLegDayCount", ImmutableIborIndex.class, DayCount.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currency", "active", "fixingCalendar", "fixingTime", "fixingZone", "fixingDateOffset", "effectiveDateOffset", "maturityDateOffset", "dayCount", "defaultFixedLegDayCount"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case -1422950650: {
                    return this.active;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case 1255686170: {
                    return this.fixingTime;
                }
                case 1255870713: {
                    return this.fixingZone;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1571923688: {
                    return this.effectiveDateOffset;
                }
                case 1574797394: {
                    return this.maturityDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -2037801138: {
                    return this.defaultFixedLegDayCount;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableIborIndex> beanType() {
            return ImmutableIborIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Boolean> active() {
            return this.active;
        }

        public MetaProperty<HolidayCalendarId> fixingCalendar() {
            return this.fixingCalendar;
        }

        public MetaProperty<LocalTime> fixingTime() {
            return this.fixingTime;
        }

        public MetaProperty<ZoneId> fixingZone() {
            return this.fixingZone;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<DaysAdjustment> effectiveDateOffset() {
            return this.effectiveDateOffset;
        }

        public MetaProperty<TenorAdjustment> maturityDateOffset() {
            return this.maturityDateOffset;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<DayCount> defaultFixedLegDayCount() {
            return this.defaultFixedLegDayCount;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableIborIndex)bean).getName();
                }
                case 575402001: {
                    return ((ImmutableIborIndex)bean).getCurrency();
                }
                case -1422950650: {
                    return ((ImmutableIborIndex)bean).isActive();
                }
                case 394230283: {
                    return ((ImmutableIborIndex)bean).getFixingCalendar();
                }
                case 1255686170: {
                    return ((ImmutableIborIndex)bean).getFixingTime();
                }
                case 1255870713: {
                    return ((ImmutableIborIndex)bean).getFixingZone();
                }
                case 873743726: {
                    return ((ImmutableIborIndex)bean).getFixingDateOffset();
                }
                case 1571923688: {
                    return ((ImmutableIborIndex)bean).getEffectiveDateOffset();
                }
                case 1574797394: {
                    return ((ImmutableIborIndex)bean).getMaturityDateOffset();
                }
                case 1905311443: {
                    return ((ImmutableIborIndex)bean).getDayCount();
                }
                case -2037801138: {
                    return ((ImmutableIborIndex)bean).getDefaultFixedLegDayCount();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

