/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.LocalDateUtils;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Tenor
implements Comparable<Tenor>,
TemporalAmount,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Tenor TENOR_1D = Tenor.ofDays(1);
    public static final Tenor TENOR_2D = Tenor.ofDays(2);
    public static final Tenor TENOR_3D = Tenor.ofDays(3);
    public static final Tenor TENOR_1W = Tenor.ofWeeks(1);
    public static final Tenor TENOR_2W = Tenor.ofWeeks(2);
    public static final Tenor TENOR_3W = Tenor.ofWeeks(3);
    public static final Tenor TENOR_4W = Tenor.ofWeeks(4);
    public static final Tenor TENOR_6W = Tenor.ofWeeks(6);
    public static final Tenor TENOR_13W = Tenor.ofWeeks(13);
    public static final Tenor TENOR_26W = Tenor.ofWeeks(26);
    public static final Tenor TENOR_52W = Tenor.ofWeeks(52);
    public static final Tenor TENOR_1M = Tenor.ofMonths(1);
    public static final Tenor TENOR_2M = Tenor.ofMonths(2);
    public static final Tenor TENOR_3M = Tenor.ofMonths(3);
    public static final Tenor TENOR_4M = Tenor.ofMonths(4);
    public static final Tenor TENOR_5M = Tenor.ofMonths(5);
    public static final Tenor TENOR_6M = Tenor.ofMonths(6);
    public static final Tenor TENOR_7M = Tenor.ofMonths(7);
    public static final Tenor TENOR_8M = Tenor.ofMonths(8);
    public static final Tenor TENOR_9M = Tenor.ofMonths(9);
    public static final Tenor TENOR_10M = Tenor.ofMonths(10);
    public static final Tenor TENOR_11M = Tenor.ofMonths(11);
    public static final Tenor TENOR_12M = Tenor.ofMonths(12);
    public static final Tenor TENOR_15M = Tenor.ofMonths(15);
    public static final Tenor TENOR_18M = Tenor.ofMonths(18);
    public static final Tenor TENOR_21M = Tenor.ofMonths(21);
    public static final Tenor TENOR_1Y = Tenor.ofYears(1);
    public static final Tenor TENOR_2Y = Tenor.ofYears(2);
    public static final Tenor TENOR_3Y = Tenor.ofYears(3);
    public static final Tenor TENOR_4Y = Tenor.ofYears(4);
    public static final Tenor TENOR_5Y = Tenor.ofYears(5);
    public static final Tenor TENOR_6Y = Tenor.ofYears(6);
    public static final Tenor TENOR_7Y = Tenor.ofYears(7);
    public static final Tenor TENOR_8Y = Tenor.ofYears(8);
    public static final Tenor TENOR_9Y = Tenor.ofYears(9);
    public static final Tenor TENOR_10Y = Tenor.ofYears(10);
    public static final Tenor TENOR_11Y = Tenor.ofYears(11);
    public static final Tenor TENOR_12Y = Tenor.ofYears(12);
    public static final Tenor TENOR_13Y = Tenor.ofYears(13);
    public static final Tenor TENOR_14Y = Tenor.ofYears(14);
    public static final Tenor TENOR_15Y = Tenor.ofYears(15);
    public static final Tenor TENOR_20Y = Tenor.ofYears(20);
    public static final Tenor TENOR_25Y = Tenor.ofYears(25);
    public static final Tenor TENOR_30Y = Tenor.ofYears(30);
    public static final Tenor TENOR_35Y = Tenor.ofYears(35);
    public static final Tenor TENOR_40Y = Tenor.ofYears(40);
    public static final Tenor TENOR_45Y = Tenor.ofYears(45);
    public static final Tenor TENOR_50Y = Tenor.ofYears(50);
    private final Period period;
    private final String name;

    public static Tenor of(Period period) {
        int days = period.getDays();
        long months = period.toTotalMonths();
        if (months == 0L && days != 0) {
            return Tenor.ofDays(days);
        }
        return new Tenor(period, period.toString().substring(1));
    }

    public static Tenor ofDays(int days) {
        if (days % 7 == 0) {
            return Tenor.ofWeeks(days / 7);
        }
        return new Tenor(Period.ofDays(days), days + "D");
    }

    public static Tenor ofWeeks(int weeks) {
        return new Tenor(Period.ofWeeks(weeks), weeks + "W");
    }

    public static Tenor ofMonths(int months) {
        return new Tenor(Period.ofMonths(months), months + "M");
    }

    public static Tenor ofYears(int years) {
        return new Tenor(Period.ofYears(years), years + "Y");
    }

    @FromString
    public static Tenor parse(String toParse) {
        String prefixed = toParse.startsWith("P") ? toParse : "P" + toParse;
        try {
            return Tenor.of(Period.parse(prefixed));
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private Tenor(Period period, String name) {
        ArgChecker.notNull((Object)period, (String)"period");
        ArgChecker.isFalse((boolean)period.isZero(), (String)"Period must not be zero");
        ArgChecker.isFalse((boolean)period.isNegative(), (String)"Period must not be negative");
        this.period = period;
        this.name = name;
    }

    private Object readResolve() {
        return new Tenor(this.period, this.name);
    }

    public Period getPeriod() {
        return this.period;
    }

    public Tenor normalized() {
        if (this.period.getDays() == 0 && this.period.toTotalMonths() == 12L) {
            return TENOR_12M;
        }
        Period norm = this.period.normalized();
        return norm != this.period ? Tenor.of(norm) : this;
    }

    public boolean isWeekBased() {
        return this.period.toTotalMonths() == 0L && this.period.getDays() % 7 == 0;
    }

    public boolean isMonthBased() {
        return this.period.toTotalMonths() > 0L && this.period.getDays() == 0;
    }

    @Override
    public long get(TemporalUnit unit) {
        return this.period.get(unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.period.getUnits();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (temporal instanceof LocalDate) {
            LocalDate date = (LocalDate)temporal;
            return LocalDateUtils.plusDays(date.plusMonths(this.period.toTotalMonths()), this.period.getDays());
        }
        return this.period.addTo(temporal);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (temporal instanceof LocalDate) {
            LocalDate date = (LocalDate)temporal;
            return LocalDateUtils.plusDays(date.minusMonths(this.period.toTotalMonths()), -this.period.getDays());
        }
        return this.period.subtractFrom(temporal);
    }

    @Override
    public int compareTo(Tenor other) {
        int thisDays = this.getPeriod().getDays();
        long thisMonths = this.getPeriod().toTotalMonths();
        int otherDays = other.getPeriod().getDays();
        long otherMonths = other.getPeriod().toTotalMonths();
        if (thisMonths == 0L && otherMonths == 0L) {
            return Integer.compare(thisDays, otherDays);
        }
        if (thisDays == 0 && otherDays == 0) {
            return Long.compare(thisMonths, otherMonths);
        }
        double thisMonthsInDays = (double)thisMonths / 12.0 * 365.25;
        double otherMonthsInDays = (double)otherMonths / 12.0 * 365.25;
        return Double.compare((double)thisDays + thisMonthsInDays, (double)otherDays + otherMonthsInDays);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tenor other = (Tenor)obj;
        return this.period.equals(other.period);
    }

    public int hashCode() {
        return this.period.hashCode();
    }

    @ToString
    public String toString() {
        return this.name;
    }
}

