/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import java.time.LocalDate;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class LocalDateUtils {
    private static final int[] STANDARD = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP = new int[]{0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    private LocalDateUtils() {
    }

    static int doy(LocalDate date) {
        int[] lookup = date.isLeapYear() ? LEAP : STANDARD;
        return lookup[date.getMonthValue()] + date.getDayOfMonth();
    }

    static LocalDate plusDays(LocalDate date, int daysToAdd) {
        if (daysToAdd == 0) {
            return date;
        }
        long dom = date.getDayOfMonth() + daysToAdd;
        if (dom > 0L && dom <= 59L) {
            int monthLen = date.lengthOfMonth();
            int month = date.getMonthValue();
            int year = date.getYear();
            if (dom <= (long)monthLen) {
                return LocalDate.of(year, month, (int)dom);
            }
            if (month < 12) {
                return LocalDate.of(year, month + 1, (int)(dom - (long)monthLen));
            }
            return LocalDate.of(year + 1, 1, (int)(dom - (long)monthLen));
        }
        long mjDay = Math.addExact(date.toEpochDay(), (long)daysToAdd);
        return LocalDate.ofEpochDay(mjDay);
    }

    static long daysBetween(LocalDate firstDate, LocalDate secondDate) {
        int secondYear;
        int firstYear = firstDate.getYear();
        if (firstYear == (secondYear = secondDate.getYear())) {
            return LocalDateUtils.doy(secondDate) - LocalDateUtils.doy(firstDate);
        }
        if (firstYear + 1 == secondYear) {
            return firstDate.lengthOfYear() - LocalDateUtils.doy(firstDate) + LocalDateUtils.doy(secondDate);
        }
        return secondDate.toEpochDay() - firstDate.toEpochDay();
    }

    static Stream<LocalDate> stream(final LocalDate startInclusive, final LocalDate endExclusive) {
        Iterator<LocalDate> it = new Iterator<LocalDate>(){
            private LocalDate current;
            {
                this.current = startInclusive;
            }

            @Override
            public LocalDate next() {
                LocalDate result = this.current;
                this.current = LocalDateUtils.plusDays(this.current, 1);
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.current.isBefore(endExclusive);
            }
        };
        long count = endExclusive.toEpochDay() - startInclusive.toEpochDay() + 1L;
        Spliterator<LocalDate> spliterator = Spliterators.spliterator(it, count, 17749);
        return StreamSupport.stream(spliterator, false);
    }
}

