/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BusinessDayAdjustment
implements Resolvable<DateAdjuster>,
ImmutableBean,
Serializable {
    public static final BusinessDayAdjustment NONE = new BusinessDayAdjustment(BusinessDayConventions.NO_ADJUST, HolidayCalendarIds.NO_HOLIDAYS);
    @PropertyDefinition(validate="notNull")
    private final BusinessDayConvention convention;
    @PropertyDefinition(validate="notNull")
    private final HolidayCalendarId calendar;
    private static final long serialVersionUID = 1L;

    public static BusinessDayAdjustment of(BusinessDayConvention convention, HolidayCalendarId calendar) {
        return new BusinessDayAdjustment(convention, calendar);
    }

    public LocalDate adjust(LocalDate date, ReferenceData refData) {
        HolidayCalendar holCal = this.calendar.resolve(refData);
        return this.convention.adjust(date, holCal);
    }

    @Override
    public DateAdjuster resolve(ReferenceData refData) {
        HolidayCalendar holCal = this.calendar.resolve(refData);
        return date -> this.convention.adjust(date, holCal);
    }

    public String toString() {
        if (this.equals(NONE)) {
            return this.convention.toString();
        }
        return this.convention + " using calendar " + this.calendar.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BusinessDayAdjustment(BusinessDayConvention convention, HolidayCalendarId calendar) {
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        JodaBeanUtils.notNull((Object)calendar, (String)"calendar");
        this.convention = convention;
        this.calendar = calendar;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BusinessDayConvention getConvention() {
        return this.convention;
    }

    public HolidayCalendarId getCalendar() {
        return this.calendar;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BusinessDayAdjustment other = (BusinessDayAdjustment)obj;
            return JodaBeanUtils.equal((Object)this.convention, (Object)other.convention) && JodaBeanUtils.equal((Object)this.calendar, (Object)other.calendar);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.calendar);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BusinessDayAdjustment> {
        private BusinessDayConvention convention;
        private HolidayCalendarId calendar;

        private Builder() {
        }

        private Builder(BusinessDayAdjustment beanToCopy) {
            this.convention = beanToCopy.getConvention();
            this.calendar = beanToCopy.getCalendar();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    return this.convention;
                }
                case -178324674: {
                    return this.calendar;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    this.convention = (BusinessDayConvention)newValue;
                    break;
                }
                case -178324674: {
                    this.calendar = (HolidayCalendarId)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BusinessDayAdjustment build() {
            return new BusinessDayAdjustment(this.convention, this.calendar);
        }

        public Builder convention(BusinessDayConvention convention) {
            JodaBeanUtils.notNull((Object)convention, (String)"convention");
            this.convention = convention;
            return this;
        }

        public Builder calendar(HolidayCalendarId calendar) {
            JodaBeanUtils.notNull((Object)calendar, (String)"calendar");
            this.calendar = calendar;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("BusinessDayAdjustment.Builder{");
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention)).append(',').append(' ');
            buf.append("calendar").append('=').append(JodaBeanUtils.toString((Object)this.calendar));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BusinessDayConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", BusinessDayAdjustment.class, BusinessDayConvention.class);
        private final MetaProperty<HolidayCalendarId> calendar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"calendar", BusinessDayAdjustment.class, HolidayCalendarId.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"convention", "calendar"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    return this.convention;
                }
                case -178324674: {
                    return this.calendar;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BusinessDayAdjustment> beanType() {
            return BusinessDayAdjustment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BusinessDayConvention> convention() {
            return this.convention;
        }

        public MetaProperty<HolidayCalendarId> calendar() {
            return this.calendar;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    return ((BusinessDayAdjustment)bean).getConvention();
                }
                case -178324674: {
                    return ((BusinessDayAdjustment)bean).getCalendar();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

