/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendars;
import com.opengamma.strata.collect.named.NamedLookup;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class Business252DayCount
implements NamedLookup<DayCount> {
    public static final Business252DayCount INSTANCE = new Business252DayCount();
    private static final ConcurrentMap<String, DayCount> BY_NAME = new ConcurrentHashMap<String, DayCount>();
    private static final ConcurrentMap<String, DayCount> BY_CALENDAR = new ConcurrentHashMap<String, DayCount>();

    private Business252DayCount() {
    }

    DayCount of(HolidayCalendar calendar) {
        return BY_CALENDAR.computeIfAbsent(calendar.getName(), this::createByCalendarName);
    }

    private DayCount createByCalendarName(String calendarName) {
        return this.lookup("Bus/252 " + calendarName);
    }

    public DayCount lookup(String name) {
        DayCount value = (DayCount)BY_NAME.get(name);
        if (value == null && name.regionMatches(true, 0, "Bus/252 ", 0, 8)) {
            HolidayCalendar cal = HolidayCalendars.of(name.substring(8));
            String correctName = "Bus/252 " + cal.getName();
            Bus252 created = new Bus252(correctName, cal);
            value = BY_NAME.computeIfAbsent(correctName, k -> created);
            BY_NAME.putIfAbsent(correctName.toUpperCase(Locale.ENGLISH), created);
        }
        return value;
    }

    public Map<String, DayCount> lookupAll() {
        return BY_NAME;
    }

    static final class Bus252
    implements DayCount,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final transient HolidayCalendar calendar;

        Bus252(String name, HolidayCalendar calendar) {
            this.name = name;
            this.calendar = calendar;
        }

        private Object readResolve() {
            return DayCount.of(this.name);
        }

        @Override
        public double yearFraction(LocalDate firstDate, LocalDate secondDate, DayCount.ScheduleInfo scheduleInfo) {
            if (secondDate.isBefore(firstDate)) {
                throw new IllegalArgumentException("Dates must be in time-line order");
            }
            return (double)this.calendar.daysBetween(firstDate, secondDate) / 252.0;
        }

        @Override
        public int days(LocalDate firstDate, LocalDate secondDate) {
            if (secondDate.isBefore(firstDate)) {
                throw new IllegalArgumentException("Dates must be in time-line order");
            }
            return this.calendar.daysBetween(firstDate, secondDate);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Bus252) {
                return ((Bus252)obj).name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

