/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxMatrix;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class FxMatrixBuilder {
    private static final int MINIMAL_MATRIX_SIZE = 8;
    private final LinkedHashMap<Currency, Integer> currencies;
    private double[][] rates;
    private final Map<CurrencyPair, Double> disjointRates = new HashMap<CurrencyPair, Double>();

    public FxMatrix build() {
        if (!this.disjointRates.isEmpty()) {
            throw new IllegalStateException("Received rates with no currencies in common with other: " + this.disjointRates);
        }
        return new FxMatrix((Map<Currency, Integer>)ImmutableMap.copyOf(this.currencies), DoubleMatrix.ofUnsafe((double[][])FxMatrixBuilder.copyArray(this.rates, this.currencies.size())));
    }

    public FxMatrixBuilder addRate(CurrencyPair currencyPair, double rate) {
        ArgChecker.notNull((Object)currencyPair, (String)"currencyPair");
        return this.addRate(currencyPair.getBase(), currencyPair.getCounter(), rate);
    }

    public FxMatrixBuilder addRate(Currency ccy1, Currency ccy2, double rate) {
        ArgChecker.notNull((Object)ccy1, (String)"ccy1");
        ArgChecker.notNull((Object)ccy2, (String)"ccy2");
        if (this.currencies.isEmpty()) {
            this.addInitialCurrencyPair(ccy1, ccy2, rate);
        } else {
            this.addCurrencyPair(ccy1, ccy2, rate);
        }
        return this;
    }

    public FxMatrixBuilder addRates(Map<CurrencyPair, Double> rates) {
        ArgChecker.notNull(rates, (String)"rates");
        if (!rates.isEmpty()) {
            this.ensureCapacity(rates.keySet().stream().flatMap(cp -> Stream.of(cp.getBase(), cp.getCounter())));
            MapStream.of(rates).forEach((pair, rate) -> this.addRate((CurrencyPair)pair, (double)rate));
        }
        return this;
    }

    FxMatrixBuilder() {
        this.currencies = new LinkedHashMap();
        this.rates = new double[8][8];
    }

    FxMatrixBuilder(ImmutableMap<Currency, Integer> currencies, double[][] rates) {
        this.currencies = new LinkedHashMap<Currency, Integer>((Map<Currency, Integer>)currencies);
        this.rates = FxMatrixBuilder.copyArray(rates, this.size(currencies.size() + 1));
    }

    FxMatrixBuilder merge(FxMatrixBuilder other) {
        Optional<Currency> common = this.currencies.keySet().stream().filter(other.currencies::containsKey).findFirst();
        Currency commonCurrency = common.orElseThrow(() -> new IllegalArgumentException("There are no currencies in common between " + this.currencies.keySet() + " and " + other.currencies.keySet()));
        MapStream.of(other.currencies).filterKeys(ccy -> !ccy.equals(commonCurrency) && !this.currencies.containsKey(ccy)).forEach((ccy, idx) -> this.addCurrencyPair(commonCurrency, (Currency)ccy, other.getRate(commonCurrency, (Currency)ccy)));
        return this;
    }

    private double getRate(Currency ccy1, Currency ccy2) {
        int i = this.currencies.get(ccy1);
        int j = this.currencies.get(ccy2);
        return this.rates[i][j];
    }

    private void addCurrencyPair(Currency ccy1, Currency ccy2, double rate) {
        if (this.rates.length < this.currencies.size() + 1) {
            this.ensureCapacity(Stream.of(ccy1, ccy2));
        }
        if (!this.currencies.containsKey(ccy1) && !this.currencies.containsKey(ccy2)) {
            this.disjointRates.put(CurrencyPair.of(ccy1, ccy2), rate);
        } else if (this.currencies.containsKey(ccy1) && this.currencies.containsKey(ccy2)) {
            this.updateRate(ccy1, ccy2, rate);
        } else {
            this.addNewRate(ccy1, ccy2, rate);
            this.retryDisjoints();
        }
    }

    private void retryDisjoints() {
        int initialSize;
        this.ensureCapacity(this.disjointRates.keySet().stream().flatMap(cp -> Stream.of(cp.getBase(), cp.getCounter())));
        do {
            initialSize = this.disjointRates.size();
            ImmutableMap addable = MapStream.of(this.disjointRates).filterKeys(pair -> this.currencies.containsKey(pair.getBase()) || this.currencies.containsKey(pair.getCounter())).toMap();
            MapStream.of((Map)addable).forEach((pair, rate) -> this.addNewRate(pair.getBase(), pair.getCounter(), (double)rate));
            addable.keySet().stream().forEach(this.disjointRates::remove);
        } while (this.disjointRates.size() != initialSize);
    }

    private void addNewRate(Currency ccy1, Currency ccy2, double rate) {
        Currency existing = this.currencies.containsKey(ccy1) ? ccy1 : ccy2;
        Currency other = existing == ccy1 ? ccy2 : ccy1;
        double updatedRate = existing == ccy2 ? 1.0 / rate : rate;
        int indexRef = this.currencies.get(existing);
        int indexOther = this.currencies.size();
        this.currencies.put(other, indexOther);
        this.rates[indexOther][indexOther] = 1.0;
        for (int i = 0; i < indexOther; ++i) {
            double convertedRate;
            this.rates[i][indexOther] = convertedRate = updatedRate * this.rates[i][indexRef];
            this.rates[indexOther][i] = 1.0 / convertedRate;
        }
    }

    private void updateRate(Currency ccy1, Currency ccy2, double rate) {
        int index1 = this.currencies.get(ccy1);
        int index2 = this.currencies.get(ccy2);
        for (int i = 0; i < this.currencies.size(); ++i) {
            double convertedRate;
            if (i == index2) continue;
            this.rates[i][index2] = convertedRate = rate * this.rates[i][index1];
            this.rates[index2][i] = 1.0 / convertedRate;
        }
    }

    private void addInitialCurrencyPair(Currency ccy1, Currency ccy2, double rate) {
        this.currencies.put(ccy1, 0);
        this.currencies.put(ccy2, 1);
        this.rates[0][0] = 1.0;
        this.rates[0][1] = rate;
        this.rates[1][1] = 1.0;
        this.rates[1][0] = 1.0 / rate;
    }

    private void ensureCapacity(Stream<Currency> potentialCurrencies) {
        int requiredOrder = (int)Stream.concat(this.currencies.keySet().stream(), potentialCurrencies).distinct().count();
        this.ensureCapacity(requiredOrder);
    }

    private void ensureCapacity(int requiredOrder) {
        if (requiredOrder > this.rates.length) {
            this.rates = FxMatrixBuilder.copyArray(this.rates, this.size(requiredOrder));
        }
    }

    private int size(int requiredCapacity) {
        int lowerPower = Integer.highestOneBit(requiredCapacity);
        return Math.max(requiredCapacity == lowerPower ? requiredCapacity : lowerPower << 2, 8);
    }

    private static double[][] copyArray(double[][] rates, int requestedSize) {
        int order = Math.min(rates.length, requestedSize);
        double[][] copy = new double[requestedSize][requestedSize];
        for (int i = 0; i < order; ++i) {
            System.arraycopy(rates[i], 0, copy[i], 0, order);
        }
        return copy;
    }
}

