/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.Money;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.JodaBeanUtils;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class CurrencyAmount
implements FxConvertible<CurrencyAmount>,
Comparable<CurrencyAmount>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Currency currency;
    private final double amount;

    public static CurrencyAmount zero(Currency currency) {
        return CurrencyAmount.of(currency, 0.0);
    }

    public static CurrencyAmount of(Currency currency, double amount) {
        return new CurrencyAmount(currency, amount);
    }

    public static CurrencyAmount of(String currencyCode, double amount) {
        return CurrencyAmount.of(Currency.of(currencyCode), amount);
    }

    @FromString
    public static CurrencyAmount parse(String amountStr) {
        ArgChecker.notNull((Object)amountStr, (String)"amountStr");
        List split = Splitter.on((char)' ').splitToList((CharSequence)amountStr);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Unable to parse amount, invalid format: " + amountStr);
        }
        try {
            Currency cur = Currency.parse((String)split.get(0));
            double amount = Double.parseDouble((String)split.get(1));
            return new CurrencyAmount(cur, amount);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to parse amount: " + amountStr, ex);
        }
    }

    private CurrencyAmount(Currency currency, double amount) {
        this.currency = (Currency)ArgChecker.notNull((Object)currency, (String)"currency");
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getAmount() {
        return this.amount;
    }

    public CurrencyAmount plus(CurrencyAmount amountToAdd) {
        ArgChecker.notNull((Object)amountToAdd, (String)"amountToAdd");
        ArgChecker.isTrue((boolean)amountToAdd.getCurrency().equals(this.currency), (String)"Unable to add amounts in different currencies");
        return this.plus(amountToAdd.getAmount());
    }

    public CurrencyAmount plus(double amountToAdd) {
        return new CurrencyAmount(this.currency, this.amount + amountToAdd);
    }

    public CurrencyAmount minus(CurrencyAmount amountToSubtract) {
        ArgChecker.notNull((Object)amountToSubtract, (String)"amountToSubtract");
        ArgChecker.isTrue((boolean)amountToSubtract.getCurrency().equals(this.currency), (String)"Unable to subtract amounts in different currencies");
        return this.minus(amountToSubtract.getAmount());
    }

    public CurrencyAmount minus(double amountToSubtract) {
        return new CurrencyAmount(this.currency, this.amount - amountToSubtract);
    }

    public CurrencyAmount multipliedBy(double valueToMultiplyBy) {
        return new CurrencyAmount(this.currency, this.amount * valueToMultiplyBy);
    }

    public CurrencyAmount mapAmount(DoubleUnaryOperator mapper) {
        ArgChecker.notNull((Object)mapper, (String)"mapper");
        return new CurrencyAmount(this.currency, mapper.applyAsDouble(this.amount));
    }

    public CurrencyAmount negated() {
        return new CurrencyAmount(this.currency, this.amount == 0.0 ? 0.0 : -this.amount);
    }

    public CurrencyAmount positive() {
        return this.amount < 0.0 ? this.negated() : this;
    }

    public CurrencyAmount negative() {
        return this.amount > 0.0 ? this.negated() : this;
    }

    public Money toMoney() {
        return Money.of(this.getCurrency(), this.getAmount());
    }

    public CurrencyAmount convertedTo(Currency resultCurrency, double fxRate) {
        if (this.currency.equals(resultCurrency)) {
            if (DoubleMath.fuzzyEquals((double)fxRate, (double)1.0, (double)1.0E-8)) {
                return this;
            }
            throw new IllegalArgumentException("FX rate must be 1 when no conversion required");
        }
        return CurrencyAmount.of(resultCurrency, this.amount * fxRate);
    }

    @Override
    public CurrencyAmount convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.currency.equals(resultCurrency)) {
            return this;
        }
        double converted = rateProvider.convert(this.amount, this.currency, resultCurrency);
        return CurrencyAmount.of(resultCurrency, converted);
    }

    @Override
    public int compareTo(CurrencyAmount other) {
        return ComparisonChain.start().compare((Comparable)this.currency, (Comparable)other.currency).compare(this.amount, other.amount).result();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurrencyAmount other = (CurrencyAmount)obj;
            return this.currency.equals(other.currency) && JodaBeanUtils.equal((double)this.amount, (double)other.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.currency.hashCode() * 31 + JodaBeanUtils.hashCode((double)this.amount);
    }

    @ToString
    public String toString() {
        return this.currency + " " + (DoubleMath.isMathematicalInteger((double)this.amount) ? Long.toString((long)this.amount) : Double.toString(this.amount));
    }
}

