/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.async.chat.completions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ClientOptions;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.http.HttpClient;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpResponse;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.ChatCompletionMessageListPageAsync;
import com.openai.models.ChatCompletionMessageListParams;
import com.openai.services.async.chat.completions.MessageServiceAsync;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/openai/services/async/chat/completions/MessageServiceAsyncImpl;", "Lcom/openai/services/async/chat/completions/MessageServiceAsync;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "listHandler", "Lcom/openai/models/ChatCompletionMessageListPageAsync$Response;", "list", "Ljava/util/concurrent/CompletableFuture;", "Lcom/openai/models/ChatCompletionMessageListPageAsync;", "params", "Lcom/openai/models/ChatCompletionMessageListParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nMessageServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageServiceAsyncImpl.kt\ncom/openai/services/async/chat/completions/MessageServiceAsyncImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n13#2,9:57\n1#3:66\n*S KotlinDebug\n*F\n+ 1 MessageServiceAsyncImpl.kt\ncom/openai/services/async/chat/completions/MessageServiceAsyncImpl\n*L\n25#1:57,9\n*E\n"})
public final class MessageServiceAsyncImpl
implements MessageServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<ChatCompletionMessageListPageAsync.Response> listHandler;

    public MessageServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ChatCompletionMessageListPageAsync.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ChatCompletionMessageListPageAsync.Response handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ChatCompletionMessageListPageAsync.Response>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    @Override
    @NotNull
    public CompletableFuture<ChatCompletionMessageListPageAsync> list(@NotNull ChatCompletionMessageListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"chat", "completions", params.getPathParam(0), "messages"};
        CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> MessageServiceAsyncImpl.list$lambda$1(arg_0 -> MessageServiceAsyncImpl.list$lambda$0(this, requestOptions, arg_0), arg_0))).thenApply(arg_0 -> MessageServiceAsyncImpl.list$lambda$6(arg_0 -> MessageServiceAsyncImpl.list$lambda$5(this, requestOptions, params, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final CompletionStage list$lambda$0(MessageServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage list$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ChatCompletionMessageListPageAsync list$lambda$5(MessageServiceAsyncImpl this$0, RequestOptions $requestOptions, ChatCompletionMessageListParams $params, HttpResponse response) {
        Object it;
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            HttpResponse.Handler<ChatCompletionMessageListPageAsync.Response> handler = this$0.listHandler;
            Intrinsics.checkNotNull((Object)it);
            it = handler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = $requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this$0.clientOptions.responseValidation()) {
            ((ChatCompletionMessageListPageAsync.Response)it2).validate();
        }
        it2 = object;
        boolean bl3 = false;
        return ChatCompletionMessageListPageAsync.Companion.of(this$0, $params, (ChatCompletionMessageListPageAsync.Response)it2);
    }

    private static final ChatCompletionMessageListPageAsync list$lambda$6(Function1 $tmp0, Object p0) {
        return (ChatCompletionMessageListPageAsync)$tmp0.invoke(p0);
    }
}

