/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.client;

import com.onlyoffice.client.DocumentServerClient;
import com.onlyoffice.client.DocumentServerClientSettings;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.properties.docsintegrationsdk.DocumentServerProperties;
import com.onlyoffice.model.properties.docsintegrationsdk.HttpClientProperties;
import com.onlyoffice.model.settings.Settings;
import com.onlyoffice.model.settings.security.Security;
import com.onlyoffice.utils.ConfigurationUtils;
import java.util.Optional;

public abstract class AbstractDocumentServerClient
implements DocumentServerClient {
    protected SettingsManager settingsManager;
    protected UrlManager urlManager;
    protected DocumentServerClientSettings documentServerClientSettings = new DocumentServerClientSettings();

    protected AbstractDocumentServerClient(DocumentServerClientSettings documentServerClientSettings) {
        this.documentServerClientSettings = documentServerClientSettings;
    }

    protected AbstractDocumentServerClient(SettingsManager settingsManager, UrlManager urlManager) {
        this.settingsManager = settingsManager;
        this.urlManager = urlManager;
    }

    @Override
    public void applySettings(Settings settings) {
        if (Optional.ofNullable(settings.getDemo()).orElse(false).booleanValue()) {
            DocumentServerProperties demoDocumentServerProperties = ConfigurationUtils.getDemoDocumentServerProperties();
            DocumentServerClientSettings documentServerClientSettings = DocumentServerClientSettings.builder().baseUrl(demoDocumentServerProperties.getUrl()).ignoreSSLCertificate(false).security(Security.builder().key(demoDocumentServerProperties.getSecurity().getKey()).header(demoDocumentServerProperties.getSecurity().getHeader()).prefix(demoDocumentServerProperties.getSecurity().getPrefix()).build()).build();
            this.applySettings(documentServerClientSettings);
            return;
        }
        String baseUrl = settings.getUrl();
        if (settings.getInnerUrl() != null && !settings.getInnerUrl().isEmpty()) {
            baseUrl = settings.getInnerUrl();
        }
        Boolean ignoreSSLCertificate = null;
        if (settings.getIgnoreSSLCertificate() != null && !settings.getIgnoreSSLCertificate().isEmpty()) {
            ignoreSSLCertificate = Boolean.parseBoolean(settings.getIgnoreSSLCertificate());
        }
        DocumentServerClientSettings documentServerClientSettings = DocumentServerClientSettings.builder().baseUrl(baseUrl).security(settings.getSecurity()).ignoreSSLCertificate(ignoreSSLCertificate).build();
        this.applySettings(documentServerClientSettings);
    }

    @Override
    public void applySettings(DocumentServerClientSettings documentServerClientSettings) {
        this.documentServerClientSettings = documentServerClientSettings;
    }

    protected String getBaseUrl() {
        if (this.documentServerClientSettings.getBaseUrl() != null && !this.documentServerClientSettings.getBaseUrl().isEmpty()) {
            return this.documentServerClientSettings.getBaseUrl();
        }
        return this.urlManager.getInnerDocumentServerUrl();
    }

    protected String getSecurityKey() {
        Security security = this.documentServerClientSettings.getSecurity();
        if (security != null && security.getKey() != null && !security.getKey().isEmpty()) {
            return security.getKey();
        }
        return this.settingsManager.getSecurityKey();
    }

    protected String getSecurityHeader() {
        Security security = this.documentServerClientSettings.getSecurity();
        if (security != null && security.getHeader() != null && !security.getHeader().isEmpty()) {
            return security.getHeader();
        }
        return this.settingsManager.getSecurityHeader();
    }

    protected String getSecurityPrefix() {
        Security security = this.documentServerClientSettings.getSecurity();
        if (security != null && security.getPrefix() != null && !security.getPrefix().isEmpty()) {
            return security.getPrefix();
        }
        return this.settingsManager.getSecurityPrefix();
    }

    protected boolean isSecurityEnabled() {
        Security security = this.documentServerClientSettings.getSecurity();
        if (security != null && security.getKey() != null && !security.getKey().isEmpty()) {
            return true;
        }
        return this.settingsManager.isSecurityEnabled();
    }

    protected HttpClientProperties getHttpClientProperties() {
        HttpClientProperties httpClientProperties = new HttpClientProperties(ConfigurationUtils.getDocsIntegrationSdkProperties().getHttpClient());
        Boolean ignoreSSLCertificate = this.documentServerClientSettings.getIgnoreSSLCertificate();
        if (ignoreSSLCertificate != null) {
            httpClientProperties.setIgnoreSslCertificate(ignoreSSLCertificate);
            return httpClientProperties;
        }
        ignoreSSLCertificate = this.settingsManager.isIgnoreSSLCertificate();
        httpClientProperties.setIgnoreSslCertificate(ignoreSSLCertificate);
        return httpClientProperties;
    }
}

