/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.client.AbstractDocumentServerClient;
import com.onlyoffice.client.DocumentServerClientSettings;
import com.onlyoffice.exception.DocumentServerResponseException;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.commandservice.CommandRequest;
import com.onlyoffice.model.commandservice.CommandResponse;
import com.onlyoffice.model.common.RequestEntity;
import com.onlyoffice.model.convertservice.ConvertRequest;
import com.onlyoffice.model.convertservice.ConvertResponse;
import com.onlyoffice.model.docbuilderservice.DocBuilderRequest;
import com.onlyoffice.model.docbuilderservice.DocBuilderResponse;
import com.onlyoffice.model.properties.docsintegrationsdk.HttpClientProperties;
import com.onlyoffice.utils.ConfigurationUtils;
import com.onlyoffice.utils.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;

public class ApacheHttpclientDocumentServerClient
extends AbstractDocumentServerClient {
    private CloseableHttpClient httpClient;
    private CloseableHttpClient httpClientForSyncConvertRequest;
    private String baseUrl;
    private boolean isIgnoreSSLCertificate;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ApacheHttpclientDocumentServerClient(DocumentServerClientSettings documentServerClientSettings) {
        super(documentServerClientSettings);
        this.init();
    }

    public ApacheHttpclientDocumentServerClient(SettingsManager settingsManager, UrlManager urlManager) {
        super(settingsManager, urlManager);
        this.init();
    }

    @Override
    public Boolean healthcheck() {
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)this.getBaseUrl()).setHeader("Upgrade", "").setPath(ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getHealthCheckUrl()).build();
        return this.executeRequest(request, Boolean.class);
    }

    @Override
    public byte[] getFile(String fileUrl) {
        URI uri;
        try {
            uri = new URI(fileUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)this.getBaseUrl()).setPath(uri.getRawPath() + (uri.getRawQuery() != null ? "?" + uri.getRawQuery() : "")).build();
        return this.executeRequest(request, byte[].class);
    }

    @Override
    public int getFile(String fileUrl, OutputStream outputStream) {
        URI uri;
        try {
            uri = new URI(fileUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)this.getBaseUrl()).setPath(uri.getRawPath() + (uri.getRawQuery() != null ? "?" + uri.getRawQuery() : "")).build();
        return this.executeRequest(request, outputStream);
    }

    @Override
    public ConvertResponse convert(ConvertRequest convertRequest) {
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)this.getBaseUrl()).setPath(ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getConvertService().getUrl()).addParameter("shardkey", convertRequest.getKey()).setEntity(this.createEntity(convertRequest)).build();
        this.authorizeRequest(request, convertRequest);
        if (convertRequest.getAsync() != null && convertRequest.getAsync().booleanValue()) {
            return this.executeRequest(request, ConvertResponse.class);
        }
        return this.executeRequestWithHttpClientForSyncConvertRequest(request, ConvertResponse.class);
    }

    @Override
    public CommandResponse command(CommandRequest commandRequest) {
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)this.getBaseUrl()).setPath(ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getCommandService().getUrl()).addParameter("shardkey", commandRequest.getKey()).setEntity(this.createEntity(commandRequest)).build();
        this.authorizeRequest(request, commandRequest);
        return this.executeRequest(request, CommandResponse.class);
    }

    @Override
    public DocBuilderResponse docbuilder(DocBuilderRequest docBuilderRequest) {
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)this.getBaseUrl()).setPath(ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getDocbuilderService().getUrl()).addParameter("shardkey", docBuilderRequest.getKey()).setEntity(this.createEntity(docBuilderRequest)).build();
        this.authorizeRequest(request, docBuilderRequest);
        return this.executeRequest(request, DocBuilderResponse.class);
    }

    protected <T> T executeRequestWithHttpClientForSyncConvertRequest(ClassicHttpRequest classicHttpRequest, Class<T> valueType) {
        this.prepareHttpClient();
        return (T)this.executeRequest((HttpClient)this.httpClientForSyncConvertRequest, classicHttpRequest, inputStream -> {
            if (valueType.equals(byte[].class)) {
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            return this.objectMapper.readValue(inputStream, valueType);
        });
    }

    protected <T> T executeRequest(ClassicHttpRequest classicHttpRequest, Class<T> valueType) {
        this.prepareHttpClient();
        return (T)this.executeRequest((HttpClient)this.httpClient, classicHttpRequest, inputStream -> {
            if (valueType.equals(byte[].class)) {
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            return this.objectMapper.readValue(inputStream, valueType);
        });
    }

    protected int executeRequest(ClassicHttpRequest classicHttpRequest, OutputStream outputStream) {
        this.prepareHttpClient();
        return this.executeRequest((HttpClient)this.httpClient, classicHttpRequest, inputStream -> {
            try {
                Integer n = IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                return n;
            }
            finally {
                outputStream.close();
            }
        });
    }

    protected <R> R executeRequest(HttpClient httpClient, ClassicHttpRequest classicHttpRequest, Callback<R> callback) {
        try {
            return (R)httpClient.execute(classicHttpRequest, response -> {
                if (response.getCode() >= 300) {
                    throw new ClientProtocolException(new StatusLine((HttpResponse)response).toString());
                }
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity == null) {
                    return null;
                }
                try {
                    try (InputStream inputStream = responseEntity.getContent();){
                        Object Result = callback.doWork(inputStream);
                        return Result;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)responseEntity);
                }
            });
        }
        catch (IOException e) {
            throw new DocumentServerResponseException(e, classicHttpRequest.toString());
        }
    }

    protected void authorizeRequest(ClassicHttpRequest request, RequestEntity requestEntity) {
        if (this.isSecurityEnabled()) {
            request.setHeader(this.getSecurityHeader(), (Object)SecurityUtils.createAuthorizationHeader(requestEntity, this.getSecurityKey(), this.getSecurityPrefix()));
        }
    }

    protected HttpEntity createEntity(RequestEntity requestEntity) {
        return HttpEntities.create(outputStream -> {
            if (requestEntity.getToken() == null && this.isSecurityEnabled()) {
                requestEntity.setToken(SecurityUtils.createToken(requestEntity, this.getSecurityKey()));
            }
            this.objectMapper.writeValue(outputStream, (Object)requestEntity);
            outputStream.flush();
        }, (ContentType)ContentType.APPLICATION_JSON);
    }

    protected void prepareHttpClient() {
        if (this.shouldReinit()) {
            this.init();
        }
    }

    protected boolean shouldReinit() {
        HttpClientProperties httpClientProperties = this.getHttpClientProperties();
        return this.isIgnoreSSLCertificate != httpClientProperties.getIgnoreSslCertificate() || !Optional.ofNullable(this.baseUrl).orElse("").equals(this.getBaseUrl());
    }

    protected void init() {
        HttpClientProperties httpClientProperties = this.getHttpClientProperties();
        this.isIgnoreSSLCertificate = httpClientProperties.getIgnoreSslCertificate();
        this.baseUrl = this.getBaseUrl();
        this.httpClient = this.createHttpClient(httpClientProperties);
        HttpClientProperties httpClientPropertiesForSyncConvertRequest = new HttpClientProperties(httpClientProperties);
        httpClientPropertiesForSyncConvertRequest.setSocketTimeout(this.getSyncSocketTimeoutForConvertService());
        this.httpClientForSyncConvertRequest = this.createHttpClient(httpClientPropertiesForSyncConvertRequest);
    }

    protected CloseableHttpClient createHttpClient(HttpClientProperties httpClientProperties) {
        int connectionTimeout = (int)TimeUnit.SECONDS.toMillis(httpClientProperties.getConnectionTimeout());
        int connectionRequestTimeout = (int)TimeUnit.SECONDS.toMillis(httpClientProperties.getConnectionRequestTimeout());
        int socketTimeout = (int)TimeUnit.SECONDS.toMillis(httpClientProperties.getSocketTimeout());
        PoolingHttpClientConnectionManagerBuilder poolingHttpClientConnectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).setSocketTimeout(socketTimeout, TimeUnit.MILLISECONDS).build());
        if (Optional.ofNullable(httpClientProperties.getIgnoreSslCertificate()).orElse(false).booleanValue()) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslContext, (hostname, sslSession) -> true);
            poolingHttpClientConnectionManagerBuilder.setTlsSocketStrategy((TlsSocketStrategy)tlsStrategy);
        }
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((long)connectionRequestTimeout, TimeUnit.MILLISECONDS).build()).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManagerBuilder.build()).build();
    }

    protected Long getSyncSocketTimeoutForConvertService() {
        return ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getConvertService().getSyncSocketTimeout();
    }

    @Generated
    protected CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    protected void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Generated
    protected CloseableHttpClient getHttpClientForSyncConvertRequest() {
        return this.httpClientForSyncConvertRequest;
    }

    @Generated
    protected void setHttpClientForSyncConvertRequest(CloseableHttpClient httpClientForSyncConvertRequest) {
        this.httpClientForSyncConvertRequest = httpClientForSyncConvertRequest;
    }

    protected static interface Callback<Result> {
        public Result doWork(InputStream var1) throws IOException;
    }
}

