/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.common;

import com.ongres.scram.common.Gs2AttributeValue;
import com.ongres.scram.common.Gs2Attributes;
import com.ongres.scram.common.Gs2CbindFlag;
import com.ongres.scram.common.ScramStringFormatting;
import com.ongres.scram.common.StringWritable;
import com.ongres.scram.common.StringWritableCsv;
import com.ongres.scram.common.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Gs2Header
extends StringWritable {
    @NotNull
    private final Gs2AttributeValue gs2CbindFlag;
    @Nullable
    private final Gs2AttributeValue authzid;

    public Gs2Header(@NotNull Gs2CbindFlag cbindFlag, @Nullable String cbName, @Nullable String authzid) {
        Gs2Header.checkChannelBinding(cbindFlag, cbName);
        this.gs2CbindFlag = new Gs2AttributeValue(Gs2Attributes.byGs2CbindFlag(cbindFlag), cbName);
        this.authzid = authzid == null ? null : new Gs2AttributeValue(Gs2Attributes.AUTHZID, ScramStringFormatting.toSaslName(authzid));
    }

    public Gs2Header(@NotNull Gs2CbindFlag cbindFlag, @Nullable String cbName) {
        this(cbindFlag, cbName, null);
    }

    public Gs2Header(@NotNull Gs2CbindFlag cbindFlag) {
        this(cbindFlag, null, null);
    }

    @NotNull
    public Gs2CbindFlag getChannelBindingFlag() {
        return Gs2CbindFlag.byChar(this.gs2CbindFlag.getChar());
    }

    @Nullable
    public String getChannelBindingName() {
        return this.gs2CbindFlag.getValue();
    }

    @Nullable
    public String getAuthzid() {
        return this.authzid != null ? Preconditions.castNonNull(this.authzid).getValue() : null;
    }

    @Override
    StringBuilder writeTo(StringBuilder sb) {
        return StringWritableCsv.writeTo(sb, this.gs2CbindFlag, this.authzid);
    }

    @NotNull
    public static Gs2Header parseFrom(@NotNull String message) {
        Preconditions.checkNotNull(message, "Null message");
        @NotNull String[] gs2HeaderSplit = StringWritableCsv.parseFrom(message, 2);
        if (gs2HeaderSplit.length == 0) {
            throw new IllegalArgumentException("Invalid number of fields for the GS2 Header");
        }
        Gs2AttributeValue gs2cbind = Gs2AttributeValue.parse(Preconditions.castNonNull(gs2HeaderSplit[0]));
        String authzId = Preconditions.isNullOrEmpty(gs2HeaderSplit[1]) ? null : Preconditions.castNonNull(Gs2AttributeValue.parse(gs2HeaderSplit[1])).getValue();
        return new Gs2Header(Gs2CbindFlag.byChar(gs2cbind.getChar()), gs2cbind.getValue(), authzId);
    }

    private static void checkChannelBinding(@NotNull Gs2CbindFlag cbindFlag, @Nullable String cbName) {
        Preconditions.checkNotNull(cbindFlag, "cbindFlag");
        if (cbindFlag == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED ^ cbName != null) {
            throw new IllegalArgumentException("Specify required channel binding flag and type together, or none");
        }
        if (cbindFlag == Gs2CbindFlag.CHANNEL_BINDING_REQUIRED) {
            Gs2Header.validateChannelBindingType(Preconditions.castNonNull(cbName));
        }
    }

    private static void validateChannelBindingType(@NotNull String cbname) {
        Preconditions.checkNotEmpty(cbname, "cbname");
        switch (cbname) {
            case "tls-server-end-point": 
            case "tls-unique": 
            case "tls-exporter": {
                break;
            }
            default: {
                for (int i = 0; i < cbname.length(); ++i) {
                    char ch = cbname.charAt(i);
                    if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch >= '-' && ch <= '.') continue;
                    throw new IllegalArgumentException("Invalid Channel Binding Type name '" + cbname + "'");
                }
            }
        }
    }
}

