/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.client;

import com.ongres.scram.client.ClientFinalProcessor;
import com.ongres.scram.common.ClientFirstMessage;
import com.ongres.scram.common.ScramMechanism;
import com.ongres.scram.common.ServerFirstMessage;
import com.ongres.scram.common.StringPreparation;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;

final class ServerFirstProcessor {
    private final ScramMechanism scramMechanism;
    private final StringPreparation stringPreparation;
    private final ClientFirstMessage clientFirstMessage;
    private final ServerFirstMessage serverFirstMessage;

    ServerFirstProcessor(ScramMechanism scramMechanism, StringPreparation stringPreparation, @NotNull String receivedServerFirstMessage, @NotNull String nonce, @NotNull ClientFirstMessage clientFirstMessage) throws ScramParseException {
        this.scramMechanism = scramMechanism;
        this.stringPreparation = stringPreparation;
        this.serverFirstMessage = ServerFirstMessage.parseFrom((String)receivedServerFirstMessage, (String)nonce);
        this.clientFirstMessage = clientFirstMessage;
    }

    @NotNull
    ServerFirstMessage getServerFirstMessage() {
        return this.serverFirstMessage;
    }

    ClientFinalProcessor clientFinalProcessor(char[] password) {
        return new ClientFinalProcessor(this.scramMechanism, this.stringPreparation, Preconditions.checkNotEmpty((char[])password, (String)"password"), Base64.getDecoder().decode(this.serverFirstMessage.getSalt().getBytes(StandardCharsets.UTF_8)), this.clientFirstMessage, this.serverFirstMessage);
    }

    ClientFinalProcessor clientFinalProcessor(byte[] clientKey, byte[] serverKey) {
        return new ClientFinalProcessor(this.scramMechanism, (byte[])Preconditions.checkNotNull((Object)clientKey, (String)"clientKey"), (byte[])Preconditions.checkNotNull((Object)serverKey, (String)"serverKey"), this.clientFirstMessage, this.serverFirstMessage);
    }

    ClientFinalProcessor clientFinalProcessor(byte[] saltedPassword) {
        return new ClientFinalProcessor(this.scramMechanism, (byte[])Preconditions.checkNotNull((Object)saltedPassword, (String)"saltedPassword"), this.clientFirstMessage, this.serverFirstMessage);
    }
}

