/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal.subscriptions.impl;

import android.os.Build;
import com.onesignal.common.AndroidUtils;
import com.onesignal.common.DeviceUtils;
import com.onesignal.common.IDManager;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.modeling.IModelStore;
import com.onesignal.common.modeling.IModelStoreChangeHandler;
import com.onesignal.common.modeling.Model;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.session.internal.session.ISessionLifecycleHandler;
import com.onesignal.session.internal.session.ISessionService;
import com.onesignal.user.internal.EmailSubscription;
import com.onesignal.user.internal.PushSubscription;
import com.onesignal.user.internal.SmsSubscription;
import com.onesignal.user.internal.Subscription;
import com.onesignal.user.internal.UninitializedPushSubscription;
import com.onesignal.user.internal.subscriptions.ISubscriptionChangedHandler;
import com.onesignal.user.internal.subscriptions.ISubscriptionManager;
import com.onesignal.user.internal.subscriptions.SubscriptionList;
import com.onesignal.user.internal.subscriptions.SubscriptionModel;
import com.onesignal.user.internal.subscriptions.SubscriptionModelStore;
import com.onesignal.user.internal.subscriptions.SubscriptionStatus;
import com.onesignal.user.internal.subscriptions.SubscriptionType;
import com.onesignal.user.subscriptions.IEmailSubscription;
import com.onesignal.user.subscriptions.IPushSubscription;
import com.onesignal.user.subscriptions.IPushSubscriptionObserver;
import com.onesignal.user.subscriptions.ISmsSubscription;
import com.onesignal.user.subscriptions.ISubscription;
import com.onesignal.user.subscriptions.PushSubscriptionChangedState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001fH\u0016J$\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001f2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0018\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u001fH\u0016J\u0018\u00102\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u001fH\u0016J\u0018\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u00020\u001fH\u0016J\b\u00106\u001a\u00020\u001dH\u0016J\u0010\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u001dH\u0016J\b\u0010;\u001a\u00020\u001dH\u0002J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010=\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020.H\u0002J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020.H\u0002J\u0010\u0010A\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020\u000eH\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006D"}, d2={"Lcom/onesignal/user/internal/subscriptions/impl/SubscriptionManager;", "Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;", "Lcom/onesignal/common/modeling/IModelStoreChangeHandler;", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;", "Lcom/onesignal/session/internal/session/ISessionLifecycleHandler;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_sessionService", "Lcom/onesignal/session/internal/session/ISessionService;", "_subscriptionModelStore", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/session/internal/session/ISessionService;Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;)V", "events", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/user/internal/subscriptions/ISubscriptionChangedHandler;", "hasSubscribers", "", "getHasSubscribers", "()Z", "pushSubscriptionModel", "getPushSubscriptionModel", "()Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;", "subscriptions", "Lcom/onesignal/user/internal/subscriptions/SubscriptionList;", "getSubscriptions", "()Lcom/onesignal/user/internal/subscriptions/SubscriptionList;", "setSubscriptions", "(Lcom/onesignal/user/internal/subscriptions/SubscriptionList;)V", "addEmailSubscription", "", "email", "", "addOrUpdatePushSubscriptionToken", "pushToken", "pushTokenStatus", "Lcom/onesignal/user/internal/subscriptions/SubscriptionStatus;", "addSmsSubscription", "sms", "addSubscriptionToModels", "type", "Lcom/onesignal/user/internal/subscriptions/SubscriptionType;", "address", "status", "createSubscriptionAndAddToSubscriptionList", "subscriptionModel", "createSubscriptionFromModel", "Lcom/onesignal/user/subscriptions/ISubscription;", "onModelAdded", "model", "tag", "onModelRemoved", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "onSessionActive", "onSessionEnded", "duration", "", "onSessionStarted", "refreshPushSubscriptionState", "removeEmailSubscription", "removeSmsSubscription", "removeSubscriptionFromModels", "subscription", "removeSubscriptionFromSubscriptionList", "subscribe", "handler", "unsubscribe", "com.onesignal.core"})
public final class SubscriptionManager
implements ISubscriptionManager,
IModelStoreChangeHandler<SubscriptionModel>,
ISessionLifecycleHandler {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ISessionService _sessionService;
    @NotNull
    private final SubscriptionModelStore _subscriptionModelStore;
    @NotNull
    private final EventProducer<ISubscriptionChangedHandler> events;
    @NotNull
    private SubscriptionList subscriptions;

    public SubscriptionManager(@NotNull IApplicationService _applicationService, @NotNull ISessionService _sessionService, @NotNull SubscriptionModelStore _subscriptionModelStore) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_sessionService, (String)"_sessionService");
        Intrinsics.checkNotNullParameter((Object)_subscriptionModelStore, (String)"_subscriptionModelStore");
        this._applicationService = _applicationService;
        this._sessionService = _sessionService;
        this._subscriptionModelStore = _subscriptionModelStore;
        this.events = new EventProducer();
        this.subscriptions = new SubscriptionList(CollectionsKt.emptyList(), new UninitializedPushSubscription());
        for (SubscriptionModel subscriptionModel : this._subscriptionModelStore.list()) {
            this.createSubscriptionAndAddToSubscriptionList(subscriptionModel);
        }
        this._subscriptionModelStore.subscribe(this);
        this._sessionService.subscribe(this);
    }

    @Override
    @NotNull
    public SubscriptionList getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public void setSubscriptions(@NotNull SubscriptionList subscriptionList) {
        Intrinsics.checkNotNullParameter((Object)subscriptionList, (String)"<set-?>");
        this.subscriptions = subscriptionList;
    }

    @Override
    @NotNull
    public SubscriptionModel getPushSubscriptionModel() {
        IPushSubscription iPushSubscription = this.getSubscriptions().getPush();
        Intrinsics.checkNotNull((Object)iPushSubscription, (String)"null cannot be cast to non-null type com.onesignal.user.internal.PushSubscription");
        return ((PushSubscription)iPushSubscription).getModel();
    }

    @Override
    public void onSessionStarted() {
        this.refreshPushSubscriptionState();
    }

    @Override
    public void onSessionActive() {
    }

    @Override
    public void onSessionEnded(long duration) {
    }

    @Override
    public void addEmailSubscription(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        SubscriptionManager.addSubscriptionToModels$default(this, SubscriptionType.EMAIL, email, null, 4, null);
    }

    @Override
    public void addSmsSubscription(@NotNull String sms) {
        Intrinsics.checkNotNullParameter((Object)sms, (String)"sms");
        SubscriptionManager.addSubscriptionToModels$default(this, SubscriptionType.SMS, sms, null, 4, null);
    }

    @Override
    public void addOrUpdatePushSubscriptionToken(@Nullable String pushToken, @NotNull SubscriptionStatus pushTokenStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)pushTokenStatus), (String)"pushTokenStatus");
        IPushSubscription pushSub = this.getSubscriptions().getPush();
        if (pushSub instanceof UninitializedPushSubscription) {
            String string2 = pushToken;
            if (string2 == null) {
                string2 = "";
            }
            this.addSubscriptionToModels(SubscriptionType.PUSH, string2, pushTokenStatus);
        } else {
            Intrinsics.checkNotNull((Object)pushSub, (String)"null cannot be cast to non-null type com.onesignal.user.internal.Subscription");
            SubscriptionModel pushSubModel = ((Subscription)((Object)pushSub)).getModel();
            if (pushToken != null) {
                pushSubModel.setAddress(pushToken);
            }
            pushSubModel.setStatus(pushTokenStatus);
        }
    }

    @Override
    public void removeEmailSubscription(@NotNull String email) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Iterable $this$firstOrNull$iv = this.getSubscriptions().getEmails();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IEmailSubscription it = (IEmailSubscription)element$iv;
                boolean bl = false;
                if (!(it instanceof EmailSubscription && Intrinsics.areEqual((Object)it.getEmail(), (Object)email))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        IEmailSubscription subscriptionToRem = v0;
        if (subscriptionToRem != null) {
            this.removeSubscriptionFromModels(subscriptionToRem);
        }
    }

    @Override
    public void removeSmsSubscription(@NotNull String sms) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sms, (String)"sms");
            Iterable $this$firstOrNull$iv = this.getSubscriptions().getSmss();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ISmsSubscription it = (ISmsSubscription)element$iv;
                boolean bl = false;
                if (!(it instanceof SmsSubscription && Intrinsics.areEqual((Object)it.getNumber(), (Object)sms))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ISmsSubscription subscriptionToRem = v0;
        if (subscriptionToRem != null) {
            this.removeSubscriptionFromModels(subscriptionToRem);
        }
    }

    private final void addSubscriptionToModels(SubscriptionType type, String address, SubscriptionStatus status) {
        Logging.log(LogLevel.DEBUG, "SubscriptionManager.addSubscription(type: " + (Object)((Object)type) + ", address: " + address + ')');
        SubscriptionModel subscriptionModel = new SubscriptionModel();
        subscriptionModel.setId(IDManager.INSTANCE.createLocalId());
        subscriptionModel.setOptedIn(true);
        subscriptionModel.setType(type);
        subscriptionModel.setAddress(address);
        SubscriptionStatus subscriptionStatus = status;
        if (subscriptionStatus == null) {
            subscriptionStatus = SubscriptionStatus.SUBSCRIBED;
        }
        subscriptionModel.setStatus(subscriptionStatus);
        IModelStore.DefaultImpls.add$default(this._subscriptionModelStore, subscriptionModel, null, 2, null);
    }

    static /* synthetic */ void addSubscriptionToModels$default(SubscriptionManager subscriptionManager, SubscriptionType subscriptionType, String string2, SubscriptionStatus subscriptionStatus, int n, Object object) {
        if ((n & 4) != 0) {
            subscriptionStatus = null;
        }
        subscriptionManager.addSubscriptionToModels(subscriptionType, string2, subscriptionStatus);
    }

    private final void removeSubscriptionFromModels(ISubscription subscription) {
        Logging.log(LogLevel.DEBUG, "SubscriptionManager.removeSubscription(subscription: " + subscription + ')');
        IModelStore.DefaultImpls.remove$default(this._subscriptionModelStore, subscription.getId(), null, 2, null);
    }

    @Override
    public void subscribe(@NotNull ISubscriptionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.events.subscribe(handler);
    }

    @Override
    public void unsubscribe(@NotNull ISubscriptionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.events.unsubscribe(handler);
    }

    @Override
    public boolean getHasSubscribers() {
        return this.events.getHasSubscribers();
    }

    @Override
    public void onModelAdded(@NotNull SubscriptionModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.createSubscriptionAndAddToSubscriptionList(model);
    }

    @Override
    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Iterable $this$firstOrNull$iv = this.getSubscriptions().getCollection();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ISubscription it = (ISubscription)element$iv;
                boolean bl = false;
                Model model = args.getModel();
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.onesignal.user.internal.Subscription");
                if (!Intrinsics.areEqual((Object)model, (Object)((Subscription)it).getModel())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ISubscription subscription = v1;
        if (subscription == null) {
            Model model = args.getModel();
            Intrinsics.checkNotNull((Object)model, (String)"null cannot be cast to non-null type com.onesignal.user.internal.subscriptions.SubscriptionModel");
            this.createSubscriptionAndAddToSubscriptionList((SubscriptionModel)model);
        } else {
            if (subscription instanceof PushSubscription) {
                ((PushSubscription)subscription).getChangeHandlersNotifier().fireOnMain((Function1<IPushSubscriptionObserver, Unit>)((Function1)new Function1<IPushSubscriptionObserver, Unit>(subscription){
                    final /* synthetic */ ISubscription $subscription;
                    {
                        this.$subscription = $subscription;
                        super(1);
                    }

                    public final void invoke(@NotNull IPushSubscriptionObserver it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.onPushSubscriptionChange(new PushSubscriptionChangedState(((PushSubscription)this.$subscription).getSavedState(), ((PushSubscription)this.$subscription).refreshState()));
                    }
                }));
            }
            this.events.fire((Function1<ISubscriptionChangedHandler, Unit>)((Function1)new Function1<ISubscriptionChangedHandler, Unit>(subscription, args){
                final /* synthetic */ ISubscription $subscription;
                final /* synthetic */ ModelChangedArgs $args;
                {
                    this.$subscription = $subscription;
                    this.$args = $args;
                    super(1);
                }

                public final void invoke(@NotNull ISubscriptionChangedHandler it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onSubscriptionChanged(this.$subscription, this.$args);
                }
            }));
        }
    }

    @Override
    public void onModelRemoved(@NotNull SubscriptionModel model, @NotNull String tag) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Iterable $this$firstOrNull$iv = this.getSubscriptions().getCollection();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ISubscription it = (ISubscription)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)model.getId())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ISubscription subscription = v0;
        if (subscription != null) {
            this.removeSubscriptionFromSubscriptionList(subscription);
        }
    }

    private final void createSubscriptionAndAddToSubscriptionList(SubscriptionModel subscriptionModel) {
        ISubscription subscription = this.createSubscriptionFromModel(subscriptionModel);
        List subscriptions = CollectionsKt.toMutableList((Collection)this.getSubscriptions().getCollection());
        if (subscriptionModel.getType() == SubscriptionType.PUSH) {
            IPushSubscription iPushSubscription = this.getSubscriptions().getPush();
            Intrinsics.checkNotNull((Object)iPushSubscription, (String)"null cannot be cast to non-null type com.onesignal.user.internal.PushSubscription");
            PushSubscription existingPushSubscription = (PushSubscription)iPushSubscription;
            Intrinsics.checkNotNull((Object)subscription, (String)"null cannot be cast to non-null type com.onesignal.user.internal.PushSubscription");
            ((PushSubscription)subscription).getChangeHandlersNotifier().subscribeAll(existingPushSubscription.getChangeHandlersNotifier());
            subscriptions.remove(existingPushSubscription);
        }
        subscriptions.add(subscription);
        this.setSubscriptions(new SubscriptionList(subscriptions, new UninitializedPushSubscription()));
        this.events.fire((Function1<ISubscriptionChangedHandler, Unit>)((Function1)new Function1<ISubscriptionChangedHandler, Unit>(subscription){
            final /* synthetic */ ISubscription $subscription;
            {
                this.$subscription = $subscription;
                super(1);
            }

            public final void invoke(@NotNull ISubscriptionChangedHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onSubscriptionAdded(this.$subscription);
            }
        }));
    }

    private final void removeSubscriptionFromSubscriptionList(ISubscription subscription) {
        List subscriptions = CollectionsKt.toMutableList((Collection)this.getSubscriptions().getCollection());
        subscriptions.remove(subscription);
        this.setSubscriptions(new SubscriptionList(subscriptions, new UninitializedPushSubscription()));
        this.events.fire((Function1<ISubscriptionChangedHandler, Unit>)((Function1)new Function1<ISubscriptionChangedHandler, Unit>(subscription){
            final /* synthetic */ ISubscription $subscription;
            {
                this.$subscription = $subscription;
                super(1);
            }

            public final void invoke(@NotNull ISubscriptionChangedHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onSubscriptionRemoved(this.$subscription);
            }
        }));
    }

    private final ISubscription createSubscriptionFromModel(SubscriptionModel subscriptionModel) {
        ISubscription iSubscription;
        switch (WhenMappings.$EnumSwitchMapping$0[subscriptionModel.getType().ordinal()]) {
            case 1: {
                iSubscription = new SmsSubscription(subscriptionModel);
                break;
            }
            case 2: {
                iSubscription = new EmailSubscription(subscriptionModel);
                break;
            }
            case 3: {
                iSubscription = new PushSubscription(subscriptionModel);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iSubscription;
    }

    private final void refreshPushSubscriptionState() {
        block2: {
            String appVersion2;
            String carrier2;
            IPushSubscription pushSub = this.getSubscriptions().getPush();
            if (pushSub instanceof UninitializedPushSubscription) {
                return;
            }
            Intrinsics.checkNotNull((Object)pushSub, (String)"null cannot be cast to non-null type com.onesignal.user.internal.Subscription");
            SubscriptionModel pushSubModel = ((Subscription)((Object)pushSub)).getModel();
            pushSubModel.setSdk("050113");
            String string2 = Build.VERSION.RELEASE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RELEASE");
            pushSubModel.setDeviceOS(string2);
            String string3 = carrier2 = DeviceUtils.INSTANCE.getCarrierName(this._applicationService.getAppContext());
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                pushSubModel.setCarrier(carrier2);
            }
            String string4 = appVersion2 = AndroidUtils.INSTANCE.getAppVersion(this._applicationService.getAppContext());
            if (string4 == null) break block2;
            String it = string4;
            boolean bl = false;
            pushSubModel.setAppVersion(appVersion2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SubscriptionType.values().length];
            nArray[SubscriptionType.SMS.ordinal()] = 1;
            nArray[SubscriptionType.EMAIL.ordinal()] = 2;
            nArray[SubscriptionType.PUSH.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

