/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.builder.DefaultPolicyRuleBuilder;
import com.okta.sdk.resource.GroupCondition;
import com.okta.sdk.resource.OktaSignOnPolicyFactorPromptMode;
import com.okta.sdk.resource.OktaSignOnPolicyRule;
import com.okta.sdk.resource.OktaSignOnPolicyRuleActions;
import com.okta.sdk.resource.OktaSignOnPolicyRuleConditions;
import com.okta.sdk.resource.OktaSignOnPolicyRuleSignonActions;
import com.okta.sdk.resource.OktaSignOnPolicyRuleSignonSessionActions;
import com.okta.sdk.resource.Policy;
import com.okta.sdk.resource.PolicyAccess;
import com.okta.sdk.resource.PolicyNetworkCondition;
import com.okta.sdk.resource.PolicyNetworkConnection;
import com.okta.sdk.resource.PolicyPeopleCondition;
import com.okta.sdk.resource.PolicyRule;
import com.okta.sdk.resource.PolicyRuleAuthContextCondition;
import com.okta.sdk.resource.PolicyRuleAuthContextType;
import com.okta.sdk.resource.PolicyRuleType;
import com.okta.sdk.resource.UserCondition;
import com.okta.sdk.resource.builder.SignOnPolicyRuleBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultSignOnPolicyRuleBuilder
extends DefaultPolicyRuleBuilder<SignOnPolicyRuleBuilder>
implements SignOnPolicyRuleBuilder {
    private String name;
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();
    private PolicyAccess access;
    private Integer factorLifetime;
    private OktaSignOnPolicyFactorPromptMode factorPromptMode;
    private Boolean rememberDeviceByDefault;
    private Boolean requireFactor;
    private Integer maxSessionIdleMinutes;
    private Integer maxSessionLifetimeMinutes;
    private Boolean usePersistentCookie;
    private PolicyRuleAuthContextType authType;
    private PolicyNetworkConnection connection;

    public SignOnPolicyRuleBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SignOnPolicyRuleBuilder setAccess(PolicyAccess access) {
        this.access = access;
        return this;
    }

    public SignOnPolicyRuleBuilder setFactorLifetime(Integer factorLifetime) {
        this.factorLifetime = factorLifetime;
        return this;
    }

    public SignOnPolicyRuleBuilder setFactorPromptMode(OktaSignOnPolicyFactorPromptMode factorPromptMode) {
        this.factorPromptMode = factorPromptMode;
        return this;
    }

    public SignOnPolicyRuleBuilder setRememberDeviceByDefault(Boolean rememberDeviceByDefault) {
        this.rememberDeviceByDefault = rememberDeviceByDefault;
        return this;
    }

    public SignOnPolicyRuleBuilder setRequireFactor(Boolean requireFactor) {
        this.requireFactor = requireFactor;
        return this;
    }

    public SignOnPolicyRuleBuilder setMaxSessionIdleMinutes(Integer maxSessionIdleMinutes) {
        this.maxSessionIdleMinutes = maxSessionIdleMinutes;
        return this;
    }

    public SignOnPolicyRuleBuilder setMaxSessionLifetimeMinutes(Integer maxSessionLifetimeMinutes) {
        this.maxSessionLifetimeMinutes = maxSessionLifetimeMinutes;
        return this;
    }

    public SignOnPolicyRuleBuilder setUsePersistentCookie(Boolean usePersistentCookie) {
        this.usePersistentCookie = usePersistentCookie;
        return this;
    }

    public SignOnPolicyRuleBuilder setAuthType(PolicyRuleAuthContextType authType) {
        this.authType = authType;
        return this;
    }

    public SignOnPolicyRuleBuilder setNetworkConnection(PolicyNetworkConnection connection) {
        this.connection = connection;
        return this;
    }

    public SignOnPolicyRuleBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public SignOnPolicyRuleBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public SignOnPolicyRuleBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public SignOnPolicyRuleBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public OktaSignOnPolicyRule buildAndCreate(Client client, Policy policy) {
        return (OktaSignOnPolicyRule)client.createPolicyRule((PolicyRule)this.build(client), policy.getId());
    }

    private OktaSignOnPolicyRule build(Client client) {
        OktaSignOnPolicyRule policyRule = (OktaSignOnPolicyRule)client.instantiate(OktaSignOnPolicyRule.class);
        if (Strings.hasText((String)this.name)) {
            policyRule.setName(this.name);
        }
        if (Objects.nonNull(this.priority)) {
            policyRule.setPriority(this.priority);
        }
        if (Objects.nonNull(this.status)) {
            policyRule.setStatus(this.status);
        }
        if (Objects.nonNull(this.type)) {
            if (this.type.equals((Object)PolicyRuleType.SIGN_ON)) {
                policyRule.setType(this.type);
            } else {
                throw new IllegalArgumentException("Type should be SIGN_ON while using SignOnPolicyRuleBuilder.");
            }
        }
        policyRule.setActions((OktaSignOnPolicyRuleActions)client.instantiate(OktaSignOnPolicyRuleActions.class));
        OktaSignOnPolicyRuleActions oktaSignOnPolicyRuleActions = policyRule.getActions();
        OktaSignOnPolicyRuleSignonActions oktaSignOnPolicyRuleSignonActions = (OktaSignOnPolicyRuleSignonActions)client.instantiate(OktaSignOnPolicyRuleSignonActions.class);
        if (Objects.nonNull(this.access)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setAccess(this.access));
        }
        if (Objects.nonNull(this.factorLifetime)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setFactorLifetime(this.factorLifetime));
        }
        if (Objects.nonNull(this.factorPromptMode)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setFactorPromptMode(this.factorPromptMode));
        }
        if (Objects.nonNull(this.requireFactor)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setRequireFactor(this.requireFactor));
        }
        if (Objects.nonNull(this.rememberDeviceByDefault)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setRememberDeviceByDefault(this.rememberDeviceByDefault));
        }
        OktaSignOnPolicyRuleSignonSessionActions oktaSignOnPolicyRuleSignonSessionActions = (OktaSignOnPolicyRuleSignonSessionActions)client.instantiate(OktaSignOnPolicyRuleSignonSessionActions.class);
        if (Objects.nonNull(this.maxSessionIdleMinutes)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setSession(oktaSignOnPolicyRuleSignonSessionActions.setMaxSessionIdleMinutes(this.maxSessionIdleMinutes)));
        }
        if (Objects.nonNull(this.maxSessionLifetimeMinutes)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setSession(oktaSignOnPolicyRuleSignonSessionActions.setMaxSessionLifetimeMinutes(this.maxSessionLifetimeMinutes)));
        }
        if (Objects.nonNull(this.usePersistentCookie)) {
            oktaSignOnPolicyRuleActions.setSignon(oktaSignOnPolicyRuleSignonActions.setSession(oktaSignOnPolicyRuleSignonSessionActions.setUsePersistentCookie(this.usePersistentCookie)));
        }
        policyRule.setConditions((OktaSignOnPolicyRuleConditions)client.instantiate(OktaSignOnPolicyRuleConditions.class));
        OktaSignOnPolicyRuleConditions oktaSignOnPolicyRuleConditions = policyRule.getConditions();
        if (Objects.nonNull(this.authType)) {
            oktaSignOnPolicyRuleConditions.setAuthContext(((PolicyRuleAuthContextCondition)client.instantiate(PolicyRuleAuthContextCondition.class)).setAuthType(this.authType));
        }
        PolicyNetworkCondition policyNetworkCondition = (PolicyNetworkCondition)client.instantiate(PolicyNetworkCondition.class);
        PolicyPeopleCondition policyPeopleCondition = (PolicyPeopleCondition)client.instantiate(PolicyPeopleCondition.class);
        if (Objects.nonNull(this.connection)) {
            oktaSignOnPolicyRuleConditions.setNetwork(policyNetworkCondition.setConnection(this.connection));
        }
        if (!Collections.isEmpty(this.userIds)) {
            oktaSignOnPolicyRuleConditions.setPeople(policyPeopleCondition.setUsers(((UserCondition)client.instantiate(UserCondition.class)).setInclude(this.userIds)));
        }
        if (!Collections.isEmpty(this.groupIds)) {
            oktaSignOnPolicyRuleConditions.setPeople(policyPeopleCondition.setGroups(((GroupCondition)client.instantiate(GroupCondition.class)).setInclude(this.groupIds)));
        }
        return policyRule;
    }
}

