/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.builder.DefaultPolicyRuleBuilder;
import com.okta.sdk.resource.GroupCondition;
import com.okta.sdk.resource.PasswordPolicyRule;
import com.okta.sdk.resource.PasswordPolicyRuleAction;
import com.okta.sdk.resource.PasswordPolicyRuleActions;
import com.okta.sdk.resource.PasswordPolicyRuleConditions;
import com.okta.sdk.resource.Policy;
import com.okta.sdk.resource.PolicyAccess;
import com.okta.sdk.resource.PolicyNetworkCondition;
import com.okta.sdk.resource.PolicyNetworkConnection;
import com.okta.sdk.resource.PolicyPeopleCondition;
import com.okta.sdk.resource.PolicyRule;
import com.okta.sdk.resource.PolicyRuleType;
import com.okta.sdk.resource.UserCondition;
import com.okta.sdk.resource.builder.PasswordPolicyRuleBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultPasswordPolicyRuleBuilder
extends DefaultPolicyRuleBuilder<PasswordPolicyRuleBuilder>
implements PasswordPolicyRuleBuilder {
    private String name;
    private PolicyNetworkConnection connection;
    private List<String> userIds = new ArrayList<String>();
    private List<String> groupIds = new ArrayList<String>();
    private PolicyAccess unlockAccess;
    private PolicyAccess passwordResetAccess;
    private PolicyAccess passwordChangeAccess;

    public PasswordPolicyRuleBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public PasswordPolicyRuleBuilder setNetworkConnection(PolicyNetworkConnection connection) {
        this.connection = connection;
        return this;
    }

    public PasswordPolicyRuleBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public PasswordPolicyRuleBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public PasswordPolicyRuleBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public PasswordPolicyRuleBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public PasswordPolicyRuleBuilder setSelfServiceUnlockAccess(PolicyAccess unlockAccess) {
        this.unlockAccess = unlockAccess;
        return this;
    }

    public PasswordPolicyRuleBuilder setSelfServicePasswordResetAccess(PolicyAccess passwordResetAccess) {
        this.passwordResetAccess = passwordResetAccess;
        return this;
    }

    public PasswordPolicyRuleBuilder setPasswordChangeAccess(PolicyAccess passwordChangeAccess) {
        this.passwordChangeAccess = passwordChangeAccess;
        return this;
    }

    public PasswordPolicyRule buildAndCreate(Client client, Policy policy) {
        return (PasswordPolicyRule)client.createPolicyRule((PolicyRule)this.build(client), policy.getId());
    }

    private PasswordPolicyRule build(Client client) {
        PasswordPolicyRule policyRule = (PasswordPolicyRule)client.instantiate(PasswordPolicyRule.class);
        if (Objects.nonNull(this.priority)) {
            policyRule.setPriority(this.priority);
        }
        if (Objects.nonNull(this.status)) {
            policyRule.setStatus(this.status);
        }
        if (Strings.hasText((String)this.name)) {
            policyRule.setName(this.name);
        }
        if (Objects.nonNull(this.type)) {
            if (this.type.equals((Object)PolicyRuleType.PASSWORD)) {
                policyRule.setType(this.type);
            } else {
                throw new IllegalArgumentException("Type should be specified as PASSWORD while using PasswordPolicyRuleBuilder.");
            }
        }
        policyRule.setActions((PasswordPolicyRuleActions)client.instantiate(PasswordPolicyRuleActions.class));
        PasswordPolicyRuleActions passwordPolicyRuleActions = policyRule.getActions();
        if (Objects.nonNull(this.passwordChangeAccess)) {
            passwordPolicyRuleActions.setPasswordChange(((PasswordPolicyRuleAction)client.instantiate(PasswordPolicyRuleAction.class)).setAccess(this.passwordChangeAccess));
        }
        if (Objects.nonNull(this.passwordResetAccess)) {
            passwordPolicyRuleActions.setSelfServicePasswordReset(((PasswordPolicyRuleAction)client.instantiate(PasswordPolicyRuleAction.class)).setAccess(this.passwordResetAccess));
        }
        if (Objects.nonNull(this.unlockAccess)) {
            passwordPolicyRuleActions.setSelfServiceUnlock(((PasswordPolicyRuleAction)client.instantiate(PasswordPolicyRuleAction.class)).setAccess(this.unlockAccess));
        }
        policyRule.setConditions((PasswordPolicyRuleConditions)client.instantiate(PasswordPolicyRuleConditions.class));
        PasswordPolicyRuleConditions passwordPolicyRuleConditions = policyRule.getConditions();
        PolicyNetworkCondition policyNetworkCondition = (PolicyNetworkCondition)client.instantiate(PolicyNetworkCondition.class);
        PolicyPeopleCondition policyPeopleCondition = (PolicyPeopleCondition)client.instantiate(PolicyPeopleCondition.class);
        if (Objects.nonNull(this.connection)) {
            passwordPolicyRuleConditions.setNetwork(policyNetworkCondition.setConnection(this.connection));
        }
        if (!Collections.isEmpty(this.userIds)) {
            passwordPolicyRuleConditions.setPeople(policyPeopleCondition.setUsers(((UserCondition)client.instantiate(UserCondition.class)).setInclude(this.userIds)));
        }
        if (!Collections.isEmpty(this.groupIds)) {
            passwordPolicyRuleConditions.setPeople(policyPeopleCondition.setGroups(((GroupCondition)client.instantiate(GroupCondition.class)).setInclude(this.groupIds)));
        }
        return policyRule;
    }
}

