/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.builder.DefaultApplicationBuilder;
import com.okta.sdk.resource.Application;
import com.okta.sdk.resource.ApplicationAccessibility;
import com.okta.sdk.resource.ApplicationCredentialsOAuthClient;
import com.okta.sdk.resource.ApplicationVisibility;
import com.okta.sdk.resource.ApplicationVisibilityHide;
import com.okta.sdk.resource.JsonWebKey;
import com.okta.sdk.resource.OAuthApplicationCredentials;
import com.okta.sdk.resource.OAuthEndpointAuthenticationMethod;
import com.okta.sdk.resource.OAuthGrantType;
import com.okta.sdk.resource.OAuthResponseType;
import com.okta.sdk.resource.OpenIdConnectApplication;
import com.okta.sdk.resource.OpenIdConnectApplicationConsentMethod;
import com.okta.sdk.resource.OpenIdConnectApplicationSettings;
import com.okta.sdk.resource.OpenIdConnectApplicationSettingsClient;
import com.okta.sdk.resource.OpenIdConnectApplicationSettingsClientKeys;
import com.okta.sdk.resource.OpenIdConnectApplicationType;
import com.okta.sdk.resource.builder.OIDCApplicationBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultOIDCApplicationBuilder
extends DefaultApplicationBuilder<OIDCApplicationBuilder>
implements OIDCApplicationBuilder {
    private OpenIdConnectApplicationType applicationType;
    private String clientUri;
    private OpenIdConnectApplicationConsentMethod consentMethod;
    private List<OAuthGrantType> grantTypes = new ArrayList<OAuthGrantType>();
    private String logoUri;
    private String policyUri;
    private List<String> postLogoutRedirectUris = new ArrayList<String>();
    private List<String> redirectUris = new ArrayList<String>();
    private List<OAuthResponseType> responseTypes = new ArrayList<OAuthResponseType>();
    private String tosUri;
    private String clientId;
    private String clientSecret;
    private Boolean autoKeyRotation;
    private OAuthEndpointAuthenticationMethod tokenEndpointAuthMethod;
    private List<JsonWebKey> jsonWebKeyList = new ArrayList<JsonWebKey>();

    public OIDCApplicationBuilder setApplicationType(OpenIdConnectApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public OIDCApplicationBuilder setClientUri(String clientUri) {
        this.clientUri = clientUri;
        return this;
    }

    public OIDCApplicationBuilder setConsentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        this.consentMethod = consentMethod;
        return this;
    }

    public OIDCApplicationBuilder setGrantTypes(List<OAuthGrantType> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public OIDCApplicationBuilder addGrantTypes(OAuthGrantType grantType) {
        this.grantTypes.add(grantType);
        return this;
    }

    public OIDCApplicationBuilder setLogoUri(String logoUri) {
        this.logoUri = logoUri;
        return this;
    }

    public OIDCApplicationBuilder setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
        return this;
    }

    public OIDCApplicationBuilder setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public OIDCApplicationBuilder setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OIDCApplicationBuilder addRedirectUris(String redirectUri) {
        this.redirectUris.add(redirectUri);
        return this;
    }

    public OIDCApplicationBuilder setResponseTypes(List<OAuthResponseType> responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public OIDCApplicationBuilder addResponseTypes(OAuthResponseType responseType) {
        this.responseTypes.add(responseType);
        return this;
    }

    public OIDCApplicationBuilder setTosUri(String tosUri) {
        this.tosUri = tosUri;
        return this;
    }

    public OIDCApplicationBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OIDCApplicationBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OIDCApplicationBuilder setAutoKeyRotation(Boolean autoKeyRotation) {
        this.autoKeyRotation = autoKeyRotation;
        return this;
    }

    public OIDCApplicationBuilder setTokenEndpointAuthMethod(OAuthEndpointAuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    public OIDCApplicationBuilder setJwks(List<JsonWebKey> jsonWebKeyList) {
        this.jsonWebKeyList = jsonWebKeyList;
        return this;
    }

    public OpenIdConnectApplication buildAndCreate(Client client) {
        return (OpenIdConnectApplication)client.createApplication(this.build(client));
    }

    private Application build(Client client) {
        OpenIdConnectApplication application = (OpenIdConnectApplication)client.instantiate(OpenIdConnectApplication.class);
        if (Strings.hasText((String)this.label)) {
            application.setLabel(this.label);
        }
        if (Objects.nonNull(this.signOnMode)) {
            application.setSignOnMode(this.signOnMode);
        }
        application.setAccessibility((ApplicationAccessibility)client.instantiate(ApplicationAccessibility.class));
        ApplicationAccessibility applicationAccessibility = application.getAccessibility();
        if (Strings.hasText((String)this.loginRedirectUrl)) {
            applicationAccessibility.setLoginRedirectUrl(this.loginRedirectUrl);
        }
        if (Strings.hasText((String)this.errorRedirectUrl)) {
            applicationAccessibility.setErrorRedirectUrl(this.errorRedirectUrl);
        }
        if (Objects.nonNull(this.selfService)) {
            applicationAccessibility.setSelfService(this.selfService);
        }
        application.setVisibility((ApplicationVisibility)client.instantiate(ApplicationVisibility.class));
        ApplicationVisibility applicationVisibility = application.getVisibility();
        ApplicationVisibilityHide applicationVisibilityHide = (ApplicationVisibilityHide)client.instantiate(ApplicationVisibilityHide.class);
        if (Objects.nonNull(this.iOS)) {
            applicationVisibility.setHide(applicationVisibilityHide.setIOS(this.iOS));
        }
        if (Objects.nonNull(this.web)) {
            applicationVisibility.setHide(applicationVisibilityHide.setWeb(this.web));
        }
        application.setSettings((OpenIdConnectApplicationSettings)client.instantiate(OpenIdConnectApplicationSettings.class));
        OpenIdConnectApplicationSettings openIdConnectApplicationSettings = application.getSettings();
        OpenIdConnectApplicationSettingsClient openIdConnectApplicationSettingsClient = (OpenIdConnectApplicationSettingsClient)client.instantiate(OpenIdConnectApplicationSettingsClient.class);
        if (Strings.hasText((String)this.clientUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setClientUri(this.clientUri));
        }
        if (Strings.hasText((String)this.logoUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setLogoUri(this.logoUri));
        }
        if (Strings.hasText((String)this.policyUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setPolicyUri(this.policyUri));
        }
        if (Strings.hasText((String)this.tosUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setTosUri(this.tosUri));
        }
        if (Objects.nonNull(this.postLogoutRedirectUris) && !this.postLogoutRedirectUris.isEmpty()) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setPostLogoutRedirectUris(this.postLogoutRedirectUris));
        }
        if (Objects.nonNull(this.redirectUris)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setRedirectUris(this.redirectUris));
        }
        if (!Objects.nonNull(this.responseTypes) || this.responseTypes.size() <= 0) {
            throw new IllegalArgumentException("Response Type cannot be null, value should be of type OAuthResponseType");
        }
        openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setResponseTypes(this.responseTypes));
        if (!Objects.nonNull(this.grantTypes) || this.grantTypes.size() <= 0) {
            throw new IllegalArgumentException("Grant Type cannot be null, value should be of type OAuthGrantType");
        }
        openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setGrantTypes(this.grantTypes));
        if (Objects.nonNull(this.consentMethod)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setConsentMethod(this.consentMethod));
        }
        if (!Objects.nonNull(this.applicationType)) {
            throw new IllegalArgumentException("Application Type cannot be null, value should be of type OpenIdConnectApplicationType");
        }
        openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setApplicationType(this.applicationType));
        if (this.jsonWebKeyList.size() > 0) {
            openIdConnectApplicationSettings.getOAuthClient().setJwks(((OpenIdConnectApplicationSettingsClientKeys)client.instantiate(OpenIdConnectApplicationSettingsClientKeys.class)).setKeys(this.jsonWebKeyList));
        }
        application.setCredentials((OAuthApplicationCredentials)client.instantiate(OAuthApplicationCredentials.class));
        OAuthApplicationCredentials oAuthApplicationCredentials = application.getCredentials();
        ApplicationCredentialsOAuthClient applicationCredentialsOAuthClient = (ApplicationCredentialsOAuthClient)client.instantiate(ApplicationCredentialsOAuthClient.class);
        if (Strings.hasText((String)this.clientId)) {
            oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setClientId(this.clientId));
        }
        if (Strings.hasText((String)this.clientSecret)) {
            oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setClientSecret(this.clientSecret));
        }
        if (Objects.nonNull(this.autoKeyRotation)) {
            oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setAutoKeyRotation(this.autoKeyRotation));
        }
        if (!Objects.nonNull(this.tokenEndpointAuthMethod)) {
            throw new IllegalArgumentException("Token Endpoint Auth Method cannot be null, value should be of type OAuthEndpointAuthenticationMethod");
        }
        oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setTokenEndpointAuthMethod(this.tokenEndpointAuthMethod));
        return application;
    }
}

