/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.okta.sdk.client.Client;
import com.okta.sdk.resource.InlineHook;
import com.okta.sdk.resource.InlineHookChannel;
import com.okta.sdk.resource.InlineHookChannelConfig;
import com.okta.sdk.resource.InlineHookChannelConfigAuthScheme;
import com.okta.sdk.resource.InlineHookChannelConfigHeaders;
import com.okta.sdk.resource.InlineHookChannelType;
import com.okta.sdk.resource.InlineHookType;
import com.okta.sdk.resource.builder.InlineHookBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultInlineHookBuilder
implements InlineHookBuilder {
    private static final String VERSION = "1.0.0";
    private String name;
    private InlineHookType hookType;
    private InlineHookChannelType channelType;
    private String url;
    private String authorizationHeaderValue;
    private Map<String, String> headerMap = Maps.newHashMap();

    public InlineHookBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public InlineHookBuilder setHookType(InlineHookType hookType) {
        this.hookType = hookType;
        return this;
    }

    public InlineHookBuilder setChannelType(InlineHookChannelType channelType) {
        this.channelType = channelType;
        return this;
    }

    public InlineHookBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public InlineHookBuilder setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
        return this;
    }

    public InlineHookBuilder addHeader(String name, String value) {
        this.headerMap.put(name, value);
        return this;
    }

    public InlineHook buildAndCreate(Client client) {
        ArrayList headers = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            headers.add(((InlineHookChannelConfigHeaders)client.instantiate(InlineHookChannelConfigHeaders.class)).setKey(entry.getKey()).setValue(entry.getValue()));
        }
        InlineHookChannelConfigAuthScheme inlineHookChannelConfigAuthScheme = ((InlineHookChannelConfigAuthScheme)client.instantiate(InlineHookChannelConfigAuthScheme.class)).setType("HEADER").setKey("Authorization").setValue(this.authorizationHeaderValue);
        InlineHookChannelConfig inlineHookChannelConfig = ((InlineHookChannelConfig)client.instantiate(InlineHookChannelConfig.class)).setUri(this.url).setHeaders((List)headers).setAuthScheme(inlineHookChannelConfigAuthScheme);
        InlineHookChannel inlineHookChannel = ((InlineHookChannel)client.instantiate(InlineHookChannel.class)).setType(this.channelType).setVersion(VERSION).setConfig(inlineHookChannelConfig);
        InlineHook createdInlineHook = client.createInlineHook(((InlineHook)client.instantiate(InlineHook.class)).setName(this.name).setType(this.hookType).setVersion(VERSION).setChannel(inlineHookChannel));
        return createdInlineHook;
    }
}

