/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.user.factor;

import com.okta.sdk.resource.user.factor.ActivateFactorRequest;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * UserFactor
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2023-07-07T08:50:42.885-05:00")
public class DefaultUserFactor extends AbstractInstanceResource<UserFactor> implements UserFactor {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static EnumProperty<FactorType> factorTypeProperty = new EnumProperty("factorType", FactorType.class);
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static EnumProperty<FactorProvider> providerProperty = new EnumProperty("provider", FactorProvider.class);
    private final static EnumProperty<FactorStatus> statusProperty = new EnumProperty("status", FactorStatus.class);
    private final static ResourceReference<VerifyFactorRequest> verifyProperty = new ResourceReference("verify", VerifyFactorRequest.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, factorTypeProperty, idProperty, lastUpdatedProperty, providerProperty, statusProperty, verifyProperty);

    public DefaultUserFactor(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUserFactor(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return UserFactor.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public FactorType getFactorType() {
        return  getEnumProperty(factorTypeProperty);
    }

    public UserFactor setFactorType(FactorType factorType) {
        setProperty(factorTypeProperty, factorType);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public FactorProvider getProvider() {
        return  getEnumProperty(providerProperty);
    }

    public UserFactor setProvider(FactorProvider provider) {
        setProperty(providerProperty, provider);
        return this;
    }

    public FactorStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public VerifyFactorRequest getVerify() {
        return  getResourceProperty(verifyProperty);
    }

    public UserFactor setVerify(VerifyFactorRequest verify) {
        setProperty(verifyProperty, verify);
        return this;
    }


    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    public void delete() {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/factors/" + factorId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process.
    * @param body  (optional)
    * @return UserFactor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    public UserFactor activate(ActivateFactorRequest body) {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate",
            (body != null) ? body : getDataStore().instantiate(VoidResource.class),
            this,
            UserFactor.class,
            queryArgs,
            headers);

    }

    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process.
    * @return UserFactor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    public UserFactor activate() {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            null,
            UserFactor.class,
            queryArgs,
            headers);
     }




    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (optional)
    * @param templateId  (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @param xForwardedFor  (optional)
    * @param userAgent  (optional)
    * @param acceptLanguage  (optional)
    * @return VerifyUserFactorResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    public VerifyUserFactorResponse verify(VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage) {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (templateId != null) queryArgs.put("templateId", templateId);
        if (tokenLifetimeSeconds != null) queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);

        HttpHeaders headers = new HttpHeaders();
        if (xForwardedFor != null) headers.add("X-Forwarded-For", xForwardedFor);
        if (userAgent != null) headers.add("User-Agent", userAgent);
        if (acceptLanguage != null) headers.add("Accept-Language", acceptLanguage);

        return getDataStore().create(
            "/api/v1/users/" + userId + "/factors/" + factorId + "/verify",
            (body != null) ? body : getDataStore().instantiate(VoidResource.class),
            this,
            VerifyUserFactorResponse.class,
            queryArgs,
            headers);

    }

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @return VerifyUserFactorResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    public VerifyUserFactorResponse verify() {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/factors/" + factorId + "/verify",
            getVerify() != null ? getVerify() : new DefaultVoidResource(getDataStore()),
            null,
            VerifyUserFactorResponse.class,
            queryArgs,
            headers);
     }



}
